/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVideoEncodeAV1FrameSizeKHR
extends Struct<VkVideoEncodeAV1FrameSizeKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int INTRAFRAMESIZE;
    public static final int PREDICTIVEFRAMESIZE;
    public static final int BIPREDICTIVEFRAMESIZE;

    protected VkVideoEncodeAV1FrameSizeKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkVideoEncodeAV1FrameSizeKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeAV1FrameSizeKHR(address, container);
    }

    public VkVideoEncodeAV1FrameSizeKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVideoEncodeAV1FrameSizeKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int intraFrameSize() {
        return VkVideoEncodeAV1FrameSizeKHR.nintraFrameSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int predictiveFrameSize() {
        return VkVideoEncodeAV1FrameSizeKHR.npredictiveFrameSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int bipredictiveFrameSize() {
        return VkVideoEncodeAV1FrameSizeKHR.nbipredictiveFrameSize(this.address());
    }

    public VkVideoEncodeAV1FrameSizeKHR intraFrameSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeAV1FrameSizeKHR.nintraFrameSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1FrameSizeKHR predictiveFrameSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeAV1FrameSizeKHR.npredictiveFrameSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1FrameSizeKHR bipredictiveFrameSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeAV1FrameSizeKHR.nbipredictiveFrameSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1FrameSizeKHR set(int intraFrameSize, int predictiveFrameSize, int bipredictiveFrameSize) {
        this.intraFrameSize(intraFrameSize);
        this.predictiveFrameSize(predictiveFrameSize);
        this.bipredictiveFrameSize(bipredictiveFrameSize);
        return this;
    }

    public VkVideoEncodeAV1FrameSizeKHR set(VkVideoEncodeAV1FrameSizeKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVideoEncodeAV1FrameSizeKHR malloc() {
        return new VkVideoEncodeAV1FrameSizeKHR(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkVideoEncodeAV1FrameSizeKHR calloc() {
        return new VkVideoEncodeAV1FrameSizeKHR(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkVideoEncodeAV1FrameSizeKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkVideoEncodeAV1FrameSizeKHR(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkVideoEncodeAV1FrameSizeKHR create(long address) {
        return new VkVideoEncodeAV1FrameSizeKHR(address, null);
    }

    public static @Nullable VkVideoEncodeAV1FrameSizeKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeAV1FrameSizeKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkVideoEncodeAV1FrameSizeKHR.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeAV1FrameSizeKHR.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeAV1FrameSizeKHR malloc(MemoryStack stack) {
        return new VkVideoEncodeAV1FrameSizeKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeAV1FrameSizeKHR calloc(MemoryStack stack) {
        return new VkVideoEncodeAV1FrameSizeKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nintraFrameSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)INTRAFRAMESIZE));
    }

    public static int npredictiveFrameSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)PREDICTIVEFRAMESIZE));
    }

    public static int nbipredictiveFrameSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BIPREDICTIVEFRAMESIZE));
    }

    public static void nintraFrameSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)INTRAFRAMESIZE), (int)value);
    }

    public static void npredictiveFrameSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)PREDICTIVEFRAMESIZE), (int)value);
    }

    public static void nbipredictiveFrameSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)BIPREDICTIVEFRAMESIZE), (int)value);
    }

    static {
        Struct.Layout layout = VkVideoEncodeAV1FrameSizeKHR.__struct((Struct.Member[])new Struct.Member[]{VkVideoEncodeAV1FrameSizeKHR.__member((int)4), VkVideoEncodeAV1FrameSizeKHR.__member((int)4), VkVideoEncodeAV1FrameSizeKHR.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        INTRAFRAMESIZE = layout.offsetof(0);
        PREDICTIVEFRAMESIZE = layout.offsetof(1);
        BIPREDICTIVEFRAMESIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeAV1FrameSizeKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeAV1FrameSizeKHR ELEMENT_FACTORY = VkVideoEncodeAV1FrameSizeKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkVideoEncodeAV1FrameSizeKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int intraFrameSize() {
            return VkVideoEncodeAV1FrameSizeKHR.nintraFrameSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int predictiveFrameSize() {
            return VkVideoEncodeAV1FrameSizeKHR.npredictiveFrameSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int bipredictiveFrameSize() {
            return VkVideoEncodeAV1FrameSizeKHR.nbipredictiveFrameSize(this.address());
        }

        public Buffer intraFrameSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeAV1FrameSizeKHR.nintraFrameSize(this.address(), value);
            return this;
        }

        public Buffer predictiveFrameSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeAV1FrameSizeKHR.npredictiveFrameSize(this.address(), value);
            return this;
        }

        public Buffer bipredictiveFrameSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeAV1FrameSizeKHR.nbipredictiveFrameSize(this.address(), value);
            return this;
        }
    }
}

