/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkViewport
extends Struct<VkViewport>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MINDEPTH;
    public static final int MAXDEPTH;

    protected VkViewport(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected VkViewport create(long address, @Nullable ByteBuffer container) {
        return new VkViewport(address, container);
    }

    public VkViewport(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkViewport.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkViewport.nx(this.address());
    }

    public float y() {
        return VkViewport.ny(this.address());
    }

    public float width() {
        return VkViewport.nwidth(this.address());
    }

    public float height() {
        return VkViewport.nheight(this.address());
    }

    public float minDepth() {
        return VkViewport.nminDepth(this.address());
    }

    public float maxDepth() {
        return VkViewport.nmaxDepth(this.address());
    }

    public VkViewport x(float value) {
        VkViewport.nx(this.address(), value);
        return this;
    }

    public VkViewport y(float value) {
        VkViewport.ny(this.address(), value);
        return this;
    }

    public VkViewport width(float value) {
        VkViewport.nwidth(this.address(), value);
        return this;
    }

    public VkViewport height(float value) {
        VkViewport.nheight(this.address(), value);
        return this;
    }

    public VkViewport minDepth(float value) {
        VkViewport.nminDepth(this.address(), value);
        return this;
    }

    public VkViewport maxDepth(float value) {
        VkViewport.nmaxDepth(this.address(), value);
        return this;
    }

    public VkViewport set(float x, float y, float width, float height, float minDepth, float maxDepth) {
        this.x(x);
        this.y(y);
        this.width(width);
        this.height(height);
        this.minDepth(minDepth);
        this.maxDepth(maxDepth);
        return this;
    }

    public VkViewport set(VkViewport src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkViewport malloc() {
        return new VkViewport(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static VkViewport calloc() {
        return new VkViewport(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static VkViewport create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new VkViewport(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static VkViewport create(long address) {
        return new VkViewport(address, null);
    }

    public static @Nullable VkViewport createSafe(long address) {
        return address == 0L ? null : new VkViewport(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)VkViewport.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkViewport.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkViewport mallocStack() {
        return VkViewport.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewport callocStack() {
        return VkViewport.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkViewport mallocStack(MemoryStack stack) {
        return VkViewport.malloc(stack);
    }

    @Deprecated
    public static VkViewport callocStack(MemoryStack stack) {
        return VkViewport.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkViewport.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkViewport.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkViewport.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkViewport.calloc(capacity, stack);
    }

    public static VkViewport malloc(MemoryStack stack) {
        return new VkViewport(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkViewport calloc(MemoryStack stack) {
        return new VkViewport(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X));
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y));
    }

    public static float nwidth(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)WIDTH));
    }

    public static float nheight(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)HEIGHT));
    }

    public static float nminDepth(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MINDEPTH));
    }

    public static float nmaxDepth(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)MAXDEPTH));
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)X), (float)value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)Y), (float)value);
    }

    public static void nwidth(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)WIDTH), (float)value);
    }

    public static void nheight(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)HEIGHT), (float)value);
    }

    public static void nminDepth(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MINDEPTH), (float)value);
    }

    public static void nmaxDepth(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)MAXDEPTH), (float)value);
    }

    static {
        Struct.Layout layout = VkViewport.__struct((Struct.Member[])new Struct.Member[]{VkViewport.__member((int)4), VkViewport.__member((int)4), VkViewport.__member((int)4), VkViewport.__member((int)4), VkViewport.__member((int)4), VkViewport.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
        MINDEPTH = layout.offsetof(4);
        MAXDEPTH = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkViewport, Buffer>
    implements NativeResource {
        private static final VkViewport ELEMENT_FACTORY = VkViewport.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected VkViewport getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return VkViewport.nx(this.address());
        }

        public float y() {
            return VkViewport.ny(this.address());
        }

        public float width() {
            return VkViewport.nwidth(this.address());
        }

        public float height() {
            return VkViewport.nheight(this.address());
        }

        public float minDepth() {
            return VkViewport.nminDepth(this.address());
        }

        public float maxDepth() {
            return VkViewport.nmaxDepth(this.address());
        }

        public Buffer x(float value) {
            VkViewport.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkViewport.ny(this.address(), value);
            return this;
        }

        public Buffer width(float value) {
            VkViewport.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(float value) {
            VkViewport.nheight(this.address(), value);
            return this;
        }

        public Buffer minDepth(float value) {
            VkViewport.nminDepth(this.address(), value);
            return this;
        }

        public Buffer maxDepth(float value) {
            VkViewport.nmaxDepth(this.address(), value);
            return this;
        }
    }
}

