/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1LoopFilterFlags;

public class StdVideoAV1LoopFilter
extends Struct<StdVideoAV1LoopFilter>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int LOOP_FILTER_LEVEL;
    public static final int LOOP_FILTER_SHARPNESS;
    public static final int UPDATE_REF_DELTA;
    public static final int LOOP_FILTER_REF_DELTAS;
    public static final int UPDATE_MODE_DELTA;
    public static final int LOOP_FILTER_MODE_DELTAS;

    protected StdVideoAV1LoopFilter(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoAV1LoopFilter create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1LoopFilter(address, container);
    }

    public StdVideoAV1LoopFilter(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoAV1LoopFilter.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoAV1LoopFilterFlags flags() {
        return StdVideoAV1LoopFilter.nflags(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS]")
    public ByteBuffer loop_filter_level() {
        return StdVideoAV1LoopFilter.nloop_filter_level(this.address());
    }

    @NativeType(value="uint8_t")
    public byte loop_filter_level(int index) {
        return StdVideoAV1LoopFilter.nloop_filter_level(this.address(), index);
    }

    @NativeType(value="uint8_t")
    public byte loop_filter_sharpness() {
        return StdVideoAV1LoopFilter.nloop_filter_sharpness(this.address());
    }

    @NativeType(value="uint8_t")
    public byte update_ref_delta() {
        return StdVideoAV1LoopFilter.nupdate_ref_delta(this.address());
    }

    @NativeType(value="int8_t[STD_VIDEO_AV1_TOTAL_REFS_PER_FRAME]")
    public ByteBuffer loop_filter_ref_deltas() {
        return StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address());
    }

    @NativeType(value="int8_t")
    public byte loop_filter_ref_deltas(int index) {
        return StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address(), index);
    }

    @NativeType(value="uint8_t")
    public byte update_mode_delta() {
        return StdVideoAV1LoopFilter.nupdate_mode_delta(this.address());
    }

    @NativeType(value="int8_t[STD_VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS]")
    public ByteBuffer loop_filter_mode_deltas() {
        return StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address());
    }

    @NativeType(value="int8_t")
    public byte loop_filter_mode_deltas(int index) {
        return StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address(), index);
    }

    public StdVideoAV1LoopFilter flags(StdVideoAV1LoopFilterFlags value) {
        StdVideoAV1LoopFilter.nflags(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter flags(Consumer<StdVideoAV1LoopFilterFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_level(@NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS]") ByteBuffer value) {
        StdVideoAV1LoopFilter.nloop_filter_level(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_level(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoAV1LoopFilter.nloop_filter_level(this.address(), index, value);
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_sharpness(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1LoopFilter.nloop_filter_sharpness(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter update_ref_delta(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1LoopFilter.nupdate_ref_delta(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_ref_deltas(@NativeType(value="int8_t[STD_VIDEO_AV1_TOTAL_REFS_PER_FRAME]") ByteBuffer value) {
        StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_ref_deltas(int index, @NativeType(value="int8_t") byte value) {
        StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address(), index, value);
        return this;
    }

    public StdVideoAV1LoopFilter update_mode_delta(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1LoopFilter.nupdate_mode_delta(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_mode_deltas(@NativeType(value="int8_t[STD_VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS]") ByteBuffer value) {
        StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address(), value);
        return this;
    }

    public StdVideoAV1LoopFilter loop_filter_mode_deltas(int index, @NativeType(value="int8_t") byte value) {
        StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address(), index, value);
        return this;
    }

    public StdVideoAV1LoopFilter set(StdVideoAV1LoopFilterFlags flags, ByteBuffer loop_filter_level, byte loop_filter_sharpness, byte update_ref_delta, ByteBuffer loop_filter_ref_deltas, byte update_mode_delta, ByteBuffer loop_filter_mode_deltas) {
        this.flags(flags);
        this.loop_filter_level(loop_filter_level);
        this.loop_filter_sharpness(loop_filter_sharpness);
        this.update_ref_delta(update_ref_delta);
        this.loop_filter_ref_deltas(loop_filter_ref_deltas);
        this.update_mode_delta(update_mode_delta);
        this.loop_filter_mode_deltas(loop_filter_mode_deltas);
        return this;
    }

    public StdVideoAV1LoopFilter set(StdVideoAV1LoopFilter src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoAV1LoopFilter malloc() {
        return new StdVideoAV1LoopFilter(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoAV1LoopFilter calloc() {
        return new StdVideoAV1LoopFilter(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoAV1LoopFilter create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoAV1LoopFilter(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoAV1LoopFilter create(long address) {
        return new StdVideoAV1LoopFilter(address, null);
    }

    public static @Nullable StdVideoAV1LoopFilter createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1LoopFilter(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoAV1LoopFilter.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1LoopFilter.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1LoopFilter malloc(MemoryStack stack) {
        return new StdVideoAV1LoopFilter(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1LoopFilter calloc(MemoryStack stack) {
        return new StdVideoAV1LoopFilter(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoAV1LoopFilterFlags nflags(long struct) {
        return StdVideoAV1LoopFilterFlags.create(struct + (long)FLAGS);
    }

    public static ByteBuffer nloop_filter_level(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LOOP_FILTER_LEVEL), (int)4);
    }

    public static byte nloop_filter_level(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOOP_FILTER_LEVEL + Checks.check((int)index, (int)4) * 1L));
    }

    public static byte nloop_filter_sharpness(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOOP_FILTER_SHARPNESS));
    }

    public static byte nupdate_ref_delta(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UPDATE_REF_DELTA));
    }

    public static ByteBuffer nloop_filter_ref_deltas(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LOOP_FILTER_REF_DELTAS), (int)8);
    }

    public static byte nloop_filter_ref_deltas(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOOP_FILTER_REF_DELTAS + Checks.check((int)index, (int)8) * 1L));
    }

    public static byte nupdate_mode_delta(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UPDATE_MODE_DELTA));
    }

    public static ByteBuffer nloop_filter_mode_deltas(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LOOP_FILTER_MODE_DELTAS), (int)2);
    }

    public static byte nloop_filter_mode_deltas(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)LOOP_FILTER_MODE_DELTAS + Checks.check((int)index, (int)2) * 1L));
    }

    public static void nflags(long struct, StdVideoAV1LoopFilterFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoAV1LoopFilterFlags.SIZEOF);
    }

    public static void nloop_filter_level(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LOOP_FILTER_LEVEL), (long)(value.remaining() * 1));
    }

    public static void nloop_filter_level(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOOP_FILTER_LEVEL + Checks.check((int)index, (int)4) * 1L), (byte)value);
    }

    public static void nloop_filter_sharpness(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOOP_FILTER_SHARPNESS), (byte)value);
    }

    public static void nupdate_ref_delta(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)UPDATE_REF_DELTA), (byte)value);
    }

    public static void nloop_filter_ref_deltas(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LOOP_FILTER_REF_DELTAS), (long)(value.remaining() * 1));
    }

    public static void nloop_filter_ref_deltas(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOOP_FILTER_REF_DELTAS + Checks.check((int)index, (int)8) * 1L), (byte)value);
    }

    public static void nupdate_mode_delta(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)UPDATE_MODE_DELTA), (byte)value);
    }

    public static void nloop_filter_mode_deltas(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)LOOP_FILTER_MODE_DELTAS), (long)(value.remaining() * 1));
    }

    public static void nloop_filter_mode_deltas(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)LOOP_FILTER_MODE_DELTAS + Checks.check((int)index, (int)2) * 1L), (byte)value);
    }

    static {
        Struct.Layout layout = StdVideoAV1LoopFilter.__struct((Struct.Member[])new Struct.Member[]{StdVideoAV1LoopFilter.__member((int)StdVideoAV1LoopFilterFlags.SIZEOF, (int)StdVideoAV1LoopFilterFlags.ALIGNOF), StdVideoAV1LoopFilter.__array((int)1, (int)4), StdVideoAV1LoopFilter.__member((int)1), StdVideoAV1LoopFilter.__member((int)1), StdVideoAV1LoopFilter.__array((int)1, (int)8), StdVideoAV1LoopFilter.__member((int)1), StdVideoAV1LoopFilter.__array((int)1, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        LOOP_FILTER_LEVEL = layout.offsetof(1);
        LOOP_FILTER_SHARPNESS = layout.offsetof(2);
        UPDATE_REF_DELTA = layout.offsetof(3);
        LOOP_FILTER_REF_DELTAS = layout.offsetof(4);
        UPDATE_MODE_DELTA = layout.offsetof(5);
        LOOP_FILTER_MODE_DELTAS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1LoopFilter, Buffer>
    implements NativeResource {
        private static final StdVideoAV1LoopFilter ELEMENT_FACTORY = StdVideoAV1LoopFilter.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoAV1LoopFilter getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoAV1LoopFilterFlags flags() {
            return StdVideoAV1LoopFilter.nflags(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS]")
        public ByteBuffer loop_filter_level() {
            return StdVideoAV1LoopFilter.nloop_filter_level(this.address());
        }

        @NativeType(value="uint8_t")
        public byte loop_filter_level(int index) {
            return StdVideoAV1LoopFilter.nloop_filter_level(this.address(), index);
        }

        @NativeType(value="uint8_t")
        public byte loop_filter_sharpness() {
            return StdVideoAV1LoopFilter.nloop_filter_sharpness(this.address());
        }

        @NativeType(value="uint8_t")
        public byte update_ref_delta() {
            return StdVideoAV1LoopFilter.nupdate_ref_delta(this.address());
        }

        @NativeType(value="int8_t[STD_VIDEO_AV1_TOTAL_REFS_PER_FRAME]")
        public ByteBuffer loop_filter_ref_deltas() {
            return StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address());
        }

        @NativeType(value="int8_t")
        public byte loop_filter_ref_deltas(int index) {
            return StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address(), index);
        }

        @NativeType(value="uint8_t")
        public byte update_mode_delta() {
            return StdVideoAV1LoopFilter.nupdate_mode_delta(this.address());
        }

        @NativeType(value="int8_t[STD_VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS]")
        public ByteBuffer loop_filter_mode_deltas() {
            return StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address());
        }

        @NativeType(value="int8_t")
        public byte loop_filter_mode_deltas(int index) {
            return StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address(), index);
        }

        public Buffer flags(StdVideoAV1LoopFilterFlags value) {
            StdVideoAV1LoopFilter.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoAV1LoopFilterFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer loop_filter_level(@NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_LOOP_FILTER_STRENGTHS]") ByteBuffer value) {
            StdVideoAV1LoopFilter.nloop_filter_level(this.address(), value);
            return this;
        }

        public Buffer loop_filter_level(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoAV1LoopFilter.nloop_filter_level(this.address(), index, value);
            return this;
        }

        public Buffer loop_filter_sharpness(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1LoopFilter.nloop_filter_sharpness(this.address(), value);
            return this;
        }

        public Buffer update_ref_delta(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1LoopFilter.nupdate_ref_delta(this.address(), value);
            return this;
        }

        public Buffer loop_filter_ref_deltas(@NativeType(value="int8_t[STD_VIDEO_AV1_TOTAL_REFS_PER_FRAME]") ByteBuffer value) {
            StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address(), value);
            return this;
        }

        public Buffer loop_filter_ref_deltas(int index, @NativeType(value="int8_t") byte value) {
            StdVideoAV1LoopFilter.nloop_filter_ref_deltas(this.address(), index, value);
            return this;
        }

        public Buffer update_mode_delta(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1LoopFilter.nupdate_mode_delta(this.address(), value);
            return this;
        }

        public Buffer loop_filter_mode_deltas(@NativeType(value="int8_t[STD_VIDEO_AV1_LOOP_FILTER_ADJUSTMENTS]") ByteBuffer value) {
            StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address(), value);
            return this;
        }

        public Buffer loop_filter_mode_deltas(int index, @NativeType(value="int8_t") byte value) {
            StdVideoAV1LoopFilter.nloop_filter_mode_deltas(this.address(), index, value);
            return this;
        }
    }
}

