/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoAV1Segmentation
extends Struct<StdVideoAV1Segmentation>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FEATUREENABLED;
    public static final int FEATUREDATA;

    protected StdVideoAV1Segmentation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoAV1Segmentation create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1Segmentation(address, container);
    }

    public StdVideoAV1Segmentation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoAV1Segmentation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_SEGMENTS]")
    public ByteBuffer FeatureEnabled() {
        return StdVideoAV1Segmentation.nFeatureEnabled(this.address());
    }

    @NativeType(value="uint8_t")
    public byte FeatureEnabled(int index) {
        return StdVideoAV1Segmentation.nFeatureEnabled(this.address(), index);
    }

    @NativeType(value="int16_t[STD_VIDEO_AV1_SEG_LVL_MAX]")
    public ShortBuffer FeatureData() {
        return StdVideoAV1Segmentation.nFeatureData(this.address());
    }

    @NativeType(value="int16_t")
    public short FeatureData(int index) {
        return StdVideoAV1Segmentation.nFeatureData(this.address(), index);
    }

    public StdVideoAV1Segmentation FeatureEnabled(@NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_SEGMENTS]") ByteBuffer value) {
        StdVideoAV1Segmentation.nFeatureEnabled(this.address(), value);
        return this;
    }

    public StdVideoAV1Segmentation FeatureEnabled(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoAV1Segmentation.nFeatureEnabled(this.address(), index, value);
        return this;
    }

    public StdVideoAV1Segmentation FeatureData(@NativeType(value="int16_t[STD_VIDEO_AV1_SEG_LVL_MAX]") ShortBuffer value) {
        StdVideoAV1Segmentation.nFeatureData(this.address(), value);
        return this;
    }

    public StdVideoAV1Segmentation FeatureData(int index, @NativeType(value="int16_t") short value) {
        StdVideoAV1Segmentation.nFeatureData(this.address(), index, value);
        return this;
    }

    public StdVideoAV1Segmentation set(ByteBuffer FeatureEnabled, ShortBuffer FeatureData) {
        this.FeatureEnabled(FeatureEnabled);
        this.FeatureData(FeatureData);
        return this;
    }

    public StdVideoAV1Segmentation set(StdVideoAV1Segmentation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoAV1Segmentation malloc() {
        return new StdVideoAV1Segmentation(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoAV1Segmentation calloc() {
        return new StdVideoAV1Segmentation(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoAV1Segmentation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoAV1Segmentation(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoAV1Segmentation create(long address) {
        return new StdVideoAV1Segmentation(address, null);
    }

    public static @Nullable StdVideoAV1Segmentation createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1Segmentation(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoAV1Segmentation.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1Segmentation.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1Segmentation malloc(MemoryStack stack) {
        return new StdVideoAV1Segmentation(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1Segmentation calloc(MemoryStack stack) {
        return new StdVideoAV1Segmentation(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nFeatureEnabled(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)FEATUREENABLED), (int)8);
    }

    public static byte nFeatureEnabled(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)FEATUREENABLED + Checks.check((int)index, (int)8) * 1L));
    }

    public static ShortBuffer nFeatureData(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)FEATUREDATA), (int)8);
    }

    public static short nFeatureData(long struct, int index) {
        return MemoryUtil.memGetShort((long)(struct + (long)FEATUREDATA + Checks.check((int)index, (int)8) * 2L));
    }

    public static void nFeatureEnabled(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)FEATUREENABLED), (long)(value.remaining() * 1));
    }

    public static void nFeatureEnabled(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)FEATUREENABLED + Checks.check((int)index, (int)8) * 1L), (byte)value);
    }

    public static void nFeatureData(long struct, ShortBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)8);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ShortBuffer)value), (long)(struct + (long)FEATUREDATA), (long)(value.remaining() * 2));
    }

    public static void nFeatureData(long struct, int index, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)FEATUREDATA + Checks.check((int)index, (int)8) * 2L), (short)value);
    }

    static {
        Struct.Layout layout = StdVideoAV1Segmentation.__struct((Struct.Member[])new Struct.Member[]{StdVideoAV1Segmentation.__array((int)1, (int)8), StdVideoAV1Segmentation.__array((int)2, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FEATUREENABLED = layout.offsetof(0);
        FEATUREDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1Segmentation, Buffer>
    implements NativeResource {
        private static final StdVideoAV1Segmentation ELEMENT_FACTORY = StdVideoAV1Segmentation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoAV1Segmentation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_SEGMENTS]")
        public ByteBuffer FeatureEnabled() {
            return StdVideoAV1Segmentation.nFeatureEnabled(this.address());
        }

        @NativeType(value="uint8_t")
        public byte FeatureEnabled(int index) {
            return StdVideoAV1Segmentation.nFeatureEnabled(this.address(), index);
        }

        @NativeType(value="int16_t[STD_VIDEO_AV1_SEG_LVL_MAX]")
        public ShortBuffer FeatureData() {
            return StdVideoAV1Segmentation.nFeatureData(this.address());
        }

        @NativeType(value="int16_t")
        public short FeatureData(int index) {
            return StdVideoAV1Segmentation.nFeatureData(this.address(), index);
        }

        public Buffer FeatureEnabled(@NativeType(value="uint8_t[STD_VIDEO_AV1_MAX_SEGMENTS]") ByteBuffer value) {
            StdVideoAV1Segmentation.nFeatureEnabled(this.address(), value);
            return this;
        }

        public Buffer FeatureEnabled(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoAV1Segmentation.nFeatureEnabled(this.address(), index, value);
            return this;
        }

        public Buffer FeatureData(@NativeType(value="int16_t[STD_VIDEO_AV1_SEG_LVL_MAX]") ShortBuffer value) {
            StdVideoAV1Segmentation.nFeatureData(this.address(), value);
            return this;
        }

        public Buffer FeatureData(int index, @NativeType(value="int16_t") short value) {
            StdVideoAV1Segmentation.nFeatureData(this.address(), index, value);
            return this;
        }
    }
}

