/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1TileInfoFlag;

public class StdVideoAV1TileInfo
extends Struct<StdVideoAV1TileInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int TILECOLS;
    public static final int TILEROWS;
    public static final int CONTEXT_UPDATE_TILE_ID;
    public static final int TILE_SIZE_BYTES_MINUS_1;
    public static final int RESERVED1;
    public static final int PMICOLSTARTS;
    public static final int PMIROWSTARTS;
    public static final int PWIDTHINSBSMINUS1;
    public static final int PHEIGHTINSBSMINUS1;

    protected StdVideoAV1TileInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoAV1TileInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1TileInfo(address, container);
    }

    public StdVideoAV1TileInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoAV1TileInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoAV1TileInfoFlag flags() {
        return StdVideoAV1TileInfo.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte TileCols() {
        return StdVideoAV1TileInfo.nTileCols(this.address());
    }

    @NativeType(value="uint8_t")
    public byte TileRows() {
        return StdVideoAV1TileInfo.nTileRows(this.address());
    }

    @NativeType(value="uint16_t")
    public short context_update_tile_id() {
        return StdVideoAV1TileInfo.ncontext_update_tile_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte tile_size_bytes_minus_1() {
        return StdVideoAV1TileInfo.ntile_size_bytes_minus_1(this.address());
    }

    @NativeType(value="uint16_t const *")
    public ShortBuffer pMiColStarts() {
        return StdVideoAV1TileInfo.npMiColStarts(this.address());
    }

    @NativeType(value="uint16_t const *")
    public ShortBuffer pMiRowStarts() {
        return StdVideoAV1TileInfo.npMiRowStarts(this.address());
    }

    @NativeType(value="uint16_t const *")
    public ShortBuffer pWidthInSbsMinus1() {
        return StdVideoAV1TileInfo.npWidthInSbsMinus1(this.address());
    }

    @NativeType(value="uint16_t const *")
    public ShortBuffer pHeightInSbsMinus1() {
        return StdVideoAV1TileInfo.npHeightInSbsMinus1(this.address());
    }

    public StdVideoAV1TileInfo flags(StdVideoAV1TileInfoFlag value) {
        StdVideoAV1TileInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo flags(Consumer<StdVideoAV1TileInfoFlag> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoAV1TileInfo TileCols(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1TileInfo.nTileCols(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo TileRows(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1TileInfo.nTileRows(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo context_update_tile_id(@NativeType(value="uint16_t") short value) {
        StdVideoAV1TileInfo.ncontext_update_tile_id(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo tile_size_bytes_minus_1(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1TileInfo.ntile_size_bytes_minus_1(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo pMiColStarts(@NativeType(value="uint16_t const *") ShortBuffer value) {
        StdVideoAV1TileInfo.npMiColStarts(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo pMiRowStarts(@NativeType(value="uint16_t const *") ShortBuffer value) {
        StdVideoAV1TileInfo.npMiRowStarts(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo pWidthInSbsMinus1(@NativeType(value="uint16_t const *") ShortBuffer value) {
        StdVideoAV1TileInfo.npWidthInSbsMinus1(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo pHeightInSbsMinus1(@NativeType(value="uint16_t const *") ShortBuffer value) {
        StdVideoAV1TileInfo.npHeightInSbsMinus1(this.address(), value);
        return this;
    }

    public StdVideoAV1TileInfo set(StdVideoAV1TileInfoFlag flags, byte TileCols, byte TileRows, short context_update_tile_id, byte tile_size_bytes_minus_1, ShortBuffer pMiColStarts, ShortBuffer pMiRowStarts, ShortBuffer pWidthInSbsMinus1, ShortBuffer pHeightInSbsMinus1) {
        this.flags(flags);
        this.TileCols(TileCols);
        this.TileRows(TileRows);
        this.context_update_tile_id(context_update_tile_id);
        this.tile_size_bytes_minus_1(tile_size_bytes_minus_1);
        this.pMiColStarts(pMiColStarts);
        this.pMiRowStarts(pMiRowStarts);
        this.pWidthInSbsMinus1(pWidthInSbsMinus1);
        this.pHeightInSbsMinus1(pHeightInSbsMinus1);
        return this;
    }

    public StdVideoAV1TileInfo set(StdVideoAV1TileInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoAV1TileInfo malloc() {
        return new StdVideoAV1TileInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoAV1TileInfo calloc() {
        return new StdVideoAV1TileInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoAV1TileInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoAV1TileInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoAV1TileInfo create(long address) {
        return new StdVideoAV1TileInfo(address, null);
    }

    public static @Nullable StdVideoAV1TileInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1TileInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoAV1TileInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1TileInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1TileInfo malloc(MemoryStack stack) {
        return new StdVideoAV1TileInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1TileInfo calloc(MemoryStack stack) {
        return new StdVideoAV1TileInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoAV1TileInfoFlag nflags(long struct) {
        return StdVideoAV1TileInfoFlag.create(struct + (long)FLAGS);
    }

    public static byte nTileCols(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TILECOLS));
    }

    public static byte nTileRows(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TILEROWS));
    }

    public static short ncontext_update_tile_id(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)CONTEXT_UPDATE_TILE_ID));
    }

    public static byte ntile_size_bytes_minus_1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)TILE_SIZE_BYTES_MINUS_1));
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RESERVED1), (int)7);
    }

    public static byte nreserved1(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)7) * 1L));
    }

    public static ShortBuffer npMiColStarts(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PMICOLSTARTS)), (int)Byte.toUnsignedInt(StdVideoAV1TileInfo.nTileCols(struct)));
    }

    public static ShortBuffer npMiRowStarts(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PMIROWSTARTS)), (int)Byte.toUnsignedInt(StdVideoAV1TileInfo.nTileRows(struct)));
    }

    public static ShortBuffer npWidthInSbsMinus1(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PWIDTHINSBSMINUS1)), (int)Byte.toUnsignedInt(StdVideoAV1TileInfo.nTileCols(struct)));
    }

    public static ShortBuffer npHeightInSbsMinus1(long struct) {
        return MemoryUtil.memShortBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PHEIGHTINSBSMINUS1)), (int)Byte.toUnsignedInt(StdVideoAV1TileInfo.nTileRows(struct)));
    }

    public static void nflags(long struct, StdVideoAV1TileInfoFlag value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoAV1TileInfoFlag.SIZEOF);
    }

    public static void nTileCols(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TILECOLS), (byte)value);
    }

    public static void nTileRows(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TILEROWS), (byte)value);
    }

    public static void ncontext_update_tile_id(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)CONTEXT_UPDATE_TILE_ID), (short)value);
    }

    public static void ntile_size_bytes_minus_1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)TILE_SIZE_BYTES_MINUS_1), (byte)value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)7);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)RESERVED1), (long)(value.remaining() * 1));
    }

    public static void nreserved1(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1 + Checks.check((int)index, (int)7) * 1L), (byte)value);
    }

    public static void npMiColStarts(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PMICOLSTARTS), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void npMiRowStarts(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PMIROWSTARTS), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void npWidthInSbsMinus1(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWIDTHINSBSMINUS1), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void npHeightInSbsMinus1(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PHEIGHTINSBSMINUS1), (long)MemoryUtil.memAddress((ShortBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PMICOLSTARTS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PMIROWSTARTS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWIDTHINSBSMINUS1)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PHEIGHTINSBSMINUS1)));
    }

    static {
        Struct.Layout layout = StdVideoAV1TileInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoAV1TileInfo.__member((int)StdVideoAV1TileInfoFlag.SIZEOF, (int)StdVideoAV1TileInfoFlag.ALIGNOF), StdVideoAV1TileInfo.__member((int)1), StdVideoAV1TileInfo.__member((int)1), StdVideoAV1TileInfo.__member((int)2), StdVideoAV1TileInfo.__member((int)1), StdVideoAV1TileInfo.__array((int)1, (int)7), StdVideoAV1TileInfo.__member((int)POINTER_SIZE), StdVideoAV1TileInfo.__member((int)POINTER_SIZE), StdVideoAV1TileInfo.__member((int)POINTER_SIZE), StdVideoAV1TileInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        TILECOLS = layout.offsetof(1);
        TILEROWS = layout.offsetof(2);
        CONTEXT_UPDATE_TILE_ID = layout.offsetof(3);
        TILE_SIZE_BYTES_MINUS_1 = layout.offsetof(4);
        RESERVED1 = layout.offsetof(5);
        PMICOLSTARTS = layout.offsetof(6);
        PMIROWSTARTS = layout.offsetof(7);
        PWIDTHINSBSMINUS1 = layout.offsetof(8);
        PHEIGHTINSBSMINUS1 = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1TileInfo, Buffer>
    implements NativeResource {
        private static final StdVideoAV1TileInfo ELEMENT_FACTORY = StdVideoAV1TileInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoAV1TileInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoAV1TileInfoFlag flags() {
            return StdVideoAV1TileInfo.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte TileCols() {
            return StdVideoAV1TileInfo.nTileCols(this.address());
        }

        @NativeType(value="uint8_t")
        public byte TileRows() {
            return StdVideoAV1TileInfo.nTileRows(this.address());
        }

        @NativeType(value="uint16_t")
        public short context_update_tile_id() {
            return StdVideoAV1TileInfo.ncontext_update_tile_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte tile_size_bytes_minus_1() {
            return StdVideoAV1TileInfo.ntile_size_bytes_minus_1(this.address());
        }

        @NativeType(value="uint16_t const *")
        public ShortBuffer pMiColStarts() {
            return StdVideoAV1TileInfo.npMiColStarts(this.address());
        }

        @NativeType(value="uint16_t const *")
        public ShortBuffer pMiRowStarts() {
            return StdVideoAV1TileInfo.npMiRowStarts(this.address());
        }

        @NativeType(value="uint16_t const *")
        public ShortBuffer pWidthInSbsMinus1() {
            return StdVideoAV1TileInfo.npWidthInSbsMinus1(this.address());
        }

        @NativeType(value="uint16_t const *")
        public ShortBuffer pHeightInSbsMinus1() {
            return StdVideoAV1TileInfo.npHeightInSbsMinus1(this.address());
        }

        public Buffer flags(StdVideoAV1TileInfoFlag value) {
            StdVideoAV1TileInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoAV1TileInfoFlag> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer TileCols(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1TileInfo.nTileCols(this.address(), value);
            return this;
        }

        public Buffer TileRows(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1TileInfo.nTileRows(this.address(), value);
            return this;
        }

        public Buffer context_update_tile_id(@NativeType(value="uint16_t") short value) {
            StdVideoAV1TileInfo.ncontext_update_tile_id(this.address(), value);
            return this;
        }

        public Buffer tile_size_bytes_minus_1(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1TileInfo.ntile_size_bytes_minus_1(this.address(), value);
            return this;
        }

        public Buffer pMiColStarts(@NativeType(value="uint16_t const *") ShortBuffer value) {
            StdVideoAV1TileInfo.npMiColStarts(this.address(), value);
            return this;
        }

        public Buffer pMiRowStarts(@NativeType(value="uint16_t const *") ShortBuffer value) {
            StdVideoAV1TileInfo.npMiRowStarts(this.address(), value);
            return this;
        }

        public Buffer pWidthInSbsMinus1(@NativeType(value="uint16_t const *") ShortBuffer value) {
            StdVideoAV1TileInfo.npWidthInSbsMinus1(this.address(), value);
            return this;
        }

        public Buffer pHeightInSbsMinus1(@NativeType(value="uint16_t const *") ShortBuffer value) {
            StdVideoAV1TileInfo.npHeightInSbsMinus1(this.address(), value);
            return this;
        }
    }
}

