/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1OperatingPointInfoFlags;

public class StdVideoEncodeAV1OperatingPointInfo
extends Struct<StdVideoEncodeAV1OperatingPointInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int OPERATING_POINT_IDC;
    public static final int SEQ_LEVEL_IDX;
    public static final int SEQ_TIER;
    public static final int DECODER_BUFFER_DELAY;
    public static final int ENCODER_BUFFER_DELAY;
    public static final int INITIAL_DISPLAY_DELAY_MINUS_1;

    protected StdVideoEncodeAV1OperatingPointInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeAV1OperatingPointInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeAV1OperatingPointInfo(address, container);
    }

    public StdVideoEncodeAV1OperatingPointInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeAV1OperatingPointInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeAV1OperatingPointInfoFlags flags() {
        return StdVideoEncodeAV1OperatingPointInfo.nflags(this.address());
    }

    @NativeType(value="uint16_t")
    public short operating_point_idc() {
        return StdVideoEncodeAV1OperatingPointInfo.noperating_point_idc(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_level_idx() {
        return StdVideoEncodeAV1OperatingPointInfo.nseq_level_idx(this.address());
    }

    @NativeType(value="uint8_t")
    public byte seq_tier() {
        return StdVideoEncodeAV1OperatingPointInfo.nseq_tier(this.address());
    }

    @NativeType(value="uint32_t")
    public int decoder_buffer_delay() {
        return StdVideoEncodeAV1OperatingPointInfo.ndecoder_buffer_delay(this.address());
    }

    @NativeType(value="uint32_t")
    public int encoder_buffer_delay() {
        return StdVideoEncodeAV1OperatingPointInfo.nencoder_buffer_delay(this.address());
    }

    @NativeType(value="uint8_t")
    public byte initial_display_delay_minus_1() {
        return StdVideoEncodeAV1OperatingPointInfo.ninitial_display_delay_minus_1(this.address());
    }

    public StdVideoEncodeAV1OperatingPointInfo flags(StdVideoEncodeAV1OperatingPointInfoFlags value) {
        StdVideoEncodeAV1OperatingPointInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo flags(Consumer<StdVideoEncodeAV1OperatingPointInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo operating_point_idc(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeAV1OperatingPointInfo.noperating_point_idc(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo seq_level_idx(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1OperatingPointInfo.nseq_level_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo seq_tier(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1OperatingPointInfo.nseq_tier(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo decoder_buffer_delay(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1OperatingPointInfo.ndecoder_buffer_delay(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo encoder_buffer_delay(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1OperatingPointInfo.nencoder_buffer_delay(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo initial_display_delay_minus_1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1OperatingPointInfo.ninitial_display_delay_minus_1(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo set(StdVideoEncodeAV1OperatingPointInfoFlags flags, short operating_point_idc, byte seq_level_idx, byte seq_tier, int decoder_buffer_delay, int encoder_buffer_delay, byte initial_display_delay_minus_1) {
        this.flags(flags);
        this.operating_point_idc(operating_point_idc);
        this.seq_level_idx(seq_level_idx);
        this.seq_tier(seq_tier);
        this.decoder_buffer_delay(decoder_buffer_delay);
        this.encoder_buffer_delay(encoder_buffer_delay);
        this.initial_display_delay_minus_1(initial_display_delay_minus_1);
        return this;
    }

    public StdVideoEncodeAV1OperatingPointInfo set(StdVideoEncodeAV1OperatingPointInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeAV1OperatingPointInfo malloc() {
        return new StdVideoEncodeAV1OperatingPointInfo(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeAV1OperatingPointInfo calloc() {
        return new StdVideoEncodeAV1OperatingPointInfo(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeAV1OperatingPointInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeAV1OperatingPointInfo(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeAV1OperatingPointInfo create(long address) {
        return new StdVideoEncodeAV1OperatingPointInfo(address, null);
    }

    public static @Nullable StdVideoEncodeAV1OperatingPointInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeAV1OperatingPointInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeAV1OperatingPointInfo.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeAV1OperatingPointInfo.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeAV1OperatingPointInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeAV1OperatingPointInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeAV1OperatingPointInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeAV1OperatingPointInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeAV1OperatingPointInfoFlags nflags(long struct) {
        return StdVideoEncodeAV1OperatingPointInfoFlags.create(struct + (long)FLAGS);
    }

    public static short noperating_point_idc(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)OPERATING_POINT_IDC));
    }

    public static byte nseq_level_idx(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SEQ_LEVEL_IDX));
    }

    public static byte nseq_tier(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SEQ_TIER));
    }

    public static int ndecoder_buffer_delay(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DECODER_BUFFER_DELAY));
    }

    public static int nencoder_buffer_delay(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)ENCODER_BUFFER_DELAY));
    }

    public static byte ninitial_display_delay_minus_1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)INITIAL_DISPLAY_DELAY_MINUS_1));
    }

    public static void nflags(long struct, StdVideoEncodeAV1OperatingPointInfoFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeAV1OperatingPointInfoFlags.SIZEOF);
    }

    public static void noperating_point_idc(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)OPERATING_POINT_IDC), (short)value);
    }

    public static void nseq_level_idx(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SEQ_LEVEL_IDX), (byte)value);
    }

    public static void nseq_tier(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SEQ_TIER), (byte)value);
    }

    public static void ndecoder_buffer_delay(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DECODER_BUFFER_DELAY), (int)value);
    }

    public static void nencoder_buffer_delay(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)ENCODER_BUFFER_DELAY), (int)value);
    }

    public static void ninitial_display_delay_minus_1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)INITIAL_DISPLAY_DELAY_MINUS_1), (byte)value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeAV1OperatingPointInfo.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeAV1OperatingPointInfo.__member((int)StdVideoEncodeAV1OperatingPointInfoFlags.SIZEOF, (int)StdVideoEncodeAV1OperatingPointInfoFlags.ALIGNOF), StdVideoEncodeAV1OperatingPointInfo.__member((int)2), StdVideoEncodeAV1OperatingPointInfo.__member((int)1), StdVideoEncodeAV1OperatingPointInfo.__member((int)1), StdVideoEncodeAV1OperatingPointInfo.__member((int)4), StdVideoEncodeAV1OperatingPointInfo.__member((int)4), StdVideoEncodeAV1OperatingPointInfo.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        OPERATING_POINT_IDC = layout.offsetof(1);
        SEQ_LEVEL_IDX = layout.offsetof(2);
        SEQ_TIER = layout.offsetof(3);
        DECODER_BUFFER_DELAY = layout.offsetof(4);
        ENCODER_BUFFER_DELAY = layout.offsetof(5);
        INITIAL_DISPLAY_DELAY_MINUS_1 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeAV1OperatingPointInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeAV1OperatingPointInfo ELEMENT_FACTORY = StdVideoEncodeAV1OperatingPointInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoEncodeAV1OperatingPointInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeAV1OperatingPointInfoFlags flags() {
            return StdVideoEncodeAV1OperatingPointInfo.nflags(this.address());
        }

        @NativeType(value="uint16_t")
        public short operating_point_idc() {
            return StdVideoEncodeAV1OperatingPointInfo.noperating_point_idc(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_level_idx() {
            return StdVideoEncodeAV1OperatingPointInfo.nseq_level_idx(this.address());
        }

        @NativeType(value="uint8_t")
        public byte seq_tier() {
            return StdVideoEncodeAV1OperatingPointInfo.nseq_tier(this.address());
        }

        @NativeType(value="uint32_t")
        public int decoder_buffer_delay() {
            return StdVideoEncodeAV1OperatingPointInfo.ndecoder_buffer_delay(this.address());
        }

        @NativeType(value="uint32_t")
        public int encoder_buffer_delay() {
            return StdVideoEncodeAV1OperatingPointInfo.nencoder_buffer_delay(this.address());
        }

        @NativeType(value="uint8_t")
        public byte initial_display_delay_minus_1() {
            return StdVideoEncodeAV1OperatingPointInfo.ninitial_display_delay_minus_1(this.address());
        }

        public Buffer flags(StdVideoEncodeAV1OperatingPointInfoFlags value) {
            StdVideoEncodeAV1OperatingPointInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeAV1OperatingPointInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer operating_point_idc(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeAV1OperatingPointInfo.noperating_point_idc(this.address(), value);
            return this;
        }

        public Buffer seq_level_idx(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1OperatingPointInfo.nseq_level_idx(this.address(), value);
            return this;
        }

        public Buffer seq_tier(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1OperatingPointInfo.nseq_tier(this.address(), value);
            return this;
        }

        public Buffer decoder_buffer_delay(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1OperatingPointInfo.ndecoder_buffer_delay(this.address(), value);
            return this;
        }

        public Buffer encoder_buffer_delay(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1OperatingPointInfo.nencoder_buffer_delay(this.address(), value);
            return this;
        }

        public Buffer initial_display_delay_minus_1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1OperatingPointInfo.ninitial_display_delay_minus_1(this.address(), value);
            return this;
        }
    }
}

