/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH264SliceHeaderFlags;
import org.lwjgl.vulkan.video.StdVideoEncodeH264WeightTable;

public class StdVideoEncodeH264SliceHeader
extends Struct<StdVideoEncodeH264SliceHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FIRST_MB_IN_SLICE;
    public static final int SLICE_TYPE;
    public static final int SLICE_ALPHA_C0_OFFSET_DIV2;
    public static final int SLICE_BETA_OFFSET_DIV2;
    public static final int SLICE_QP_DELTA;
    public static final int RESERVED1;
    public static final int CABAC_INIT_IDC;
    public static final int DISABLE_DEBLOCKING_FILTER_IDC;
    public static final int PWEIGHTTABLE;

    protected StdVideoEncodeH264SliceHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected StdVideoEncodeH264SliceHeader create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH264SliceHeader(address, container);
    }

    public StdVideoEncodeH264SliceHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), StdVideoEncodeH264SliceHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH264SliceHeaderFlags flags() {
        return StdVideoEncodeH264SliceHeader.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int first_mb_in_slice() {
        return StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address());
    }

    @NativeType(value="StdVideoH264SliceType")
    public int slice_type() {
        return StdVideoEncodeH264SliceHeader.nslice_type(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_alpha_c0_offset_div2() {
        return StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_beta_offset_div2() {
        return StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_qp_delta() {
        return StdVideoEncodeH264SliceHeader.nslice_qp_delta(this.address());
    }

    @NativeType(value="StdVideoH264CabacInitIdc")
    public int cabac_init_idc() {
        return StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address());
    }

    @NativeType(value="StdVideoH264DisableDeblockingFilterIdc")
    public int disable_deblocking_filter_idc() {
        return StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address());
    }

    @NativeType(value="StdVideoEncodeH264WeightTable const *")
    public StdVideoEncodeH264WeightTable pWeightTable() {
        return StdVideoEncodeH264SliceHeader.npWeightTable(this.address());
    }

    public StdVideoEncodeH264SliceHeader flags(StdVideoEncodeH264SliceHeaderFlags value) {
        StdVideoEncodeH264SliceHeader.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader flags(Consumer<StdVideoEncodeH264SliceHeaderFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH264SliceHeader first_mb_in_slice(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_type(@NativeType(value="StdVideoH264SliceType") int value) {
        StdVideoEncodeH264SliceHeader.nslice_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_alpha_c0_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader slice_qp_delta(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH264SliceHeader.nslice_qp_delta(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader cabac_init_idc(@NativeType(value="StdVideoH264CabacInitIdc") int value) {
        StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader disable_deblocking_filter_idc(@NativeType(value="StdVideoH264DisableDeblockingFilterIdc") int value) {
        StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader pWeightTable(@NativeType(value="StdVideoEncodeH264WeightTable const *") StdVideoEncodeH264WeightTable value) {
        StdVideoEncodeH264SliceHeader.npWeightTable(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264SliceHeader set(StdVideoEncodeH264SliceHeaderFlags flags, int first_mb_in_slice, int slice_type, byte slice_alpha_c0_offset_div2, byte slice_beta_offset_div2, byte slice_qp_delta, int cabac_init_idc, int disable_deblocking_filter_idc, StdVideoEncodeH264WeightTable pWeightTable) {
        this.flags(flags);
        this.first_mb_in_slice(first_mb_in_slice);
        this.slice_type(slice_type);
        this.slice_alpha_c0_offset_div2(slice_alpha_c0_offset_div2);
        this.slice_beta_offset_div2(slice_beta_offset_div2);
        this.slice_qp_delta(slice_qp_delta);
        this.cabac_init_idc(cabac_init_idc);
        this.disable_deblocking_filter_idc(disable_deblocking_filter_idc);
        this.pWeightTable(pWeightTable);
        return this;
    }

    public StdVideoEncodeH264SliceHeader set(StdVideoEncodeH264SliceHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264SliceHeader malloc() {
        return new StdVideoEncodeH264SliceHeader(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static StdVideoEncodeH264SliceHeader calloc() {
        return new StdVideoEncodeH264SliceHeader(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static StdVideoEncodeH264SliceHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new StdVideoEncodeH264SliceHeader(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static StdVideoEncodeH264SliceHeader create(long address) {
        return new StdVideoEncodeH264SliceHeader(address, null);
    }

    public static @Nullable StdVideoEncodeH264SliceHeader createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH264SliceHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)StdVideoEncodeH264SliceHeader.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264SliceHeader.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH264SliceHeader malloc(MemoryStack stack) {
        return new StdVideoEncodeH264SliceHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH264SliceHeader calloc(MemoryStack stack) {
        return new StdVideoEncodeH264SliceHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH264SliceHeaderFlags nflags(long struct) {
        return StdVideoEncodeH264SliceHeaderFlags.create(struct + (long)FLAGS);
    }

    public static int nfirst_mb_in_slice(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)FIRST_MB_IN_SLICE));
    }

    public static int nslice_type(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SLICE_TYPE));
    }

    public static byte nslice_alpha_c0_offset_div2(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SLICE_ALPHA_C0_OFFSET_DIV2));
    }

    public static byte nslice_beta_offset_div2(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SLICE_BETA_OFFSET_DIV2));
    }

    public static byte nslice_qp_delta(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SLICE_QP_DELTA));
    }

    public static byte nreserved1(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)RESERVED1));
    }

    public static int ncabac_init_idc(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)CABAC_INIT_IDC));
    }

    public static int ndisable_deblocking_filter_idc(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)DISABLE_DEBLOCKING_FILTER_IDC));
    }

    public static StdVideoEncodeH264WeightTable npWeightTable(long struct) {
        return StdVideoEncodeH264WeightTable.create(MemoryUtil.memGetAddress((long)(struct + (long)PWEIGHTTABLE)));
    }

    public static void nflags(long struct, StdVideoEncodeH264SliceHeaderFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)StdVideoEncodeH264SliceHeaderFlags.SIZEOF);
    }

    public static void nfirst_mb_in_slice(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)FIRST_MB_IN_SLICE), (int)value);
    }

    public static void nslice_type(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SLICE_TYPE), (int)value);
    }

    public static void nslice_alpha_c0_offset_div2(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SLICE_ALPHA_C0_OFFSET_DIV2), (byte)value);
    }

    public static void nslice_beta_offset_div2(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SLICE_BETA_OFFSET_DIV2), (byte)value);
    }

    public static void nslice_qp_delta(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)SLICE_QP_DELTA), (byte)value);
    }

    public static void nreserved1(long struct, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)RESERVED1), (byte)value);
    }

    public static void ncabac_init_idc(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)CABAC_INIT_IDC), (int)value);
    }

    public static void ndisable_deblocking_filter_idc(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)DISABLE_DEBLOCKING_FILTER_IDC), (int)value);
    }

    public static void npWeightTable(long struct, StdVideoEncodeH264WeightTable value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PWEIGHTTABLE), (long)value.address());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PWEIGHTTABLE)));
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264SliceHeader.__struct((Struct.Member[])new Struct.Member[]{StdVideoEncodeH264SliceHeader.__member((int)StdVideoEncodeH264SliceHeaderFlags.SIZEOF, (int)StdVideoEncodeH264SliceHeaderFlags.ALIGNOF), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)1), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)4), StdVideoEncodeH264SliceHeader.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FIRST_MB_IN_SLICE = layout.offsetof(1);
        SLICE_TYPE = layout.offsetof(2);
        SLICE_ALPHA_C0_OFFSET_DIV2 = layout.offsetof(3);
        SLICE_BETA_OFFSET_DIV2 = layout.offsetof(4);
        SLICE_QP_DELTA = layout.offsetof(5);
        RESERVED1 = layout.offsetof(6);
        CABAC_INIT_IDC = layout.offsetof(7);
        DISABLE_DEBLOCKING_FILTER_IDC = layout.offsetof(8);
        PWEIGHTTABLE = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264SliceHeader, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264SliceHeader ELEMENT_FACTORY = StdVideoEncodeH264SliceHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected StdVideoEncodeH264SliceHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH264SliceHeaderFlags flags() {
            return StdVideoEncodeH264SliceHeader.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int first_mb_in_slice() {
            return StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address());
        }

        @NativeType(value="StdVideoH264SliceType")
        public int slice_type() {
            return StdVideoEncodeH264SliceHeader.nslice_type(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_alpha_c0_offset_div2() {
            return StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_beta_offset_div2() {
            return StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_qp_delta() {
            return StdVideoEncodeH264SliceHeader.nslice_qp_delta(this.address());
        }

        @NativeType(value="StdVideoH264CabacInitIdc")
        public int cabac_init_idc() {
            return StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address());
        }

        @NativeType(value="StdVideoH264DisableDeblockingFilterIdc")
        public int disable_deblocking_filter_idc() {
            return StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address());
        }

        @NativeType(value="StdVideoEncodeH264WeightTable const *")
        public StdVideoEncodeH264WeightTable pWeightTable() {
            return StdVideoEncodeH264SliceHeader.npWeightTable(this.address());
        }

        public Buffer flags(StdVideoEncodeH264SliceHeaderFlags value) {
            StdVideoEncodeH264SliceHeader.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH264SliceHeaderFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer first_mb_in_slice(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264SliceHeader.nfirst_mb_in_slice(this.address(), value);
            return this;
        }

        public Buffer slice_type(@NativeType(value="StdVideoH264SliceType") int value) {
            StdVideoEncodeH264SliceHeader.nslice_type(this.address(), value);
            return this;
        }

        public Buffer slice_alpha_c0_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nslice_alpha_c0_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nslice_beta_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_qp_delta(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH264SliceHeader.nslice_qp_delta(this.address(), value);
            return this;
        }

        public Buffer cabac_init_idc(@NativeType(value="StdVideoH264CabacInitIdc") int value) {
            StdVideoEncodeH264SliceHeader.ncabac_init_idc(this.address(), value);
            return this;
        }

        public Buffer disable_deblocking_filter_idc(@NativeType(value="StdVideoH264DisableDeblockingFilterIdc") int value) {
            StdVideoEncodeH264SliceHeader.ndisable_deblocking_filter_idc(this.address(), value);
            return this;
        }

        public Buffer pWeightTable(@NativeType(value="StdVideoEncodeH264WeightTable const *") StdVideoEncodeH264WeightTable value) {
            StdVideoEncodeH264SliceHeader.npWeightTable(this.address(), value);
            return this;
        }
    }
}

