/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XXH64Canonical
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    XXH64Canonical(long address, ByteBuffer container) {
        super(address, container);
    }

    public XXH64Canonical(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), XXH64Canonical.checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public ByteBuffer digest() {
        return XXH64Canonical.ndigest(this.address());
    }

    public byte digest(int index) {
        return XXH64Canonical.ndigest(this.address(), index);
    }

    public static XXH64Canonical malloc() {
        return XXH64Canonical.create(MemoryUtil.nmemAlloc((long)SIZEOF));
    }

    public static XXH64Canonical calloc() {
        return XXH64Canonical.create(MemoryUtil.nmemCalloc((long)1L, (long)SIZEOF));
    }

    public static XXH64Canonical create() {
        return new XXH64Canonical(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static XXH64Canonical create(long address) {
        return address == 0L ? null : new XXH64Canonical(address, null);
    }

    public static Buffer malloc(int capacity) {
        return XXH64Canonical.create(MemoryUtil.nmemAlloc((long)(capacity * SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH64Canonical.create(MemoryUtil.nmemCalloc((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer((int)(capacity * SIZEOF)));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static XXH64Canonical mallocStack() {
        return XXH64Canonical.mallocStack(MemoryStack.stackGet());
    }

    public static XXH64Canonical callocStack() {
        return XXH64Canonical.callocStack(MemoryStack.stackGet());
    }

    public static XXH64Canonical mallocStack(MemoryStack stack) {
        return XXH64Canonical.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH64Canonical callocStack(MemoryStack stack) {
        return XXH64Canonical.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return XXH64Canonical.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return XXH64Canonical.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DIGEST), (int)8);
    }

    public static byte ndigest(long struct, int index) {
        if (Checks.CHECKS) {
            Checks.check((int)index, (int)8);
        }
        return MemoryUtil.memGetByte((long)(struct + (long)DIGEST + (long)(index * 1)));
    }

    static {
        Struct.Layout layout = XXH64Canonical.__struct((Struct.Member[])new Struct.Member[]{XXH64Canonical.__array((int)1, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH64Canonical, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected XXH64Canonical newInstance(long address) {
            return new XXH64Canonical(address, this.container);
        }

        protected int sizeof() {
            return SIZEOF;
        }

        public ByteBuffer digest() {
            return XXH64Canonical.ndigest(this.address());
        }

        public byte digest(int index) {
            return XXH64Canonical.ndigest(this.address(), index);
        }
    }
}

