/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.xxhash.LibXXHash;
import org.lwjgl.util.xxhash.XXH128Canonical;
import org.lwjgl.util.xxhash.XXH128Hash;
import org.lwjgl.util.xxhash.XXH32Canonical;
import org.lwjgl.util.xxhash.XXH32State;
import org.lwjgl.util.xxhash.XXH3State;
import org.lwjgl.util.xxhash.XXH64Canonical;
import org.lwjgl.util.xxhash.XXH64State;

public class XXHash {
    public static final int XXH_OK = 0;
    public static final int XXH_ERROR = 1;
    public static final int XXH_VERSION_MAJOR = 0;
    public static final int XXH_VERSION_MINOR = 8;
    public static final int XXH_VERSION_RELEASE = 1;
    public static final int XXH_VERSION_NUMBER = 801;
    public static final int XXH3_SECRET_SIZE_MIN = 136;
    public static final int XXH3_INTERNALBUFFER_SIZE = 256;
    public static final int XXH3_SECRET_DEFAULT_SIZE = 192;

    protected XXHash() {
        throw new UnsupportedOperationException();
    }

    public static native int nXXH32(long var0, long var2, int var4);

    @NativeType(value="XXH32_hash_t")
    public static int XXH32(@Nullable @NativeType(value="void const *") ByteBuffer input, @NativeType(value="XXH32_hash_t") int seed) {
        return XXHash.nXXH32(MemoryUtil.memAddressSafe((ByteBuffer)input), Checks.remainingSafe((Buffer)input), seed);
    }

    public static native long nXXH32_createState();

    @Nullable
    @NativeType(value="XXH32_state_t *")
    public static XXH32State XXH32_createState() {
        long __result = XXHash.nXXH32_createState();
        return XXH32State.createSafe(__result);
    }

    public static native int nXXH32_freeState(long var0);

    @NativeType(value="XXH_errorcode")
    public static int XXH32_freeState(@NativeType(value="XXH32_state_t *") XXH32State statePtr) {
        return XXHash.nXXH32_freeState(statePtr.address());
    }

    public static native void nXXH32_copyState(long var0, long var2);

    public static void XXH32_copyState(@NativeType(value="XXH32_state_t *") XXH32State dst_state, @NativeType(value="XXH32_state_t const *") XXH32State src_state) {
        XXHash.nXXH32_copyState(dst_state.address(), src_state.address());
    }

    public static native int nXXH32_reset(long var0, int var2);

    @NativeType(value="XXH_errorcode")
    public static int XXH32_reset(@NativeType(value="XXH32_state_t *") XXH32State statePtr, @NativeType(value="XXH32_hash_t") int seed) {
        return XXHash.nXXH32_reset(statePtr.address(), seed);
    }

    public static native int nXXH32_update(long var0, long var2, long var4);

    @NativeType(value="XXH_errorcode")
    public static int XXH32_update(@NativeType(value="XXH32_state_t *") XXH32State statePtr, @Nullable @NativeType(value="void const *") ByteBuffer input) {
        return XXHash.nXXH32_update(statePtr.address(), MemoryUtil.memAddressSafe((ByteBuffer)input), Checks.remainingSafe((Buffer)input));
    }

    public static native int nXXH32_digest(long var0);

    @NativeType(value="XXH32_hash_t")
    public static int XXH32_digest(@NativeType(value="XXH32_state_t const *") XXH32State statePtr) {
        return XXHash.nXXH32_digest(statePtr.address());
    }

    public static native void nXXH32_canonicalFromHash(long var0, int var2);

    public static void XXH32_canonicalFromHash(@NativeType(value="XXH32_canonical_t *") XXH32Canonical dst, @NativeType(value="XXH32_hash_t") int hash) {
        XXHash.nXXH32_canonicalFromHash(dst.address(), hash);
    }

    public static native int nXXH32_hashFromCanonical(long var0);

    @NativeType(value="XXH32_hash_t")
    public static int XXH32_hashFromCanonical(@NativeType(value="XXH32_canonical_t const *") XXH32Canonical src) {
        return XXHash.nXXH32_hashFromCanonical(src.address());
    }

    public static native long nXXH64(long var0, long var2, long var4);

    @NativeType(value="XXH64_hash_t")
    public static long XXH64(@Nullable @NativeType(value="void const *") ByteBuffer input, @NativeType(value="XXH64_hash_t") long seed) {
        return XXHash.nXXH64(MemoryUtil.memAddressSafe((ByteBuffer)input), Checks.remainingSafe((Buffer)input), seed);
    }

    public static native long nXXH64_createState();

    @Nullable
    @NativeType(value="XXH64_state_t *")
    public static XXH64State XXH64_createState() {
        long __result = XXHash.nXXH64_createState();
        return XXH64State.createSafe(__result);
    }

    public static native int nXXH64_freeState(long var0);

    @NativeType(value="XXH_errorcode")
    public static int XXH64_freeState(@NativeType(value="XXH64_state_t *") XXH64State statePtr) {
        return XXHash.nXXH64_freeState(statePtr.address());
    }

    public static native void nXXH64_copyState(long var0, long var2);

    public static void XXH64_copyState(@NativeType(value="XXH64_state_t *") XXH64State dst_state, @NativeType(value="XXH64_state_t const *") XXH64State src_state) {
        XXHash.nXXH64_copyState(dst_state.address(), src_state.address());
    }

    public static native int nXXH64_reset(long var0, long var2);

    @NativeType(value="XXH_errorcode")
    public static int XXH64_reset(@NativeType(value="XXH64_state_t *") XXH64State statePtr, @NativeType(value="XXH64_hash_t") long seed) {
        return XXHash.nXXH64_reset(statePtr.address(), seed);
    }

    public static native int nXXH64_update(long var0, long var2, long var4);

    @NativeType(value="XXH_errorcode")
    public static int XXH64_update(@NativeType(value="XXH64_state_t *") XXH64State statePtr, @Nullable @NativeType(value="void const *") ByteBuffer input) {
        return XXHash.nXXH64_update(statePtr.address(), MemoryUtil.memAddressSafe((ByteBuffer)input), Checks.remainingSafe((Buffer)input));
    }

    public static native long nXXH64_digest(long var0);

    @NativeType(value="XXH64_hash_t")
    public static long XXH64_digest(@NativeType(value="XXH64_state_t const *") XXH64State statePtr) {
        return XXHash.nXXH64_digest(statePtr.address());
    }

    public static native void nXXH64_canonicalFromHash(long var0, long var2);

    public static void XXH64_canonicalFromHash(@NativeType(value="XXH64_canonical_t *") XXH64Canonical dst, @NativeType(value="XXH64_hash_t") long hash) {
        XXHash.nXXH64_canonicalFromHash(dst.address(), hash);
    }

    public static native long nXXH64_hashFromCanonical(long var0);

    @NativeType(value="XXH64_hash_t")
    public static long XXH64_hashFromCanonical(@NativeType(value="XXH64_canonical_t const *") XXH64Canonical src) {
        return XXHash.nXXH64_hashFromCanonical(src.address());
    }

    public static native long nXXH3_64bits(long var0, long var2);

    @NativeType(value="XXH64_hash_t")
    public static long XXH3_64bits(@NativeType(value="void const *") ByteBuffer data) {
        return XXHash.nXXH3_64bits(MemoryUtil.memAddress((ByteBuffer)data), data.remaining());
    }

    public static native long nXXH3_64bits_withSeed(long var0, long var2, long var4);

    @NativeType(value="XXH64_hash_t")
    public static long XXH3_64bits_withSeed(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="XXH64_hash_t") long seed) {
        return XXHash.nXXH3_64bits_withSeed(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), seed);
    }

    public static native long nXXH3_64bits_withSecret(long var0, long var2, long var4, long var6);

    @NativeType(value="XXH64_hash_t")
    public static long XXH3_64bits_withSecret(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="void const *") ByteBuffer secret) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        return XXHash.nXXH3_64bits_withSecret(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining());
    }

    public static native long nXXH3_createState();

    @Nullable
    @NativeType(value="XXH3_state_t *")
    public static XXH3State XXH3_createState() {
        long __result = XXHash.nXXH3_createState();
        return XXH3State.createSafe(__result);
    }

    public static native int nXXH3_freeState(long var0);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_freeState(@NativeType(value="XXH3_state_t *") XXH3State statePtr) {
        return XXHash.nXXH3_freeState(statePtr.address());
    }

    public static native void nXXH3_copyState(long var0, long var2);

    public static void XXH3_copyState(@NativeType(value="XXH3_state_t *") XXH3State dst_state, @NativeType(value="XXH3_state_t const *") XXH3State srct_state) {
        XXHash.nXXH3_copyState(dst_state.address(), srct_state.address());
    }

    public static native int nXXH3_64bits_reset(long var0);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_64bits_reset(@NativeType(value="XXH3_state_t *") XXH3State statePtr) {
        return XXHash.nXXH3_64bits_reset(statePtr.address());
    }

    public static native int nXXH3_64bits_reset_withSeed(long var0, long var2);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_64bits_reset_withSeed(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="XXH64_hash_t") long seed) {
        return XXHash.nXXH3_64bits_reset_withSeed(statePtr.address(), seed);
    }

    public static native int nXXH3_64bits_reset_withSecret(long var0, long var2, long var4);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_64bits_reset_withSecret(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="void const *") ByteBuffer secret) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        return XXHash.nXXH3_64bits_reset_withSecret(statePtr.address(), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining());
    }

    public static native int nXXH3_64bits_update(long var0, long var2, long var4);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_64bits_update(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="void const *") ByteBuffer input) {
        return XXHash.nXXH3_64bits_update(statePtr.address(), MemoryUtil.memAddress((ByteBuffer)input), input.remaining());
    }

    public static native long nXXH3_64bits_digest(long var0);

    @NativeType(value="XXH64_hash_t")
    public static long XXH3_64bits_digest(@NativeType(value="XXH3_state_t const *") XXH3State statePtr) {
        return XXHash.nXXH3_64bits_digest(statePtr.address());
    }

    public static native void nXXH3_128bits(long var0, long var2, long var4);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH3_128bits(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        XXHash.nXXH3_128bits(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), __result.address());
        return __result;
    }

    public static native void nXXH3_128bits_withSeed(long var0, long var2, long var4, long var6);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH3_128bits_withSeed(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="XXH64_hash_t") long seed, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        XXHash.nXXH3_128bits_withSeed(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), seed, __result.address());
        return __result;
    }

    public static native void nXXH3_128bits_withSecret(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH3_128bits_withSecret(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="void const *") ByteBuffer secret, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        XXHash.nXXH3_128bits_withSecret(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining(), __result.address());
        return __result;
    }

    public static native int nXXH3_128bits_reset(long var0);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_128bits_reset(@NativeType(value="XXH3_state_t *") XXH3State statePtr) {
        return XXHash.nXXH3_128bits_reset(statePtr.address());
    }

    public static native int nXXH3_128bits_reset_withSeed(long var0, long var2);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_128bits_reset_withSeed(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="XXH64_hash_t") long seed) {
        return XXHash.nXXH3_128bits_reset_withSeed(statePtr.address(), seed);
    }

    public static native int nXXH3_128bits_reset_withSecret(long var0, long var2, long var4);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_128bits_reset_withSecret(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="void const *") ByteBuffer secret) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        return XXHash.nXXH3_128bits_reset_withSecret(statePtr.address(), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining());
    }

    public static native int nXXH3_128bits_update(long var0, long var2, long var4);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_128bits_update(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="void const *") ByteBuffer input) {
        return XXHash.nXXH3_128bits_update(statePtr.address(), MemoryUtil.memAddress((ByteBuffer)input), input.remaining());
    }

    public static native void nXXH3_128bits_digest(long var0, long var2);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH3_128bits_digest(@NativeType(value="XXH3_state_t const *") XXH3State statePtr, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        XXHash.nXXH3_128bits_digest(statePtr.address(), __result.address());
        return __result;
    }

    public static native int nXXH128_isEqual(long var0, long var2);

    @NativeType(value="int")
    public static boolean XXH128_isEqual(@NativeType(value="XXH128_hash_t") XXH128Hash h1, @NativeType(value="XXH128_hash_t") XXH128Hash h2) {
        return XXHash.nXXH128_isEqual(h1.address(), h2.address()) != 0;
    }

    public static native int nXXH128_cmp(long var0, long var2);

    public static int XXH128_cmp(@NativeType(value="void const *") ByteBuffer h128_1, @NativeType(value="void const *") ByteBuffer h128_2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)h128_1, (int)XXH128Hash.SIZEOF);
            Checks.check((Buffer)h128_2, (int)XXH128Hash.SIZEOF);
        }
        return XXHash.nXXH128_cmp(MemoryUtil.memAddress((ByteBuffer)h128_1), MemoryUtil.memAddress((ByteBuffer)h128_2));
    }

    public static native void nXXH128_canonicalFromHash(long var0, long var2);

    public static void XXH128_canonicalFromHash(@NativeType(value="XXH128_canonical_t *") XXH128Canonical dst, @NativeType(value="XXH128_hash_t") XXH128Hash hash) {
        XXHash.nXXH128_canonicalFromHash(dst.address(), hash.address());
    }

    public static native void nXXH128_hashFromCanonical(long var0, long var2);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH128_hashFromCanonical(@NativeType(value="XXH128_canonical_t const *") XXH128Canonical src, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        XXHash.nXXH128_hashFromCanonical(src.address(), __result.address());
        return __result;
    }

    public static native void nXXH3_INITSTATE(long var0);

    public static void XXH3_INITSTATE(@NativeType(value="XXH3_state_t *") XXH3State statePtr) {
        XXHash.nXXH3_INITSTATE(statePtr.address());
    }

    public static native void nXXH128(long var0, long var2, long var4, long var6);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH128(@NativeType(value="void const *") ByteBuffer data, @NativeType(value="XXH64_hash_t") long seed, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        XXHash.nXXH128(MemoryUtil.memAddress((ByteBuffer)data), data.remaining(), seed, __result.address());
        return __result;
    }

    public static native int nXXH3_generateSecret(long var0, long var2, long var4, long var6);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_generateSecret(@NativeType(value="void *") ByteBuffer secretBuffer, @Nullable @NativeType(value="void const *") ByteBuffer customSeed) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secretBuffer, (int)136);
        }
        return XXHash.nXXH3_generateSecret(MemoryUtil.memAddress((ByteBuffer)secretBuffer), secretBuffer.remaining(), MemoryUtil.memAddressSafe((ByteBuffer)customSeed), Checks.remainingSafe((Buffer)customSeed));
    }

    public static native void nXXH3_generateSecret_fromSeed(long var0, long var2);

    public static void XXH3_generateSecret_fromSeed(@NativeType(value="void *") ByteBuffer secretBuffer, @NativeType(value="XXH64_hash_t") long seed) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secretBuffer, (int)192);
        }
        XXHash.nXXH3_generateSecret_fromSeed(MemoryUtil.memAddress((ByteBuffer)secretBuffer), seed);
    }

    public static native long nXXH3_64bits_withSecretandSeed(long var0, long var2, long var4, long var6, long var8);

    @NativeType(value="XXH64_hash_t")
    public static long XXH3_64bits_withSecretandSeed(@Nullable @NativeType(value="void const *") ByteBuffer data, @NativeType(value="void const *") ByteBuffer secret, @NativeType(value="XXH64_hash_t") long seed) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        return XXHash.nXXH3_64bits_withSecretandSeed(MemoryUtil.memAddressSafe((ByteBuffer)data), Checks.remainingSafe((Buffer)data), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining(), seed);
    }

    public static native void nXXH3_128bits_withSecretandSeed(long var0, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="XXH128_hash_t")
    public static XXH128Hash XXH3_128bits_withSecretandSeed(@Nullable @NativeType(value="void const *") ByteBuffer input, @NativeType(value="void const *") ByteBuffer secret, @NativeType(value="XXH64_hash_t") long seed, @NativeType(value="XXH128_hash_t") XXH128Hash __result) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        XXHash.nXXH3_128bits_withSecretandSeed(MemoryUtil.memAddressSafe((ByteBuffer)input), Checks.remainingSafe((Buffer)input), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining(), seed, __result.address());
        return __result;
    }

    public static native int nXXH3_64bits_reset_withSecretandSeed(long var0, long var2, long var4, long var6);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_64bits_reset_withSecretandSeed(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="void const *") ByteBuffer secret, @NativeType(value="XXH64_hash_t") long seed64) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        return XXHash.nXXH3_64bits_reset_withSecretandSeed(statePtr.address(), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining(), seed64);
    }

    public static native int nXXH3_128bits_reset_withSecretandSeed(long var0, long var2, long var4, long var6);

    @NativeType(value="XXH_errorcode")
    public static int XXH3_128bits_reset_withSecretandSeed(@NativeType(value="XXH3_state_t *") XXH3State statePtr, @NativeType(value="void const *") ByteBuffer secret, @NativeType(value="XXH64_hash_t") long seed64) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)secret, (int)136);
        }
        return XXHash.nXXH3_128bits_reset_withSecretandSeed(statePtr.address(), MemoryUtil.memAddress((ByteBuffer)secret), secret.remaining(), seed64);
    }

    static {
        LibXXHash.initialize();
    }
}

