/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_canonical_t")
public class XXH64Canonical
extends Struct<XXH64Canonical>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DIGEST;

    protected XXH64Canonical(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XXH64Canonical create(long address, @Nullable ByteBuffer container) {
        return new XXH64Canonical(address, container);
    }

    public XXH64Canonical(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH64Canonical.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[8]")
    public ByteBuffer digest() {
        return XXH64Canonical.ndigest(this.address());
    }

    @NativeType(value="unsigned char")
    public byte digest(int index) {
        return XXH64Canonical.ndigest(this.address(), index);
    }

    public static XXH64Canonical malloc() {
        return new XXH64Canonical(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XXH64Canonical calloc() {
        return new XXH64Canonical(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XXH64Canonical create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XXH64Canonical(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XXH64Canonical create(long address) {
        return new XXH64Canonical(address, null);
    }

    public static @Nullable XXH64Canonical createSafe(long address) {
        return address == 0L ? null : new XXH64Canonical(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XXH64Canonical.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64Canonical.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH64Canonical mallocStack() {
        return XXH64Canonical.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64Canonical callocStack() {
        return XXH64Canonical.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64Canonical mallocStack(MemoryStack stack) {
        return XXH64Canonical.malloc(stack);
    }

    @Deprecated
    public static XXH64Canonical callocStack(MemoryStack stack) {
        return XXH64Canonical.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH64Canonical.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH64Canonical.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64Canonical.calloc(capacity, stack);
    }

    public static XXH64Canonical malloc(MemoryStack stack) {
        return new XXH64Canonical(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH64Canonical calloc(MemoryStack stack) {
        return new XXH64Canonical(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer ndigest(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DIGEST), (int)8);
    }

    public static byte ndigest(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)DIGEST + Checks.check((int)index, (int)8) * 1L));
    }

    static {
        Struct.Layout layout = XXH64Canonical.__struct((Struct.Member[])new Struct.Member[]{XXH64Canonical.__array((int)1, (int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DIGEST = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XXH64Canonical, Buffer>
    implements NativeResource {
        private static final XXH64Canonical ELEMENT_FACTORY = XXH64Canonical.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XXH64Canonical getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[8]")
        public ByteBuffer digest() {
            return XXH64Canonical.ndigest(this.address());
        }

        @NativeType(value="unsigned char")
        public byte digest(int index) {
            return XXH64Canonical.ndigest(this.address(), index);
        }
    }
}

