/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH64_state_t")
public class XXH64State
extends Struct<XXH64State>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN;
    public static final int V;
    public static final int MEM64;
    public static final int MEMSIZE;
    public static final int RESERVED32;
    public static final int RESERVED64;

    protected XXH64State(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XXH64State create(long address, @Nullable ByteBuffer container) {
        return new XXH64State(address, container);
    }

    public XXH64State(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH64State.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH64_hash_t")
    public long total_len() {
        return XXH64State.ntotal_len(this.address());
    }

    @NativeType(value="XXH64_hash_t[4]")
    public LongBuffer v() {
        return XXH64State.nv(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long v(int index) {
        return XXH64State.nv(this.address(), index);
    }

    @NativeType(value="XXH64_hash_t[4]")
    public LongBuffer mem64() {
        return XXH64State.nmem64(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long mem64(int index) {
        return XXH64State.nmem64(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int memsize() {
        return XXH64State.nmemsize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved32() {
        return XXH64State.nreserved32(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long reserved64() {
        return XXH64State.nreserved64(this.address());
    }

    public static XXH64State malloc() {
        return new XXH64State(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XXH64State calloc() {
        return new XXH64State(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XXH64State create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XXH64State(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XXH64State create(long address) {
        return new XXH64State(address, null);
    }

    public static @Nullable XXH64State createSafe(long address) {
        return address == 0L ? null : new XXH64State(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XXH64State.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH64State.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH64State mallocStack() {
        return XXH64State.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64State callocStack() {
        return XXH64State.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH64State mallocStack(MemoryStack stack) {
        return XXH64State.malloc(stack);
    }

    @Deprecated
    public static XXH64State callocStack(MemoryStack stack) {
        return XXH64State.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH64State.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH64State.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH64State.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH64State.calloc(capacity, stack);
    }

    public static XXH64State malloc(MemoryStack stack) {
        return new XXH64State(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH64State calloc(MemoryStack stack) {
        return new XXH64State(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ntotal_len(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)TOTAL_LEN));
    }

    public static LongBuffer nv(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)V), (int)4);
    }

    public static long nv(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)V + Checks.check((int)index, (int)4) * 8L));
    }

    public static LongBuffer nmem64(long struct) {
        return MemoryUtil.memLongBuffer((long)(struct + (long)MEM64), (int)4);
    }

    public static long nmem64(long struct, int index) {
        return MemoryUtil.memGetLong((long)(struct + (long)MEM64 + Checks.check((int)index, (int)4) * 8L));
    }

    public static int nmemsize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MEMSIZE));
    }

    public static int nreserved32(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)RESERVED32));
    }

    public static long nreserved64(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)RESERVED64));
    }

    static {
        Struct.Layout layout = XXH64State.__struct((Struct.Member[])new Struct.Member[]{XXH64State.__member((int)8), XXH64State.__array((int)8, (int)4), XXH64State.__array((int)8, (int)4), XXH64State.__member((int)4), XXH64State.__member((int)4), XXH64State.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN = layout.offsetof(0);
        V = layout.offsetof(1);
        MEM64 = layout.offsetof(2);
        MEMSIZE = layout.offsetof(3);
        RESERVED32 = layout.offsetof(4);
        RESERVED64 = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XXH64State, Buffer>
    implements NativeResource {
        private static final XXH64State ELEMENT_FACTORY = XXH64State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XXH64State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH64_hash_t")
        public long total_len() {
            return XXH64State.ntotal_len(this.address());
        }

        @NativeType(value="XXH64_hash_t[4]")
        public LongBuffer v() {
            return XXH64State.nv(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long v(int index) {
            return XXH64State.nv(this.address(), index);
        }

        @NativeType(value="XXH64_hash_t[4]")
        public LongBuffer mem64() {
            return XXH64State.nmem64(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long mem64(int index) {
            return XXH64State.nmem64(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int memsize() {
            return XXH64State.nmemsize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved32() {
            return XXH64State.nreserved32(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long reserved64() {
            return XXH64State.nreserved64(this.address());
        }
    }
}

