/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH128_hash_t")
public class XXH128Hash
extends Struct<XXH128Hash>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOW64;
    public static final int HIGH64;

    protected XXH128Hash(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected XXH128Hash create(long address, @Nullable ByteBuffer container) {
        return new XXH128Hash(address, container);
    }

    public XXH128Hash(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XXH128Hash.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH64_hash_t")
    public long low64() {
        return XXH128Hash.nlow64(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long high64() {
        return XXH128Hash.nhigh64(this.address());
    }

    public static XXH128Hash malloc() {
        return new XXH128Hash(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static XXH128Hash calloc() {
        return new XXH128Hash(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static XXH128Hash create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new XXH128Hash(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static XXH128Hash create(long address) {
        return new XXH128Hash(address, null);
    }

    public static @Nullable XXH128Hash createSafe(long address) {
        return address == 0L ? null : new XXH128Hash(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)XXH128Hash.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH128Hash.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static XXH128Hash mallocStack() {
        return XXH128Hash.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Hash callocStack() {
        return XXH128Hash.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Hash mallocStack(MemoryStack stack) {
        return XXH128Hash.malloc(stack);
    }

    @Deprecated
    public static XXH128Hash callocStack(MemoryStack stack) {
        return XXH128Hash.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH128Hash.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH128Hash.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH128Hash.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH128Hash.calloc(capacity, stack);
    }

    public static XXH128Hash malloc(MemoryStack stack) {
        return new XXH128Hash(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XXH128Hash calloc(MemoryStack stack) {
        return new XXH128Hash(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlow64(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)LOW64));
    }

    public static long nhigh64(long struct) {
        return MemoryUtil.memGetLong((long)(struct + (long)HIGH64));
    }

    static {
        Struct.Layout layout = XXH128Hash.__struct((Struct.Member[])new Struct.Member[]{XXH128Hash.__member((int)8), XXH128Hash.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOW64 = layout.offsetof(0);
        HIGH64 = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XXH128Hash, Buffer>
    implements NativeResource {
        private static final XXH128Hash ELEMENT_FACTORY = XXH128Hash.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected XXH128Hash getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH64_hash_t")
        public long low64() {
            return XXH128Hash.nlow64(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long high64() {
            return XXH128Hash.nhigh64(this.address());
        }
    }
}

