/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.CompactValue;
import org.lwjgl.util.yoga.YGFloatOptional;

public class YGStyle
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FLEX;
    public static final int FLEXGROW;
    public static final int FLEXSHRINK;
    public static final int FLEXBASIS;
    public static final int MARGIN;
    public static final int POSITIONS;
    public static final int PADDING;
    public static final int BORDER;
    public static final int GAP_;
    public static final int DIMENSIONS;
    public static final int MINDIMENSIONS;
    public static final int MAXDIMENSIONS;
    public static final int ASPECTRATIO;

    public YGStyle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGStyle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="YGDirection")
    public int direction() {
        return YGStyle.ndirection(this.address());
    }

    @NativeType(value="YGFlexDirection")
    public int flexDirection() {
        return YGStyle.nflexDirection(this.address());
    }

    @NativeType(value="YGJustify")
    public int justifyContent() {
        return YGStyle.njustifyContent(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignContent() {
        return YGStyle.nalignContent(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignItems() {
        return YGStyle.nalignItems(this.address());
    }

    @NativeType(value="YGAlign")
    public int alignSelf() {
        return YGStyle.nalignSelf(this.address());
    }

    @NativeType(value="YGPositionType")
    public int positionType() {
        return YGStyle.npositionType(this.address());
    }

    @NativeType(value="YGWrap")
    public int flexWrap() {
        return YGStyle.nflexWrap(this.address());
    }

    @NativeType(value="YGOverflow")
    public int overflow() {
        return YGStyle.noverflow(this.address());
    }

    @NativeType(value="YGDisplay")
    public int display() {
        return YGStyle.ndisplay(this.address());
    }

    public YGFloatOptional flex() {
        return YGStyle.nflex(this.address());
    }

    public YGFloatOptional flexGrow() {
        return YGStyle.nflexGrow(this.address());
    }

    public YGFloatOptional flexShrink() {
        return YGStyle.nflexShrink(this.address());
    }

    public CompactValue flexBasis() {
        return YGStyle.nflexBasis(this.address());
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer margin() {
        return YGStyle.nmargin(this.address());
    }

    public CompactValue margin(int index) {
        return YGStyle.nmargin(this.address(), index);
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer positions() {
        return YGStyle.npositions(this.address());
    }

    public CompactValue positions(int index) {
        return YGStyle.npositions(this.address(), index);
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer padding() {
        return YGStyle.npadding(this.address());
    }

    public CompactValue padding(int index) {
        return YGStyle.npadding(this.address(), index);
    }

    @NativeType(value="CompactValue[9]")
    public CompactValue.Buffer border() {
        return YGStyle.nborder(this.address());
    }

    public CompactValue border(int index) {
        return YGStyle.nborder(this.address(), index);
    }

    @NativeType(value="CompactValue[3]")
    public CompactValue.Buffer gap_() {
        return YGStyle.ngap_(this.address());
    }

    public CompactValue gap_(int index) {
        return YGStyle.ngap_(this.address(), index);
    }

    @NativeType(value="CompactValue[2]")
    public CompactValue.Buffer dimensions() {
        return YGStyle.ndimensions(this.address());
    }

    public CompactValue dimensions(int index) {
        return YGStyle.ndimensions(this.address(), index);
    }

    @NativeType(value="CompactValue[2]")
    public CompactValue.Buffer minDimensions() {
        return YGStyle.nminDimensions(this.address());
    }

    public CompactValue minDimensions(int index) {
        return YGStyle.nminDimensions(this.address(), index);
    }

    @NativeType(value="CompactValue[2]")
    public CompactValue.Buffer maxDimensions() {
        return YGStyle.nmaxDimensions(this.address());
    }

    public CompactValue maxDimensions(int index) {
        return YGStyle.nmaxDimensions(this.address(), index);
    }

    public YGFloatOptional aspectRatio() {
        return YGStyle.naspectRatio(this.address());
    }

    public static YGStyle create(long address) {
        return (YGStyle)YGStyle.wrap(YGStyle.class, (long)address);
    }

    @Nullable
    public static YGStyle createSafe(long address) {
        return address == 0L ? null : (YGStyle)YGStyle.wrap(YGStyle.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)YGStyle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)YGStyle.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndirection(long struct) {
        return YGStyle.nflags(struct) & 3;
    }

    public static int nflexDirection(long struct) {
        return YGStyle.nflags(struct) >>> 2 & 3;
    }

    public static int njustifyContent(long struct) {
        return YGStyle.nflags(struct) >>> 4 & 7;
    }

    public static int nalignContent(long struct) {
        return YGStyle.nflags(struct) >>> 7 & 7;
    }

    public static int nalignItems(long struct) {
        return YGStyle.nflags(struct) >>> 10 & 7;
    }

    public static int nalignSelf(long struct) {
        return YGStyle.nflags(struct) >>> 13 & 7;
    }

    public static int npositionType(long struct) {
        return YGStyle.nflags(struct) >>> 16 & 3;
    }

    public static int nflexWrap(long struct) {
        return YGStyle.nflags(struct) >>> 18 & 3;
    }

    public static int noverflow(long struct) {
        return YGStyle.nflags(struct) >>> 20 & 3;
    }

    public static int ndisplay(long struct) {
        return YGStyle.nflags(struct) >>> 22 & 1;
    }

    public static YGFloatOptional nflex(long struct) {
        return YGFloatOptional.create(struct + (long)FLEX);
    }

    public static YGFloatOptional nflexGrow(long struct) {
        return YGFloatOptional.create(struct + (long)FLEXGROW);
    }

    public static YGFloatOptional nflexShrink(long struct) {
        return YGFloatOptional.create(struct + (long)FLEXSHRINK);
    }

    public static CompactValue nflexBasis(long struct) {
        return CompactValue.create(struct + (long)FLEXBASIS);
    }

    public static CompactValue.Buffer nmargin(long struct) {
        return CompactValue.create(struct + (long)MARGIN, 9);
    }

    public static CompactValue nmargin(long struct, int index) {
        return CompactValue.create(struct + (long)MARGIN + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer npositions(long struct) {
        return CompactValue.create(struct + (long)POSITIONS, 9);
    }

    public static CompactValue npositions(long struct, int index) {
        return CompactValue.create(struct + (long)POSITIONS + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer npadding(long struct) {
        return CompactValue.create(struct + (long)PADDING, 9);
    }

    public static CompactValue npadding(long struct, int index) {
        return CompactValue.create(struct + (long)PADDING + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer nborder(long struct) {
        return CompactValue.create(struct + (long)BORDER, 9);
    }

    public static CompactValue nborder(long struct, int index) {
        return CompactValue.create(struct + (long)BORDER + Checks.check((int)index, (int)9) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer ngap_(long struct) {
        return CompactValue.create(struct + (long)GAP_, 3);
    }

    public static CompactValue ngap_(long struct, int index) {
        return CompactValue.create(struct + (long)GAP_ + Checks.check((int)index, (int)3) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer ndimensions(long struct) {
        return CompactValue.create(struct + (long)DIMENSIONS, 2);
    }

    public static CompactValue ndimensions(long struct, int index) {
        return CompactValue.create(struct + (long)DIMENSIONS + Checks.check((int)index, (int)2) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer nminDimensions(long struct) {
        return CompactValue.create(struct + (long)MINDIMENSIONS, 2);
    }

    public static CompactValue nminDimensions(long struct, int index) {
        return CompactValue.create(struct + (long)MINDIMENSIONS + Checks.check((int)index, (int)2) * (long)CompactValue.SIZEOF);
    }

    public static CompactValue.Buffer nmaxDimensions(long struct) {
        return CompactValue.create(struct + (long)MAXDIMENSIONS, 2);
    }

    public static CompactValue nmaxDimensions(long struct, int index) {
        return CompactValue.create(struct + (long)MAXDIMENSIONS + Checks.check((int)index, (int)2) * (long)CompactValue.SIZEOF);
    }

    public static YGFloatOptional naspectRatio(long struct) {
        return YGFloatOptional.create(struct + (long)ASPECTRATIO);
    }

    static {
        Struct.Layout layout = YGStyle.__struct((Struct.Member[])new Struct.Member[]{YGStyle.__member((int)4), YGStyle.__member((int)YGFloatOptional.SIZEOF, (int)YGFloatOptional.ALIGNOF), YGStyle.__member((int)YGFloatOptional.SIZEOF, (int)YGFloatOptional.ALIGNOF), YGStyle.__member((int)YGFloatOptional.SIZEOF, (int)YGFloatOptional.ALIGNOF), YGStyle.__member((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)9), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)9), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)9), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)9), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)3), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)2), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)2), YGStyle.__array((int)CompactValue.SIZEOF, (int)CompactValue.ALIGNOF, (int)2), YGStyle.__member((int)YGFloatOptional.SIZEOF, (int)YGFloatOptional.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FLEX = layout.offsetof(1);
        FLEXGROW = layout.offsetof(2);
        FLEXSHRINK = layout.offsetof(3);
        FLEXBASIS = layout.offsetof(4);
        MARGIN = layout.offsetof(5);
        POSITIONS = layout.offsetof(6);
        PADDING = layout.offsetof(7);
        BORDER = layout.offsetof(8);
        GAP_ = layout.offsetof(9);
        DIMENSIONS = layout.offsetof(10);
        MINDIMENSIONS = layout.offsetof(11);
        MAXDIMENSIONS = layout.offsetof(12);
        ASPECTRATIO = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<YGStyle, Buffer> {
        private static final YGStyle ELEMENT_FACTORY = YGStyle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGStyle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="YGDirection")
        public int direction() {
            return YGStyle.ndirection(this.address());
        }

        @NativeType(value="YGFlexDirection")
        public int flexDirection() {
            return YGStyle.nflexDirection(this.address());
        }

        @NativeType(value="YGJustify")
        public int justifyContent() {
            return YGStyle.njustifyContent(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignContent() {
            return YGStyle.nalignContent(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignItems() {
            return YGStyle.nalignItems(this.address());
        }

        @NativeType(value="YGAlign")
        public int alignSelf() {
            return YGStyle.nalignSelf(this.address());
        }

        @NativeType(value="YGPositionType")
        public int positionType() {
            return YGStyle.npositionType(this.address());
        }

        @NativeType(value="YGWrap")
        public int flexWrap() {
            return YGStyle.nflexWrap(this.address());
        }

        @NativeType(value="YGOverflow")
        public int overflow() {
            return YGStyle.noverflow(this.address());
        }

        @NativeType(value="YGDisplay")
        public int display() {
            return YGStyle.ndisplay(this.address());
        }

        public YGFloatOptional flex() {
            return YGStyle.nflex(this.address());
        }

        public YGFloatOptional flexGrow() {
            return YGStyle.nflexGrow(this.address());
        }

        public YGFloatOptional flexShrink() {
            return YGStyle.nflexShrink(this.address());
        }

        public CompactValue flexBasis() {
            return YGStyle.nflexBasis(this.address());
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer margin() {
            return YGStyle.nmargin(this.address());
        }

        public CompactValue margin(int index) {
            return YGStyle.nmargin(this.address(), index);
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer positions() {
            return YGStyle.npositions(this.address());
        }

        public CompactValue positions(int index) {
            return YGStyle.npositions(this.address(), index);
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer padding() {
            return YGStyle.npadding(this.address());
        }

        public CompactValue padding(int index) {
            return YGStyle.npadding(this.address(), index);
        }

        @NativeType(value="CompactValue[9]")
        public CompactValue.Buffer border() {
            return YGStyle.nborder(this.address());
        }

        public CompactValue border(int index) {
            return YGStyle.nborder(this.address(), index);
        }

        @NativeType(value="CompactValue[3]")
        public CompactValue.Buffer gap_() {
            return YGStyle.ngap_(this.address());
        }

        public CompactValue gap_(int index) {
            return YGStyle.ngap_(this.address(), index);
        }

        @NativeType(value="CompactValue[2]")
        public CompactValue.Buffer dimensions() {
            return YGStyle.ndimensions(this.address());
        }

        public CompactValue dimensions(int index) {
            return YGStyle.ndimensions(this.address(), index);
        }

        @NativeType(value="CompactValue[2]")
        public CompactValue.Buffer minDimensions() {
            return YGStyle.nminDimensions(this.address());
        }

        public CompactValue minDimensions(int index) {
            return YGStyle.nminDimensions(this.address(), index);
        }

        @NativeType(value="CompactValue[2]")
        public CompactValue.Buffer maxDimensions() {
            return YGStyle.nmaxDimensions(this.address());
        }

        public CompactValue maxDimensions(int index) {
            return YGStyle.nmaxDimensions(this.address(), index);
        }

        public YGFloatOptional aspectRatio() {
            return YGStyle.naspectRatio(this.address());
        }
    }
}

