/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGValue;

public class CompactValue
extends Struct<CompactValue> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int REPR_;
    private static final int BIAS = 0x20000000;
    private static final int PERCENT_BIT = 0x40000000;
    private static final int AUTO_BITS = 0x7FAAAAAA;
    private static final int ZERO_BITS_POINT = 2140081935;
    private static final int ZERO_BITS_PERCENT = 2139156720;

    protected CompactValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CompactValue create(long address, @Nullable ByteBuffer container) {
        return new CompactValue(address, container);
    }

    public CompactValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CompactValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int repr_() {
        return CompactValue.nrepr_(this.address());
    }

    public static CompactValue create(long address) {
        return new CompactValue(address, null);
    }

    @Nullable
    public static CompactValue createSafe(long address) {
        return address == 0L ? null : new CompactValue(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nrepr_(long struct) {
        return UNSAFE.getInt(null, struct + (long)REPR_);
    }

    public int repr() {
        return this.repr_();
    }

    public float decode() {
        int repr = this.repr_();
        switch (repr) {
            case 0x7FAAAAAA: {
                return Float.NaN;
            }
            case 2139156720: 
            case 2140081935: {
                return 0.0f;
            }
        }
        if (Float.isNaN(Float.intBitsToFloat(repr))) {
            return Float.NaN;
        }
        repr &= 0xBFFFFFFF;
        return Float.intBitsToFloat(repr += 0x20000000);
    }

    public YGValue decode(YGValue __result) {
        int repr = this.repr();
        switch (repr) {
            case 0x7FAAAAAA: {
                return __result.value(Float.NaN).unit(3);
            }
            case 2140081935: {
                return __result.value(0.0f).unit(1);
            }
            case 2139156720: {
                return __result.value(0.0f).unit(2);
            }
        }
        if (Float.isNaN(Float.intBitsToFloat(repr))) {
            return __result.value(Float.NaN).unit(0);
        }
        int data = repr;
        data &= 0xBFFFFFFF;
        return __result.value(Float.intBitsToFloat(data += 0x20000000)).unit((repr & 0x40000000) != 0 ? 2 : 1);
    }

    static {
        Struct.Layout layout = CompactValue.__struct((Struct.Member[])new Struct.Member[]{CompactValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        REPR_ = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<CompactValue, Buffer> {
        private static final CompactValue ELEMENT_FACTORY = CompactValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CompactValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int repr_() {
            return CompactValue.nrepr_(this.address());
        }
    }
}

