/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.yoga.YGBaselineFunc;
import org.lwjgl.util.yoga.YGBaselineFuncI;
import org.lwjgl.util.yoga.YGDirtiedFunc;
import org.lwjgl.util.yoga.YGDirtiedFuncI;
import org.lwjgl.util.yoga.YGLayout;
import org.lwjgl.util.yoga.YGMeasureFunc;
import org.lwjgl.util.yoga.YGMeasureFuncI;
import org.lwjgl.util.yoga.YGNodeFlags;
import org.lwjgl.util.yoga.YGPrintFunc;
import org.lwjgl.util.yoga.YGPrintFuncI;
import org.lwjgl.util.yoga.YGStyle;
import org.lwjgl.util.yoga.YGValue;

public class YGNode
extends Struct<YGNode>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CONTEXT;
    public static final int FLAGS;
    public static final int MEASURE;
    public static final int MEASURE_NOCONTEXT;
    public static final int MEASURE_WITHCONTEXT;
    public static final int BASELINE;
    public static final int BASELINE_NOCONTEXT;
    public static final int BASELINE_WITHCONTEXT;
    public static final int PRINT;
    public static final int PRINT_NOCONTEXT;
    public static final int PRINT_WITHCONTEXT;
    public static final int DIRTIED;
    public static final int STYLE;
    public static final int LAYOUT;
    public static final int LINEINDEX;
    public static final int OWNER;
    public static final int CHILDREN;
    public static final int CONFIG;
    public static final int RESOLVEDDIMENSIONS;

    protected YGNode(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected YGNode create(long address, @Nullable ByteBuffer container) {
        return new YGNode(address, container);
    }

    public YGNode(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGNode.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public long context() {
        return YGNode.ncontext(this.address());
    }

    public YGNodeFlags flags() {
        return YGNode.nflags(this.address());
    }

    @Nullable
    public YGMeasureFunc measure_noContext() {
        return YGNode.nmeasure_noContext(this.address());
    }

    @NativeType(value="MeasureWithContextFn")
    public long measure_withContext() {
        return YGNode.nmeasure_withContext(this.address());
    }

    @Nullable
    public YGBaselineFunc baseline_noContext() {
        return YGNode.nbaseline_noContext(this.address());
    }

    @NativeType(value="BaselineWithContextFn")
    public long baseline_withContext() {
        return YGNode.nbaseline_withContext(this.address());
    }

    @Nullable
    public YGPrintFunc print_noContext() {
        return YGNode.nprint_noContext(this.address());
    }

    @NativeType(value="PrintWithContextFn")
    public long print_withContext() {
        return YGNode.nprint_withContext(this.address());
    }

    @Nullable
    public YGDirtiedFunc dirtied() {
        return YGNode.ndirtied(this.address());
    }

    public YGStyle style() {
        return YGNode.nstyle(this.address());
    }

    public YGLayout layout() {
        return YGNode.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int lineIndex() {
        return YGNode.nlineIndex(this.address());
    }

    @NativeType(value="YGNodeRef")
    public long owner() {
        return YGNode.nowner(this.address());
    }

    @NativeType(value="YGConfigRef")
    public long config() {
        return YGNode.nconfig(this.address());
    }

    @NativeType(value="YGValue[2]")
    public YGValue.Buffer resolvedDimensions() {
        return YGNode.nresolvedDimensions(this.address());
    }

    public YGValue resolvedDimensions(int index) {
        return YGNode.nresolvedDimensions(this.address(), index);
    }

    public YGNode context(@NativeType(value="void *") long value) {
        YGNode.ncontext(this.address(), value);
        return this;
    }

    public YGNode flags(YGNodeFlags value) {
        YGNode.nflags(this.address(), value);
        return this;
    }

    public YGNode flags(Consumer<YGNodeFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public YGNode measure_noContext(@Nullable @NativeType(value="YGMeasureFunc") YGMeasureFuncI value) {
        YGNode.nmeasure_noContext(this.address(), value);
        return this;
    }

    public YGNode measure_withContext(@NativeType(value="MeasureWithContextFn") long value) {
        YGNode.nmeasure_withContext(this.address(), value);
        return this;
    }

    public YGNode baseline_noContext(@Nullable @NativeType(value="YGBaselineFunc") YGBaselineFuncI value) {
        YGNode.nbaseline_noContext(this.address(), value);
        return this;
    }

    public YGNode baseline_withContext(@NativeType(value="BaselineWithContextFn") long value) {
        YGNode.nbaseline_withContext(this.address(), value);
        return this;
    }

    public YGNode print_noContext(@Nullable @NativeType(value="YGPrintFunc") YGPrintFuncI value) {
        YGNode.nprint_noContext(this.address(), value);
        return this;
    }

    public YGNode print_withContext(@NativeType(value="PrintWithContextFn") long value) {
        YGNode.nprint_withContext(this.address(), value);
        return this;
    }

    public YGNode dirtied(@Nullable @NativeType(value="YGDirtiedFunc") YGDirtiedFuncI value) {
        YGNode.ndirtied(this.address(), value);
        return this;
    }

    public YGNode style(YGStyle value) {
        YGNode.nstyle(this.address(), value);
        return this;
    }

    public YGNode layout(YGLayout value) {
        YGNode.nlayout(this.address(), value);
        return this;
    }

    public YGNode lineIndex(@NativeType(value="uint32_t") int value) {
        YGNode.nlineIndex(this.address(), value);
        return this;
    }

    public YGNode owner(@NativeType(value="YGNodeRef") long value) {
        YGNode.nowner(this.address(), value);
        return this;
    }

    public YGNode config(@NativeType(value="YGConfigRef") long value) {
        YGNode.nconfig(this.address(), value);
        return this;
    }

    public YGNode resolvedDimensions(@NativeType(value="YGValue[2]") YGValue.Buffer value) {
        YGNode.nresolvedDimensions(this.address(), value);
        return this;
    }

    public YGNode resolvedDimensions(int index, YGValue value) {
        YGNode.nresolvedDimensions(this.address(), index, value);
        return this;
    }

    public YGNode resolvedDimensions(Consumer<YGValue.Buffer> consumer) {
        consumer.accept(this.resolvedDimensions());
        return this;
    }

    public YGNode resolvedDimensions(int index, Consumer<YGValue> consumer) {
        consumer.accept(this.resolvedDimensions(index));
        return this;
    }

    public YGNode set(YGNode src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGNode malloc() {
        return new YGNode(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static YGNode calloc() {
        return new YGNode(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static YGNode create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new YGNode(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static YGNode create(long address) {
        return new YGNode(address, null);
    }

    @Nullable
    public static YGNode createSafe(long address) {
        return address == 0L ? null : new YGNode(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)YGNode.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGNode.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static YGNode mallocStack() {
        return YGNode.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGNode callocStack() {
        return YGNode.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGNode mallocStack(MemoryStack stack) {
        return YGNode.malloc(stack);
    }

    @Deprecated
    public static YGNode callocStack(MemoryStack stack) {
        return YGNode.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return YGNode.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return YGNode.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGNode.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGNode.calloc(capacity, stack);
    }

    public static YGNode malloc(MemoryStack stack) {
        return new YGNode(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static YGNode calloc(MemoryStack stack) {
        return new YGNode(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncontext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONTEXT));
    }

    public static YGNodeFlags nflags(long struct) {
        return YGNodeFlags.create(struct + (long)FLAGS);
    }

    @Nullable
    public static YGMeasureFunc nmeasure_noContext(long struct) {
        return YGMeasureFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)MEASURE_NOCONTEXT)));
    }

    public static long nmeasure_withContext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)MEASURE_WITHCONTEXT));
    }

    @Nullable
    public static YGBaselineFunc nbaseline_noContext(long struct) {
        return YGBaselineFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)BASELINE_NOCONTEXT)));
    }

    public static long nbaseline_withContext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)BASELINE_WITHCONTEXT));
    }

    @Nullable
    public static YGPrintFunc nprint_noContext(long struct) {
        return YGPrintFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRINT_NOCONTEXT)));
    }

    public static long nprint_withContext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PRINT_WITHCONTEXT));
    }

    @Nullable
    public static YGDirtiedFunc ndirtied(long struct) {
        return YGDirtiedFunc.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)DIRTIED)));
    }

    public static YGStyle nstyle(long struct) {
        return YGStyle.create(struct + (long)STYLE);
    }

    public static YGLayout nlayout(long struct) {
        return YGLayout.create(struct + (long)LAYOUT);
    }

    public static int nlineIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)LINEINDEX);
    }

    public static long nowner(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)OWNER));
    }

    public static long nchildren(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CHILDREN));
    }

    public static long nconfig(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CONFIG));
    }

    public static YGValue.Buffer nresolvedDimensions(long struct) {
        return YGValue.create(struct + (long)RESOLVEDDIMENSIONS, 2);
    }

    public static YGValue nresolvedDimensions(long struct, int index) {
        return YGValue.create(struct + (long)RESOLVEDDIMENSIONS + Checks.check((int)index, (int)2) * (long)YGValue.SIZEOF);
    }

    public static void ncontext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONTEXT), (long)value);
    }

    public static void nflags(long struct, YGNodeFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)YGNodeFlags.SIZEOF);
    }

    public static void nmeasure_noContext(long struct, @Nullable YGMeasureFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEASURE_NOCONTEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nmeasure_withContext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MEASURE_WITHCONTEXT), (long)value);
    }

    public static void nbaseline_noContext(long struct, @Nullable YGBaselineFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASELINE_NOCONTEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nbaseline_withContext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BASELINE_WITHCONTEXT), (long)value);
    }

    public static void nprint_noContext(long struct, @Nullable YGPrintFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRINT_NOCONTEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nprint_withContext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRINT_WITHCONTEXT), (long)value);
    }

    public static void ndirtied(long struct, @Nullable YGDirtiedFuncI value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DIRTIED), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void nstyle(long struct, YGStyle value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)STYLE), (long)YGStyle.SIZEOF);
    }

    public static void nlayout(long struct, YGLayout value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)LAYOUT), (long)YGLayout.SIZEOF);
    }

    public static void nlineIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LINEINDEX, value);
    }

    public static void nowner(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)OWNER), (long)value);
    }

    public static void nchildren(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CHILDREN), (long)value);
    }

    public static void nconfig(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)CONFIG), (long)value);
    }

    public static void nresolvedDimensions(long struct, YGValue.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((CustomBuffer)value, (int)2);
        }
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RESOLVEDDIMENSIONS), (long)(value.remaining() * YGValue.SIZEOF));
    }

    public static void nresolvedDimensions(long struct, int index, YGValue value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)RESOLVEDDIMENSIONS + Checks.check((int)index, (int)2) * (long)YGValue.SIZEOF), (long)YGValue.SIZEOF);
    }

    static {
        Struct.Layout layout = YGNode.__struct((Struct.Member[])new Struct.Member[]{YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)YGNodeFlags.SIZEOF, (int)YGNodeFlags.ALIGNOF), YGNode.__union((Struct.Member[])new Struct.Member[]{YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)POINTER_SIZE)}), YGNode.__union((Struct.Member[])new Struct.Member[]{YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)POINTER_SIZE)}), YGNode.__union((Struct.Member[])new Struct.Member[]{YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)POINTER_SIZE)}), YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)YGStyle.SIZEOF, (int)YGStyle.ALIGNOF), YGNode.__member((int)YGLayout.SIZEOF, (int)YGLayout.ALIGNOF), YGNode.__member((int)4), YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)POINTER_SIZE), YGNode.__member((int)POINTER_SIZE), YGNode.__array((int)YGValue.SIZEOF, (int)YGValue.ALIGNOF, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CONTEXT = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        MEASURE = layout.offsetof(2);
        MEASURE_NOCONTEXT = layout.offsetof(3);
        MEASURE_WITHCONTEXT = layout.offsetof(4);
        BASELINE = layout.offsetof(5);
        BASELINE_NOCONTEXT = layout.offsetof(6);
        BASELINE_WITHCONTEXT = layout.offsetof(7);
        PRINT = layout.offsetof(8);
        PRINT_NOCONTEXT = layout.offsetof(9);
        PRINT_WITHCONTEXT = layout.offsetof(10);
        DIRTIED = layout.offsetof(11);
        STYLE = layout.offsetof(12);
        LAYOUT = layout.offsetof(13);
        LINEINDEX = layout.offsetof(14);
        OWNER = layout.offsetof(15);
        CHILDREN = layout.offsetof(16);
        CONFIG = layout.offsetof(17);
        RESOLVEDDIMENSIONS = layout.offsetof(18);
    }

    public static class Buffer
    extends StructBuffer<YGNode, Buffer>
    implements NativeResource {
        private static final YGNode ELEMENT_FACTORY = YGNode.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGNode getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public long context() {
            return YGNode.ncontext(this.address());
        }

        public YGNodeFlags flags() {
            return YGNode.nflags(this.address());
        }

        @Nullable
        public YGMeasureFunc measure_noContext() {
            return YGNode.nmeasure_noContext(this.address());
        }

        @NativeType(value="MeasureWithContextFn")
        public long measure_withContext() {
            return YGNode.nmeasure_withContext(this.address());
        }

        @Nullable
        public YGBaselineFunc baseline_noContext() {
            return YGNode.nbaseline_noContext(this.address());
        }

        @NativeType(value="BaselineWithContextFn")
        public long baseline_withContext() {
            return YGNode.nbaseline_withContext(this.address());
        }

        @Nullable
        public YGPrintFunc print_noContext() {
            return YGNode.nprint_noContext(this.address());
        }

        @NativeType(value="PrintWithContextFn")
        public long print_withContext() {
            return YGNode.nprint_withContext(this.address());
        }

        @Nullable
        public YGDirtiedFunc dirtied() {
            return YGNode.ndirtied(this.address());
        }

        public YGStyle style() {
            return YGNode.nstyle(this.address());
        }

        public YGLayout layout() {
            return YGNode.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int lineIndex() {
            return YGNode.nlineIndex(this.address());
        }

        @NativeType(value="YGNodeRef")
        public long owner() {
            return YGNode.nowner(this.address());
        }

        @NativeType(value="YGConfigRef")
        public long config() {
            return YGNode.nconfig(this.address());
        }

        @NativeType(value="YGValue[2]")
        public YGValue.Buffer resolvedDimensions() {
            return YGNode.nresolvedDimensions(this.address());
        }

        public YGValue resolvedDimensions(int index) {
            return YGNode.nresolvedDimensions(this.address(), index);
        }

        public Buffer context(@NativeType(value="void *") long value) {
            YGNode.ncontext(this.address(), value);
            return this;
        }

        public Buffer flags(YGNodeFlags value) {
            YGNode.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<YGNodeFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer measure_noContext(@Nullable @NativeType(value="YGMeasureFunc") YGMeasureFuncI value) {
            YGNode.nmeasure_noContext(this.address(), value);
            return this;
        }

        public Buffer measure_withContext(@NativeType(value="MeasureWithContextFn") long value) {
            YGNode.nmeasure_withContext(this.address(), value);
            return this;
        }

        public Buffer baseline_noContext(@Nullable @NativeType(value="YGBaselineFunc") YGBaselineFuncI value) {
            YGNode.nbaseline_noContext(this.address(), value);
            return this;
        }

        public Buffer baseline_withContext(@NativeType(value="BaselineWithContextFn") long value) {
            YGNode.nbaseline_withContext(this.address(), value);
            return this;
        }

        public Buffer print_noContext(@Nullable @NativeType(value="YGPrintFunc") YGPrintFuncI value) {
            YGNode.nprint_noContext(this.address(), value);
            return this;
        }

        public Buffer print_withContext(@NativeType(value="PrintWithContextFn") long value) {
            YGNode.nprint_withContext(this.address(), value);
            return this;
        }

        public Buffer dirtied(@Nullable @NativeType(value="YGDirtiedFunc") YGDirtiedFuncI value) {
            YGNode.ndirtied(this.address(), value);
            return this;
        }

        public Buffer style(YGStyle value) {
            YGNode.nstyle(this.address(), value);
            return this;
        }

        public Buffer layout(YGLayout value) {
            YGNode.nlayout(this.address(), value);
            return this;
        }

        public Buffer lineIndex(@NativeType(value="uint32_t") int value) {
            YGNode.nlineIndex(this.address(), value);
            return this;
        }

        public Buffer owner(@NativeType(value="YGNodeRef") long value) {
            YGNode.nowner(this.address(), value);
            return this;
        }

        public Buffer config(@NativeType(value="YGConfigRef") long value) {
            YGNode.nconfig(this.address(), value);
            return this;
        }

        public Buffer resolvedDimensions(@NativeType(value="YGValue[2]") YGValue.Buffer value) {
            YGNode.nresolvedDimensions(this.address(), value);
            return this;
        }

        public Buffer resolvedDimensions(int index, YGValue value) {
            YGNode.nresolvedDimensions(this.address(), index, value);
            return this;
        }

        public Buffer resolvedDimensions(Consumer<YGValue.Buffer> consumer) {
            consumer.accept(this.resolvedDimensions());
            return this;
        }

        public Buffer resolvedDimensions(int index, Consumer<YGValue> consumer) {
            consumer.accept(this.resolvedDimensions(index));
            return this;
        }
    }
}

