/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGNodeFlags
extends Struct<YGNodeFlags>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;

    protected YGNodeFlags(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected YGNodeFlags create(long address, @Nullable ByteBuffer container) {
        return new YGNodeFlags(address, container);
    }

    public YGNodeFlags(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGNodeFlags.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bool")
    public boolean hasNewLayout() {
        return YGNodeFlags.nhasNewLayout(this.address());
    }

    @NativeType(value="bool")
    public boolean isReferenceBaseline() {
        return YGNodeFlags.nisReferenceBaseline(this.address());
    }

    @NativeType(value="bool")
    public boolean isDirty() {
        return YGNodeFlags.nisDirty(this.address());
    }

    @NativeType(value="YGNodeType")
    public int nodeType() {
        return YGNodeFlags.nnodeType(this.address());
    }

    @NativeType(value="bool")
    public boolean measureUsesContext() {
        return YGNodeFlags.nmeasureUsesContext(this.address());
    }

    @NativeType(value="bool")
    public boolean baselineUsesContext() {
        return YGNodeFlags.nbaselineUsesContext(this.address());
    }

    @NativeType(value="bool")
    public boolean printUsesContext() {
        return YGNodeFlags.nprintUsesContext(this.address());
    }

    public YGNodeFlags hasNewLayout(@NativeType(value="bool") boolean value) {
        YGNodeFlags.nhasNewLayout(this.address(), value);
        return this;
    }

    public YGNodeFlags isReferenceBaseline(@NativeType(value="bool") boolean value) {
        YGNodeFlags.nisReferenceBaseline(this.address(), value);
        return this;
    }

    public YGNodeFlags isDirty(@NativeType(value="bool") boolean value) {
        YGNodeFlags.nisDirty(this.address(), value);
        return this;
    }

    public YGNodeFlags nodeType(@NativeType(value="YGNodeType") int value) {
        YGNodeFlags.nnodeType(this.address(), value);
        return this;
    }

    public YGNodeFlags measureUsesContext(@NativeType(value="bool") boolean value) {
        YGNodeFlags.nmeasureUsesContext(this.address(), value);
        return this;
    }

    public YGNodeFlags baselineUsesContext(@NativeType(value="bool") boolean value) {
        YGNodeFlags.nbaselineUsesContext(this.address(), value);
        return this;
    }

    public YGNodeFlags printUsesContext(@NativeType(value="bool") boolean value) {
        YGNodeFlags.nprintUsesContext(this.address(), value);
        return this;
    }

    public YGNodeFlags set(boolean hasNewLayout, boolean isReferenceBaseline, boolean isDirty, int nodeType, boolean measureUsesContext, boolean baselineUsesContext, boolean printUsesContext) {
        this.hasNewLayout(hasNewLayout);
        this.isReferenceBaseline(isReferenceBaseline);
        this.isDirty(isDirty);
        this.nodeType(nodeType);
        this.measureUsesContext(measureUsesContext);
        this.baselineUsesContext(baselineUsesContext);
        this.printUsesContext(printUsesContext);
        return this;
    }

    public YGNodeFlags set(YGNodeFlags src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGNodeFlags malloc() {
        return new YGNodeFlags(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static YGNodeFlags calloc() {
        return new YGNodeFlags(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static YGNodeFlags create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new YGNodeFlags(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static YGNodeFlags create(long address) {
        return new YGNodeFlags(address, null);
    }

    @Nullable
    public static YGNodeFlags createSafe(long address) {
        return address == 0L ? null : new YGNodeFlags(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)YGNodeFlags.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGNodeFlags.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static YGNodeFlags malloc(MemoryStack stack) {
        return new YGNodeFlags(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static YGNodeFlags calloc(MemoryStack stack) {
        return new YGNodeFlags(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nflags(long struct) {
        return UNSAFE.getByte(null, struct + (long)FLAGS);
    }

    public static boolean nhasNewLayout(long struct) {
        return (YGNodeFlags.nflags(struct) & 1) != 0;
    }

    public static boolean nisReferenceBaseline(long struct) {
        return (YGNodeFlags.nflags(struct) >>> 1 & 1) != 0;
    }

    public static boolean nisDirty(long struct) {
        return (YGNodeFlags.nflags(struct) >>> 2 & 1) != 0;
    }

    public static int nnodeType(long struct) {
        return YGNodeFlags.nflags(struct) >>> 3 & 1;
    }

    public static boolean nmeasureUsesContext(long struct) {
        return (YGNodeFlags.nflags(struct) >>> 4 & 1) != 0;
    }

    public static boolean nbaselineUsesContext(long struct) {
        return (YGNodeFlags.nflags(struct) >>> 5 & 1) != 0;
    }

    public static boolean nprintUsesContext(long struct) {
        return (YGNodeFlags.nflags(struct) >>> 6 & 1) != 0;
    }

    public static void nflags(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)FLAGS, value);
    }

    public static native void nhasNewLayout(long var0, boolean var2);

    public static native void nisReferenceBaseline(long var0, boolean var2);

    public static native void nisDirty(long var0, boolean var2);

    public static native void nnodeType(long var0, int var2);

    public static native void nmeasureUsesContext(long var0, boolean var2);

    public static native void nbaselineUsesContext(long var0, boolean var2);

    public static native void nprintUsesContext(long var0, boolean var2);

    static {
        Struct.Layout layout = YGNodeFlags.__struct((Struct.Member[])new Struct.Member[]{YGNodeFlags.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<YGNodeFlags, Buffer>
    implements NativeResource {
        private static final YGNodeFlags ELEMENT_FACTORY = YGNodeFlags.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected YGNodeFlags getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="bool")
        public boolean hasNewLayout() {
            return YGNodeFlags.nhasNewLayout(this.address());
        }

        @NativeType(value="bool")
        public boolean isReferenceBaseline() {
            return YGNodeFlags.nisReferenceBaseline(this.address());
        }

        @NativeType(value="bool")
        public boolean isDirty() {
            return YGNodeFlags.nisDirty(this.address());
        }

        @NativeType(value="YGNodeType")
        public int nodeType() {
            return YGNodeFlags.nnodeType(this.address());
        }

        @NativeType(value="bool")
        public boolean measureUsesContext() {
            return YGNodeFlags.nmeasureUsesContext(this.address());
        }

        @NativeType(value="bool")
        public boolean baselineUsesContext() {
            return YGNodeFlags.nbaselineUsesContext(this.address());
        }

        @NativeType(value="bool")
        public boolean printUsesContext() {
            return YGNodeFlags.nprintUsesContext(this.address());
        }

        public Buffer hasNewLayout(@NativeType(value="bool") boolean value) {
            YGNodeFlags.nhasNewLayout(this.address(), value);
            return this;
        }

        public Buffer isReferenceBaseline(@NativeType(value="bool") boolean value) {
            YGNodeFlags.nisReferenceBaseline(this.address(), value);
            return this;
        }

        public Buffer isDirty(@NativeType(value="bool") boolean value) {
            YGNodeFlags.nisDirty(this.address(), value);
            return this;
        }

        public Buffer nodeType(@NativeType(value="YGNodeType") int value) {
            YGNodeFlags.nnodeType(this.address(), value);
            return this;
        }

        public Buffer measureUsesContext(@NativeType(value="bool") boolean value) {
            YGNodeFlags.nmeasureUsesContext(this.address(), value);
            return this;
        }

        public Buffer baselineUsesContext(@NativeType(value="bool") boolean value) {
            YGNodeFlags.nbaselineUsesContext(this.address(), value);
            return this;
        }

        public Buffer printUsesContext(@NativeType(value="bool") boolean value) {
            YGNodeFlags.nprintUsesContext(this.address(), value);
            return this;
        }
    }
}

