/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.yoga;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class YGValue
extends Struct<YGValue>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VALUE;
    public static final int UNIT;

    protected YGValue(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected YGValue create(long address, @Nullable ByteBuffer container) {
        return new YGValue(address, container);
    }

    public YGValue(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), YGValue.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float value() {
        return YGValue.nvalue(this.address());
    }

    @NativeType(value="YGUnit")
    public int unit() {
        return YGValue.nunit(this.address());
    }

    public YGValue value(float value) {
        YGValue.nvalue(this.address(), value);
        return this;
    }

    public YGValue unit(@NativeType(value="YGUnit") int value) {
        YGValue.nunit(this.address(), value);
        return this;
    }

    public YGValue set(float value, int unit) {
        this.value(value);
        this.unit(unit);
        return this;
    }

    public YGValue set(YGValue src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static YGValue malloc() {
        return new YGValue(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static YGValue calloc() {
        return new YGValue(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static YGValue create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new YGValue(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static YGValue create(long address) {
        return new YGValue(address, null);
    }

    public static @Nullable YGValue createSafe(long address) {
        return address == 0L ? null : new YGValue(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)YGValue.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = YGValue.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static YGValue mallocStack() {
        return YGValue.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGValue callocStack() {
        return YGValue.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static YGValue mallocStack(MemoryStack stack) {
        return YGValue.malloc(stack);
    }

    @Deprecated
    public static YGValue callocStack(MemoryStack stack) {
        return YGValue.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return YGValue.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return YGValue.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return YGValue.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return YGValue.calloc(capacity, stack);
    }

    public static YGValue malloc(MemoryStack stack) {
        return new YGValue(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static YGValue calloc(MemoryStack stack) {
        return new YGValue(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nvalue(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)VALUE));
    }

    public static int nunit(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UNIT));
    }

    public static void nvalue(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)VALUE), (float)value);
    }

    public static void nunit(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)UNIT), (int)value);
    }

    static {
        Struct.Layout layout = YGValue.__struct((Struct.Member[])new Struct.Member[]{YGValue.__member((int)4), YGValue.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VALUE = layout.offsetof(0);
        UNIT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<YGValue, Buffer>
    implements NativeResource {
        private static final YGValue ELEMENT_FACTORY = YGValue.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected YGValue getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float value() {
            return YGValue.nvalue(this.address());
        }

        @NativeType(value="YGUnit")
        public int unit() {
            return YGValue.nunit(this.address());
        }

        public Buffer value(float value) {
            YGValue.nvalue(this.address(), value);
            return this;
        }

        public Buffer unit(@NativeType(value="YGUnit") int value) {
            YGValue.nunit(this.address(), value);
            return this;
        }
    }
}

