/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.zstd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ZSTD_bounds")
public class ZSTDBounds
extends Struct<ZSTDBounds>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ERROR;
    public static final int LOWERBOUND;
    public static final int UPPERBOUND;

    protected ZSTDBounds(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ZSTDBounds create(long address, @Nullable ByteBuffer container) {
        return new ZSTDBounds(address, container);
    }

    public ZSTDBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ZSTDBounds.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long error() {
        return ZSTDBounds.nerror(this.address());
    }

    public int lowerBound() {
        return ZSTDBounds.nlowerBound(this.address());
    }

    public int upperBound() {
        return ZSTDBounds.nupperBound(this.address());
    }

    public static ZSTDBounds malloc() {
        return new ZSTDBounds(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ZSTDBounds calloc() {
        return new ZSTDBounds(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ZSTDBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ZSTDBounds(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ZSTDBounds create(long address) {
        return new ZSTDBounds(address, null);
    }

    @Nullable
    public static ZSTDBounds createSafe(long address) {
        return address == 0L ? null : new ZSTDBounds(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ZSTDBounds.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ZSTDBounds.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static ZSTDBounds mallocStack() {
        return ZSTDBounds.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDBounds callocStack() {
        return ZSTDBounds.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static ZSTDBounds mallocStack(MemoryStack stack) {
        return ZSTDBounds.malloc(stack);
    }

    @Deprecated
    public static ZSTDBounds callocStack(MemoryStack stack) {
        return ZSTDBounds.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return ZSTDBounds.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return ZSTDBounds.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return ZSTDBounds.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return ZSTDBounds.calloc(capacity, stack);
    }

    public static ZSTDBounds malloc(MemoryStack stack) {
        return new ZSTDBounds(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ZSTDBounds calloc(MemoryStack stack) {
        return new ZSTDBounds(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nerror(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ERROR));
    }

    public static int nlowerBound(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOWERBOUND);
    }

    public static int nupperBound(long struct) {
        return UNSAFE.getInt(null, struct + (long)UPPERBOUND);
    }

    static {
        Struct.Layout layout = ZSTDBounds.__struct((Struct.Member[])new Struct.Member[]{ZSTDBounds.__member((int)POINTER_SIZE), ZSTDBounds.__member((int)4), ZSTDBounds.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ERROR = layout.offsetof(0);
        LOWERBOUND = layout.offsetof(1);
        UPPERBOUND = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<ZSTDBounds, Buffer>
    implements NativeResource {
        private static final ZSTDBounds ELEMENT_FACTORY = ZSTDBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected ZSTDBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long error() {
            return ZSTDBounds.nerror(this.address());
        }

        public int lowerBound() {
            return ZSTDBounds.nlowerBound(this.address());
        }

        public int upperBound() {
            return ZSTDBounds.nupperBound(this.address());
        }
    }
}

