/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl.swt;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.lwjgl.opengl.swt.GLData;
import org.lwjgl.opengl.swt.PlatformGLCanvas;
import org.lwjgl.system.Platform;

public class GLCanvas
extends Canvas {
    GLData effective;
    long context;
    long xWindow;
    long glWindow;
    private static PlatformGLCanvas platformCanvas;

    public GLCanvas(Composite parent, int style, GLData data) {
        super(parent, platformCanvas.checkStyle(parent, style));
        if (Platform.get() == Platform.WINDOWS) {
            platformCanvas.resetStyle(parent);
        }
        if (data == null) {
            SWT.error((int)4);
        }
        this.effective = new GLData();
        this.context = platformCanvas.create(this, data, this.effective);
    }

    public GLData getGLData() {
        this.checkWidget();
        return this.effective;
    }

    public boolean isCurrent() {
        this.checkWidget();
        return platformCanvas.isCurrent(this.context);
    }

    public void setCurrent() {
        this.checkWidget();
        if (platformCanvas.isCurrent(this.context)) {
            return;
        }
        platformCanvas.makeCurrent(this, this.context);
    }

    public void swapBuffers() {
        this.checkWidget();
        platformCanvas.swapBuffers(this);
    }

    public boolean delayBeforeSwapNV(float seconds) {
        this.checkWidget();
        return platformCanvas.delayBeforeSwapNV(this, seconds);
    }

    static {
        String platformClassName;
        switch (Platform.get()) {
            case WINDOWS: {
                platformClassName = "org.lwjgl.opengl.swt.PlatformWin32GLCanvas";
                break;
            }
            case LINUX: {
                platformClassName = "org.lwjgl.opengl.swt.PlatformLinuxGLCanvas";
                break;
            }
            case MACOSX: {
                platformClassName = "org.lwjgl.opengl.swt.PlatformMacOSXGLCanvas";
                break;
            }
            default: {
                throw new AssertionError((Object)"NYI");
            }
        }
        try {
            Class<?> clazz = GLCanvas.class.getClassLoader().loadClass(platformClassName);
            platformCanvas = (PlatformGLCanvas)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)("Platform-specific GLCanvas class not found: " + platformClassName));
        }
        catch (InstantiationException e) {
            throw new AssertionError((Object)("Could not instantiate platform-specific GLCanvas class: " + platformClassName));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)("Could not instantiate platform-specific GLCanvas class: " + platformClassName));
        }
    }
}

