/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.widget.Toast;
import com.lynx.basedevtool.logbox.LogBoxDialogBase;
import com.lynx.basedevtool.logbox.LogBoxEnv;
import com.lynx.basedevtool.logbox.LogBoxLogLevel;
import com.lynx.basedevtool.logbox.LogBoxManager;
import com.lynx.basedevtool.utils.DevToolFileLoadCallback;
import com.lynx.basedevtool.utils.DownloadCallback;
import com.lynx.basedevtool.utils.UIThreadUtils;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class LogBoxDialog
extends LogBoxDialogBase {
    private static final String TAG = "LogBoxDialog";
    private static final String KEY_CALLBACK_ID = "callbackId";
    private static final String KEY_LOG = "log";
    private static final String KEY_NAMESPACE = "namespace";
    private static final String KEY_DATA = "data";
    private static final String KEY_VIEW_NUMBER = "viewNumber";
    private static final String KEY_EVENT = "event";
    private static final String KEY_CURRENT_VIEW = "currentView";
    private static final String KEY_VIEWS_COUNT = "viewsCount";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_TEMPLATE_URL = "templateUrl";
    private static final String EVENT_NEW_LOG = "receiveNewLog";
    private static final String EVENT_VIEW_INFO = "receiveViewInfo";
    private static final String EVENT_RESET = "reset";
    private LogBoxLogLevel mLevel;
    private WeakReference<LogBoxManager> mManager;
    private Runnable mLoadingFinishCallback;
    public Boolean isLoadingFinished = false;

    protected LogBoxDialog(Context context, LogBoxManager manager, Runnable loadingFinishCallback) {
        super(context);
        this.mManager = new WeakReference<LogBoxManager>(manager);
        this.mLoadingFinishCallback = loadingFinishCallback;
        this.initWebView(new WebviewCallback());
    }

    public void updateViewInfo(int currentIndex, int viewCount, LogBoxLogLevel level, String templateUrl) {
        JSONObject event = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            event.put(KEY_EVENT, (Object)EVENT_VIEW_INFO);
            data.put(KEY_CURRENT_VIEW, currentIndex);
            data.put(KEY_VIEWS_COUNT, viewCount);
            data.put(KEY_LEVEL, (Object)level.value);
            data.put(KEY_TEMPLATE_URL, (Object)templateUrl);
            event.put(KEY_DATA, (Object)data);
            this.sendEvent(event);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    protected void showLogMessages(String namespace, List<String> logs) {
        if (logs == null) {
            return;
        }
        for (String log : logs) {
            this.showLogMessage(namespace, log);
        }
    }

    protected void showLogMessage(String namespace, String log) {
        JSONObject event = new JSONObject();
        JSONObject data = new JSONObject();
        try {
            data.put(KEY_LOG, (Object)log);
            data.put(KEY_NAMESPACE, (Object)namespace);
            event.put(KEY_EVENT, (Object)EVENT_NEW_LOG);
            event.put(KEY_DATA, (Object)data);
            this.sendEvent(event);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public LogBoxLogLevel getLevel() {
        return this.mLevel;
    }

    public void showWithLevel(LogBoxLogLevel level) {
        this.mLevel = level;
        this.show();
    }

    public void onLoadingFinished() {
        this.isLoadingFinished = true;
    }

    @Override
    public boolean isLoadingFinished() {
        return this.isLoadingFinished;
    }

    public boolean isShowing() {
        return this.isLoadingFinished != false && super.isShowing();
    }

    @Override
    public void reset() {
        LogBoxManager manager = (LogBoxManager)this.mManager.get();
        if (manager != null) {
            manager.onLogBoxDismiss();
        }
        this.sendEvent(EVENT_RESET);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyWebView();
    }

    private class WebviewCallback
    extends LogBoxDialogBase.Callback {
        private static final String BRIDGE_NAME = "bridgeName";
        private static final String CASE_GET_EXCEPTION_STACK = "getExceptionStack";
        private static final String CASE_DISMISS = "dismiss";
        private static final String CASE_REMOVE_CURRENT_LOGS = "deleteLynxview";
        private static final String CASE_SWITCH_LOGS = "changeView";
        private static final String CASE_TOAST = "toast";
        private static final String CASE_QUERY_RESOURCE = "queryResource";
        private static final String CASE_LOAD_ERROR_PARSER = "loadErrorParser";

        private WebviewCallback() {
            super(LogBoxDialog.this);
        }

        @JavascriptInterface
        public void postMessage(String strParams) {
            try {
                JSONObject params = new JSONObject(strParams);
                JSONObject data = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                switch (params.getString(BRIDGE_NAME)) {
                    case "getExceptionStack": {
                        this.loadMappingsWasm();
                        UIThreadUtils.runOnUiThread(LogBoxDialog.this.mLoadingFinishCallback);
                        break;
                    }
                    case "dismiss": {
                        this.dismiss();
                        break;
                    }
                    case "deleteLynxview": {
                        this.removeLogsOfCurrentView();
                        this.requestLogsOfCurrentView();
                        break;
                    }
                    case "changeView": {
                        int nextViewIndex = data.getInt(LogBoxDialog.KEY_VIEW_NUMBER);
                        this.requestLogsOfViewIndex(nextViewIndex);
                        break;
                    }
                    case "toast": {
                        final String toastMsg = data.getString("message");
                        if (TextUtils.isEmpty((CharSequence)toastMsg)) break;
                        UIThreadUtils.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                Toast.makeText((Context)LogBoxDialog.this.getContext(), (CharSequence)toastMsg, (int)0).show();
                            }
                        });
                        break;
                    }
                    case "queryResource": {
                        String name = data.getString("name");
                        this.getResource(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), name);
                        break;
                    }
                    case "loadErrorParser": {
                        String namespace = data.getString(LogBoxDialog.KEY_NAMESPACE);
                        this.loadErrorParser(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), namespace);
                        break;
                    }
                }
            }
            catch (Exception e) {
                Log.e((String)LogBoxDialog.TAG, (String)e.getMessage());
            }
        }

        private void loadErrorParser(final int callbackId, String namespace) {
            LogBoxEnv.inst().loadErrorParser(LogBoxDialog.this.getContext(), namespace, new DevToolFileLoadCallback(){

                @Override
                public void onSuccess(String data) {
                    LogBoxDialog.this.evaluateJs(data);
                    WebviewCallback.this.sendResult(callbackId, true);
                }

                @Override
                public void onFailure(String reason) {
                    WebviewCallback.this.sendResult(callbackId, false);
                }
            });
        }

        private void dismiss() {
            UIThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LogBoxManager manager = (LogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.dismissDialog();
                }
            });
        }

        private void removeLogsOfCurrentView() {
            UIThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LogBoxManager manager = (LogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.removeLogsOfCurrentView(LogBoxDialog.this.mLevel);
                }
            });
        }

        private void requestLogsOfCurrentView() {
            UIThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LogBoxManager manager = (LogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.requestLogsOfCurrentView(LogBoxDialog.this.mLevel);
                }
            });
        }

        private void requestLogsOfViewIndex(final int viewIndex) {
            UIThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LogBoxManager manager = (LogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.requestLogsOfViewIndex(viewIndex, LogBoxDialog.this.mLevel);
                }
            });
        }

        public void getResource(final int callbackId, final String name) {
            String value;
            if (TextUtils.isEmpty((CharSequence)name)) {
                this.sendResult(callbackId, "");
                return;
            }
            DownloadCallback downloadCallback = new DownloadCallback(){

                @Override
                public void onData(byte[] bytes, int length) {
                    String content = new String(bytes, Charset.defaultCharset());
                    WebviewCallback.this.sendResult(callbackId, content);
                }

                @Override
                public void onFailure(String reason) {
                    WebviewCallback.this.sendResult(callbackId, "");
                    Log.w((String)LogBoxDialog.TAG, (String)("Download failed: " + reason + ", and the url is " + name));
                }
            };
            if (name.startsWith("http")) {
                this.download(name, downloadCallback);
                return;
            }
            LogBoxManager manager = (LogBoxManager)LogBoxDialog.this.mManager.get();
            if (manager != null && !TextUtils.isEmpty((CharSequence)(value = manager.getLogSourceWithFileName(name, LogBoxDialog.this.mLevel)))) {
                if (value.startsWith("http")) {
                    this.download(value, downloadCallback);
                } else {
                    this.sendResult(callbackId, value);
                }
                return;
            }
            if (LogBoxDialog.this.mJsSource == null) {
                this.sendResult(callbackId, "");
                Log.w((String)LogBoxDialog.TAG, (String)"the js source cache is null");
                return;
            }
            String src = "";
            for (Map.Entry entry : LogBoxDialog.this.mJsSource.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.contains(name)) continue;
                src = entry.getValue();
                break;
            }
            String res = src instanceof String ? src : "";
            this.sendResult(callbackId, res);
        }
    }
}

