/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.lynx.basedevtool.logbox.LogBoxDialog;
import com.lynx.basedevtool.logbox.LogBoxLifeCycleListenerFragment;
import com.lynx.basedevtool.logbox.LogBoxLogLevel;
import com.lynx.basedevtool.logbox.LogBoxNotification;
import com.lynx.basedevtool.logbox.LogBoxProxy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LogBoxManager {
    private static final String TAG = "LogBoxManager";
    private static final String LIFE_CYCLE_LISTENER_FRAGMENT_TAG = "BaseDevToolLogBoxLifeCycleListener";
    private static final int MAX_BRIEF_MSG_SIZE = 50;
    private final WeakReference<Context> mContext;
    private Map<LogBoxLogLevel, LogProxyList> mLogProxyListMap;
    private LogBoxNotification mNotification;
    private LogBoxDialog mLogBox;

    public LogBoxManager(Context context) {
        this.mContext = new WeakReference<Context>(context);
        this.mLogProxyListMap = new HashMap<LogBoxLogLevel, LogProxyList>();
        this.mLogProxyListMap.put(LogBoxLogLevel.Error, new LogProxyList(LogBoxLogLevel.Error));
        this.mLogProxyListMap.put(LogBoxLogLevel.Warn, new LogProxyList(LogBoxLogLevel.Warn));
        this.mNotification = new LogBoxNotification(context, this);
        this.registerLifeCycleListenerIfNeed(context);
    }

    private boolean registerLifeCycleListenerIfNeed(Context context) {
        if (!(context instanceof Activity) || ((Activity)context).isFinishing()) {
            return false;
        }
        Activity activity = (Activity)context;
        if (activity.getFragmentManager().findFragmentByTag(LIFE_CYCLE_LISTENER_FRAGMENT_TAG) != null) {
            return true;
        }
        try {
            activity.getFragmentManager().beginTransaction().add((Fragment)new LogBoxLifeCycleListenerFragment(), LIFE_CYCLE_LISTENER_FRAGMENT_TAG).commit();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)("Failed to register Activity life cycle listener: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public void onNewLog(String msg, LogBoxLogLevel level, LogBoxProxy logBoxProxy) {
        if (logBoxProxy == null) {
            return;
        }
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList == null) {
            return;
        }
        boolean isNewPoxy = false;
        proxyList.increaseLogCount();
        if (!proxyList.contains(logBoxProxy)) {
            proxyList.add(logBoxProxy);
            isNewPoxy = true;
        }
        if (this.mLogBox != null && this.mLogBox.isShowing()) {
            if (this.mNotification != null) {
                this.mNotification.invalidate(level);
            }
            if (this.mLogBox.getLevel() != level) {
                return;
            }
            if (proxyList.isCurrentProxy(logBoxProxy)) {
                this.mLogBox.showLogMessage(logBoxProxy.getErrorNamespace(), msg);
            } else if (isNewPoxy) {
                this.mLogBox.updateViewInfo(proxyList.currentProxyIndex() + 1, proxyList.getProxiesCount(), level, this.getCurrentTemplateUrl(level));
            }
        } else if (this.mNotification != null && this.registerLifeCycleListenerIfNeed((Context)this.mContext.get())) {
            String briefMessage = LogBoxManager.extractBriefMessage(msg);
            this.mNotification.updateInfo(level, briefMessage, proxyList.getLogCount());
        }
    }

    public void onNotificationClick(final LogBoxLogLevel level) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        if (this.mLogBox == null) {
            this.mLogBox = new LogBoxDialog(context, this, new Runnable(){

                @Override
                public void run() {
                    LogBoxManager.this.requestLogsOfCurrentView(level);
                    if (LogBoxManager.this.mLogBox != null) {
                        LogBoxManager.this.mLogBox.onLoadingFinished();
                    }
                }
            });
        } else {
            this.requestLogsOfCurrentView(level);
        }
        if (context instanceof Activity && !((Activity)context).isFinishing()) {
            this.mLogBox.showWithLevel(level);
        }
    }

    public void onNotificationClose(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList != null) {
            proxyList.clearLogs(level);
        }
    }

    public void removeLogsOfCurrentView(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList == null) {
            return;
        }
        LogBoxProxy proxy = proxyList.currentProxy();
        if (proxy != null) {
            if (this.mNotification != null) {
                this.mNotification.invalidate(level);
            }
            proxyList.removeProxy(proxy);
            proxy.clearLogsWithLevel(level);
        }
    }

    public void requestLogsOfCurrentView(LogBoxLogLevel level) {
        this.requestLogsOfViewIndex(-1, level);
    }

    public void requestLogsOfViewIndex(int viewIndex, LogBoxLogLevel level) {
        Log.i((String)TAG, (String)("show logs of view index " + viewIndex + " with level " + (Object)((Object)level)));
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList == null) {
            return;
        }
        if (viewIndex != -1) {
            proxyList.setCurrentProxyIndex(viewIndex - 1);
        }
        if (this.mLogBox != null) {
            this.mLogBox.updateViewInfo(proxyList.currentProxyIndex() + 1, proxyList.getProxiesCount(), level, this.getCurrentTemplateUrl(level));
            this.mLogBox.setJSSource(this.getAllJsSourceOfCurrentView(level));
            LogBoxProxy proxy = proxyList.currentProxy();
            if (proxy != null) {
                this.mLogBox.showLogMessages(proxy.getErrorNamespace(), proxy.getLogMessages(level));
            }
        }
    }

    protected static String extractBriefMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        String logStr = null;
        JSONObject rawLog = null;
        try {
            JSONObject logJson = new JSONObject(message);
            Object errorMessage = logJson.opt("error");
            if (errorMessage instanceof String) {
                logStr = (String)errorMessage;
                JSONObject errorJson = new JSONObject((String)errorMessage);
                rawLog = errorJson.optJSONObject("rawError");
            } else if (errorMessage instanceof JSONObject) {
                rawLog = ((JSONObject)errorMessage).optJSONObject("rawError");
            }
        }
        catch (JSONException e) {
            Log.i((String)TAG, (String)("JSONException occurred when extract brief message of error: " + e.getMessage()));
        }
        if (rawLog != null) {
            logStr = rawLog.optString("message", null);
        }
        if (logStr == null) {
            logStr = message;
        }
        if (logStr.length() > 50) {
            logStr = logStr.substring(0, 50);
        }
        logStr = logStr.replace('\n', ' ');
        return logStr;
    }

    public String getCurrentTemplateUrl(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList == null) {
            return "";
        }
        LogBoxProxy proxy = proxyList.currentProxy();
        return proxy == null ? "" : proxy.getEntryUrlForLogSrc();
    }

    public Map<String, Object> getAllJsSourceOfCurrentView(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList == null) {
            return null;
        }
        LogBoxProxy proxy = proxyList.currentProxy();
        return proxy == null ? null : proxy.getLogSources();
    }

    public String getLogSourceWithFileName(String fileName, LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get((Object)level);
        if (proxyList == null) {
            return "";
        }
        LogBoxProxy proxy = proxyList.currentProxy();
        if (proxy == null) {
            return "";
        }
        return proxy.getLogSourceWithFileName(fileName);
    }

    public void onProxyReset(LogBoxProxy proxy) {
        if (proxy == null) {
            return;
        }
        for (Map.Entry<LogBoxLogLevel, LogProxyList> entry : this.mLogProxyListMap.entrySet()) {
            LogProxyList list = entry.getValue();
            if (!list.removeProxy(proxy) || this.mNotification == null) continue;
            this.mNotification.invalidate(entry.getKey());
        }
        if (this.mLogBox != null && this.mLogBox.isShowing()) {
            this.mLogBox.reset();
            this.mLogBox.dismiss();
        } else {
            this.updateNotificationIfNeed();
        }
        proxy.clearAllLogs();
    }

    public void onLogBoxDismiss() {
        this.updateNotificationIfNeed();
    }

    public void dismissDialog() {
        if (this.mLogBox != null) {
            this.mLogBox.reset();
            this.mLogBox.dismiss();
        }
    }

    private void updateNotificationIfNeed() {
        for (Map.Entry<LogBoxLogLevel, LogProxyList> entry : this.mLogProxyListMap.entrySet()) {
            LogProxyList proxyList = entry.getValue();
            if (this.mNotification == null || !this.mNotification.isDirty(entry.getKey()) || !this.registerLifeCycleListenerIfNeed((Context)this.mContext.get())) continue;
            String briefMsg = LogBoxManager.extractBriefMessage(proxyList.getLastLog());
            this.mNotification.updateInfo(entry.getKey(), briefMsg, proxyList.getLogCount());
        }
    }

    public void destroy() {
        if (this.mLogBox != null) {
            this.mLogBox.dismiss();
            this.mLogBox = null;
        }
        if (this.mNotification != null) {
            this.mNotification.destroy();
            this.mNotification = null;
        }
    }

    private class LogProxyList {
        public static final int CURRENT_VIEW = -1;
        private final LogBoxLogLevel mLevel;
        private final List<LogBoxProxy> mProxyList;
        private int mCurrentProxyIndex;
        private int mLogCount;

        public LogProxyList(LogBoxLogLevel level) {
            this.mLevel = level;
            this.mProxyList = new ArrayList<LogBoxProxy>();
            this.mCurrentProxyIndex = 0;
            this.mLogCount = 0;
        }

        public LogBoxLogLevel getLevel() {
            return this.mLevel;
        }

        public boolean isCurrentProxy(LogBoxProxy proxy) {
            int index;
            return proxy != null && (index = this.mProxyList.indexOf(proxy)) != -1 && index == this.mCurrentProxyIndex;
        }

        public void increaseLogCount() {
            ++this.mLogCount;
        }

        public boolean contains(LogBoxProxy proxy) {
            return this.mProxyList.contains(proxy);
        }

        public boolean add(LogBoxProxy proxy) {
            return this.mProxyList.add(proxy);
        }

        public int getLogCount() {
            return this.mLogCount;
        }

        public int getProxiesCount() {
            return this.mProxyList.size();
        }

        public int currentProxyIndex() {
            Log.i((String)LogBoxManager.TAG, (String)("current proxy index is " + this.mCurrentProxyIndex));
            return this.mCurrentProxyIndex;
        }

        public boolean setCurrentProxyIndex(int index) {
            if (index >= 0 && index < this.mProxyList.size()) {
                Log.i((String)LogBoxManager.TAG, (String)("set current proxy index " + index));
                this.mCurrentProxyIndex = index;
                return true;
            }
            return false;
        }

        public LogBoxProxy currentProxy() {
            if (this.mCurrentProxyIndex >= this.mProxyList.size() || this.mCurrentProxyIndex < 0) {
                Log.e((String)LogBoxManager.TAG, (String)"current proxy index out of bounds");
                return null;
            }
            return this.mProxyList.get(this.mCurrentProxyIndex);
        }

        public boolean removeProxy(LogBoxProxy proxy) {
            if (proxy == null || !this.mProxyList.contains(proxy)) {
                return false;
            }
            int logCount = proxy.getLogCount(this.mLevel);
            this.mLogCount -= logCount;
            this.mProxyList.remove(proxy);
            this.mCurrentProxyIndex = this.mProxyList.isEmpty() ? 0 : this.mCurrentProxyIndex % this.mProxyList.size();
            return true;
        }

        public void clearLogs(LogBoxLogLevel level) {
            for (LogBoxProxy proxy : this.mProxyList) {
                proxy.clearLogsWithLevel(level);
            }
            this.mProxyList.clear();
            this.mLogCount = 0;
            this.mCurrentProxyIndex = 0;
        }

        public String getLastLog() {
            if (this.mProxyList.isEmpty()) {
                return "";
            }
            LogBoxProxy proxy = this.mProxyList.get(this.mProxyList.size() - 1);
            return proxy.getLastLog(this.mLevel);
        }
    }
}

