/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.lynx.basedevtool.R;
import com.lynx.basedevtool.logbox.LogBoxLogLevel;
import com.lynx.basedevtool.logbox.LogBoxManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

class LogBoxNotification {
    private static final String TAG = "LogBoxNotification";
    private static final int MAX_COUNT_NUMBER_LENGTH = 2;
    private final WeakReference<Context> mContext;
    private final WeakReference<LogBoxManager> mManager;
    private final Map<LogBoxLogLevel, NotificationViewHolder> mNotificationMap;
    private final Map<LogBoxLogLevel, Boolean> mIsLevelDirty;
    private Dialog mDialog = null;
    private LinearLayout mDialogContentView = null;

    protected LogBoxNotification(Context context, LogBoxManager manager) {
        this.mContext = new WeakReference<Context>(context);
        this.mManager = new WeakReference<LogBoxManager>(manager);
        this.mNotificationMap = new HashMap<LogBoxLogLevel, NotificationViewHolder>();
        this.mIsLevelDirty = new HashMap<LogBoxLogLevel, Boolean>();
    }

    private void initDialog(Context context) {
        this.mDialog = new Dialog(context);
        this.mDialog.requestWindowFeature(1);
        this.mDialogContentView = new LinearLayout(context);
        this.mDialogContentView.setOrientation(1);
        this.mDialog.setContentView((View)this.mDialogContentView);
        this.mDialog.setCancelable(false);
        if (this.mDialog.getWindow() != null) {
            this.mDialog.getWindow().setBackgroundDrawableResource(17170445);
            this.mDialog.getWindow().setDimAmount(0.0f);
            this.mDialog.getWindow().setLayout(-1, -2);
            this.mDialog.getWindow().setGravity(80);
            this.mDialog.getWindow().addFlags(32);
            this.mDialog.getWindow().addFlags(8);
            this.mDialog.getWindow().addFlags(131072);
            this.mDialog.getWindow().addFlags(256);
        }
    }

    public void updateInfo(LogBoxLogLevel level, String msg, int logCount) {
        NotificationViewHolder viewHolder;
        this.mIsLevelDirty.put(level, false);
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        if (logCount <= 0) {
            this.hideNotification(level);
            return;
        }
        if (this.mDialog == null) {
            this.initDialog(context);
        }
        if ((viewHolder = this.mNotificationMap.get((Object)level)) == null) {
            viewHolder = new NotificationViewHolder(context, (ViewGroup)this.mDialogContentView, level);
            this.mNotificationMap.put(level, viewHolder);
        }
        viewHolder.setBriefInfo(msg);
        viewHolder.setLogCount(logCount);
        View notificationView = viewHolder.getView();
        if (this.mDialogContentView != notificationView.getParent()) {
            this.mDialogContentView.addView(notificationView);
            if (!this.mDialog.isShowing()) {
                this.mDialog.show();
            }
        }
    }

    private void handleClick(LogBoxLogLevel level) {
        LogBoxManager manager = (LogBoxManager)this.mManager.get();
        if (manager != null) {
            manager.onNotificationClick(level);
        }
    }

    private void handleClose(LogBoxLogLevel level) {
        LogBoxManager manager = (LogBoxManager)this.mManager.get();
        if (manager != null) {
            manager.onNotificationClose(level);
        }
        this.hideNotification(level);
    }

    private void hideNotification(LogBoxLogLevel level) {
        if (this.mDialog == null) {
            return;
        }
        NotificationViewHolder notification = this.mNotificationMap.get((Object)level);
        if (notification != null) {
            this.mDialogContentView.removeView(notification.getView());
        }
        if (this.mDialogContentView.getChildCount() == 0 && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public void invalidate(LogBoxLogLevel level) {
        this.mIsLevelDirty.put(level, true);
    }

    public boolean isDirty(LogBoxLogLevel level) {
        Boolean dirty = this.mIsLevelDirty.get((Object)level);
        return dirty == null ? true : dirty;
    }

    public void destroy() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
    }

    private class NotificationViewHolder {
        private TextView mBriefLogInfoView;
        private TextView mLogCountView;
        private View mNotificationView;
        private LogBoxLogLevel mLevel;

        public NotificationViewHolder(Context context, ViewGroup rootView, LogBoxLogLevel level) {
            this.mNotificationView = LayoutInflater.from((Context)context).inflate(R.layout.devtool_logbox_notification, rootView, false);
            this.mBriefLogInfoView = (TextView)this.mNotificationView.findViewById(R.id.notification_text_brief_log);
            this.mLogCountView = (TextView)this.mNotificationView.findViewById(R.id.notification_text_log_count);
            this.mLevel = level;
            View cancelButton = this.mNotificationView.findViewById(R.id.notification_button_cancel);
            cancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LogBoxNotification.this.handleClose(NotificationViewHolder.this.mLevel);
                }
            });
            this.mBriefLogInfoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LogBoxNotification.this.handleClick(NotificationViewHolder.this.mLevel);
                }
            });
            this.mBriefLogInfoView.setSingleLine();
            ImageView logCountCircle = (ImageView)this.mNotificationView.findViewById(R.id.notification_view_log_count_circle);
            GradientDrawable circle = (GradientDrawable)logCountCircle.getDrawable();
            if (this.mLevel == LogBoxLogLevel.Error) {
                circle.setColor(context.getResources().getColor(R.color.logbox_red));
            } else if (this.mLevel == LogBoxLogLevel.Warn) {
                circle.setColor(context.getResources().getColor(R.color.logbox_yellow));
            }
        }

        public void setBriefInfo(String msg) {
            this.mBriefLogInfoView.setText((CharSequence)msg);
        }

        public void setLogCount(int count) {
            String countStr = String.valueOf(count);
            if (countStr.length() > 2) {
                countStr = countStr.charAt(0) + "...";
            }
            this.mLogCountView.setText((CharSequence)countStr);
        }

        public View getView() {
            return this.mNotificationView;
        }
    }
}

