/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.Log;
import androidx.annotation.Keep;
import com.lynx.basedevtool.logbox.ILogBoxResourceProvider;
import com.lynx.basedevtool.logbox.LogBoxEnv;
import com.lynx.basedevtool.logbox.LogBoxLogLevel;
import com.lynx.basedevtool.logbox.LogBoxOwner;
import com.lynx.basedevtool.utils.DevToolFileLoadCallback;
import com.lynx.basedevtool.utils.DevToolFileLoadUtils;
import com.lynx.basedevtool.utils.UIThreadUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Keep
public class LogBoxProxy {
    private static final String TAG = "LogBoxProxy";
    private WeakReference<Context> mActivity;
    private Map<LogBoxLogLevel, List<String>> mLogs;
    private WeakReference<ILogBoxResourceProvider> mProvider;
    private String mErrNamespace;

    public LogBoxProxy(Context context, String errNamespace, ILogBoxResourceProvider provider) {
        this.mProvider = new WeakReference<ILogBoxResourceProvider>(provider);
        this.mActivity = new WeakReference<Object>(null);
        this.mLogs = new HashMap<LogBoxLogLevel, List<String>>();
        this.mLogs.put(LogBoxLogLevel.Error, new ArrayList());
        this.mLogs.put(LogBoxLogLevel.Warn, new ArrayList());
        this.mErrNamespace = errNamespace != null ? errNamespace : "__unknown__";
        this.attachContext(context);
    }

    public void registerErrorParser(final String path) {
        LogBoxEnv.inst().registerErrorParserLoader(this.mErrNamespace, new LogBoxEnv.ILogBoxErrorParserLoader(){

            @Override
            public void loadErrorParser(Context context, DevToolFileLoadCallback callback) {
                DevToolFileLoadUtils.loadFileFromLocal(context, path, callback);
            }
        });
    }

    public void attachContext(Context context) {
        if (this.mActivity == null || this.mActivity.get() == null) {
            Context activity = this.findActivityByContext(context);
            if (activity == null) {
                return;
            }
            this.mActivity = new WeakReference<Context>(activity);
            this.showCacheLogMessage();
        } else {
            Log.e((String)TAG, (String)"LogBoxProxy context has attached.");
        }
    }

    public void showLogMessage(final String message, final LogBoxLogLevel level) {
        if (UIThreadUtils.isOnUiThread()) {
            this.onNewLog(message, level);
        } else {
            UIThreadUtils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    LogBoxProxy.this.onNewLog(message, level);
                }
            });
        }
    }

    private void onNewLog(String message, LogBoxLogLevel level) {
        Log.i((String)TAG, (String)("onNewLog with level " + (Object)((Object)level)));
        List<String> logList = this.mLogs.get((Object)level);
        if (logList == null) {
            return;
        }
        logList.add(message);
        if (this.mActivity == null || this.mActivity.get() == null) {
            return;
        }
        LogBoxOwner.getInstance().dispatch(message, level, (Context)this.mActivity.get(), this);
    }

    private void showCacheLogMessage() {
        this.showCacheLogMessageByLogLevel(LogBoxLogLevel.Warn);
        this.showCacheLogMessageByLogLevel(LogBoxLogLevel.Error);
    }

    private void showCacheLogMessageByLogLevel(final LogBoxLogLevel level) {
        UIThreadUtils.runOnUiThreadImmediately(new Runnable(){

            @Override
            public void run() {
                List logList = (List)LogBoxProxy.this.mLogs.get((Object)level);
                if (logList == null || logList.isEmpty()) {
                    return;
                }
                for (String message : logList) {
                    LogBoxOwner.getInstance().dispatch(message, level, (Context)LogBoxProxy.this.mActivity.get(), LogBoxProxy.this);
                }
            }
        });
    }

    public List<String> getLogMessages(LogBoxLogLevel level) {
        ArrayList logs = this.mLogs.get((Object)level);
        return logs == null ? new ArrayList() : logs;
    }

    public String getLastLog(LogBoxLogLevel level) {
        List<String> logs = this.mLogs.get((Object)level);
        if (logs == null) {
            return "";
        }
        return logs.isEmpty() ? "" : logs.get(logs.size() - 1);
    }

    public void clearLogsWithLevel(LogBoxLogLevel level) {
        List<String> logs = this.mLogs.get((Object)level);
        if (logs != null) {
            logs.clear();
        }
    }

    public void clearAllLogs() {
        for (List<String> logs : this.mLogs.values()) {
            logs.clear();
        }
    }

    public String getEntryUrlForLogSrc() {
        ILogBoxResourceProvider provider = (ILogBoxResourceProvider)this.mProvider.get();
        return provider == null ? "" : provider.getEntryUrlForLogSrc();
    }

    public Map<String, Object> getLogSources() {
        ILogBoxResourceProvider provider = (ILogBoxResourceProvider)this.mProvider.get();
        return provider == null ? null : provider.getLogSources();
    }

    public String getLogSourceWithFileName(String fileName) {
        ILogBoxResourceProvider provider = (ILogBoxResourceProvider)this.mProvider.get();
        return provider == null ? "" : provider.getLogSourceWithFileName(fileName);
    }

    public int getLogCount(LogBoxLogLevel level) {
        List<String> logs = this.mLogs.get((Object)level);
        return logs == null ? 0 : logs.size();
    }

    public void reset() {
        UIThreadUtils.runOnUiThreadImmediately(new Runnable(){

            @Override
            public void run() {
                LogBoxOwner.getInstance().onProxyReset((Context)LogBoxProxy.this.mActivity.get(), LogBoxProxy.this);
            }
        });
    }

    public String getErrorNamespace() {
        return this.mErrNamespace;
    }

    private Context findActivityByContext(Context context) {
        if (context == null) {
            return null;
        }
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }
}

