/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.utils;

import com.lynx.basedevtool.utils.DownloadCallback;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DevToolDownloader
implements Runnable {
    private static final int CONNECTION_TIMEOUT = 1440;
    private static final int READ_TIMEOUT = 120000;
    private static final int NORMAL_RESPONSE_CODE = 299;
    private static final int BUFFER_SIZE = 8192;
    private static final ExecutorService sExecutorService = Executors.newCachedThreadPool();
    private final String mUrl;
    private final DownloadCallback mCallback;
    private final ByteArrayOutputStream mBuffer;

    public DevToolDownloader(String url, DownloadCallback callback) {
        this.mUrl = url;
        this.mCallback = callback;
        this.mBuffer = new ByteArrayOutputStream();
        sExecutorService.execute(this);
    }

    @Override
    public void run() {
        try {
            int readBytes;
            URL u = new URL(this.mUrl);
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setConnectTimeout(1440);
            conn.setReadTimeout(120000);
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.connect();
            conn.setInstanceFollowRedirects(true);
            int res = conn.getResponseCode();
            if (res > 299) {
                conn.disconnect();
                this.onFailure("Download connection failed and the response code is " + res);
                return;
            }
            int contentLength = conn.getContentLength();
            this.onResponse(res, contentLength);
            long maxDataSize = this.getSafeDataSize();
            if ((long)contentLength > maxDataSize) {
                conn.disconnect();
                this.onFailure("The size of the downloaded data has exceeded the maximum safe memory size, which may pose a risk of OOM. Currently, the content size is " + contentLength + " byte, and the safe memory available for use is " + maxDataSize);
                return;
            }
            InputStream in = conn.getInputStream();
            byte[] buf = new byte[8192];
            while ((readBytes = in.read(buf)) != -1) {
                this.mBuffer.write(buf, 0, readBytes);
            }
            this.onData(this.mBuffer.toByteArray(), this.mBuffer.size());
        }
        catch (Exception e) {
            this.onFailure("An exception occurred when download: " + e.getMessage());
        }
    }

    private void onFailure(String reason) {
        if (this.mCallback != null) {
            this.mCallback.onFailure(reason);
        }
    }

    private void onResponse(int status, int contentLength) {
        if (this.mCallback != null) {
            this.mCallback.onResponse(status, contentLength);
        }
    }

    private void onData(byte[] bytes, int length) {
        if (this.mCallback != null) {
            this.mCallback.onData(bytes, length);
        }
    }

    private long getSafeDataSize() {
        Runtime r = Runtime.getRuntime();
        return (r.maxMemory() - r.totalMemory() + r.freeMemory()) / 10L;
    }
}

