/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.logbox;

import android.content.Context;
import android.text.TextUtils;
import com.lynx.basedevtool.utils.DevToolFileLoadCallback;
import java.util.HashMap;
import java.util.Map;

class LogBoxEnv {
    private static final String TAG = "LogBoxEnv";
    private final Map<String, ILogBoxErrorParserLoader> mErrorParserLoaders = new HashMap<String, ILogBoxErrorParserLoader>();

    public static LogBoxEnv inst() {
        return SingletonHolder.INSTANCE;
    }

    private LogBoxEnv() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerErrorParserLoader(String namespace, ILogBoxErrorParserLoader loader) {
        if (TextUtils.isEmpty((CharSequence)namespace) || this.mErrorParserLoaders.get(namespace) != null || loader == null) {
            return;
        }
        Map<String, ILogBoxErrorParserLoader> map = this.mErrorParserLoaders;
        synchronized (map) {
            if (this.mErrorParserLoaders.get(namespace) == null) {
                this.mErrorParserLoaders.put(namespace, loader);
            }
        }
    }

    protected void loadErrorParser(Context context, String namespace, DevToolFileLoadCallback callback) {
        ILogBoxErrorParserLoader loader = this.mErrorParserLoaders.get(namespace);
        if (loader != null) {
            loader.loadErrorParser(context, callback);
        }
    }

    private static class SingletonHolder {
        private static final LogBoxEnv INSTANCE = new LogBoxEnv();

        private SingletonHolder() {
        }
    }

    public static interface ILogBoxErrorParserLoader {
        public void loadErrorParser(Context var1, DevToolFileLoadCallback var2);
    }
}

