/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.basedevtool.utils;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;

public class UIThreadUtils {
    @Nullable
    private static volatile Handler sMainHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler getUiThreadHandler() {
        if (sMainHandler != null) return sMainHandler;
        Class<UIThreadUtils> clazz = UIThreadUtils.class;
        synchronized (UIThreadUtils.class) {
            if (sMainHandler != null) return sMainHandler;
            sMainHandler = new Handler(Looper.getMainLooper());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainHandler;
        }
    }

    public static boolean isOnUiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static void runOnUiThread(Runnable runnable) {
        UIThreadUtils.getUiThreadHandler().post(runnable);
    }

    public static void runOnUiThreadImmediately(Runnable runnable) {
        if (UIThreadUtils.isOnUiThread()) {
            runnable.run();
        } else {
            UIThreadUtils.runOnUiThread(runnable);
        }
    }
}

