/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter.base;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;

public class UIThreadUtils {
    @Nullable
    private static Handler sMainHandler;

    public static boolean isOnUiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnUiThread(Runnable runnable) {
        Class<UIThreadUtils> clazz = UIThreadUtils.class;
        synchronized (UIThreadUtils.class) {
            if (sMainHandler == null) {
                sMainHandler = new Handler(Looper.getMainLooper());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            sMainHandler.post(runnable);
            return;
        }
    }

    public static void runOnUiThreadImmediately(Runnable runnable) {
        if (UIThreadUtils.isOnUiThread()) {
            runnable.run();
        } else {
            UIThreadUtils.runOnUiThread(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnUiThread(Runnable runnable, long delayMs) {
        Class<UIThreadUtils> clazz = UIThreadUtils.class;
        synchronized (UIThreadUtils.class) {
            if (sMainHandler == null) {
                sMainHandler = new Handler(Looper.getMainLooper());
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            sMainHandler.postDelayed(runnable, delayMs);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnUiThreadAtTime(Runnable runnable, Object token, long uptimeMillis) {
        Class<UIThreadUtils> clazz = UIThreadUtils.class;
        synchronized (UIThreadUtils.class) {
            if (sMainHandler == null) {
                sMainHandler = new Handler(Looper.getMainLooper());
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            sMainHandler.postAtTime(runnable, token, uptimeMillis);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCallbacks(Runnable r, Object token) {
        Class<UIThreadUtils> clazz = UIThreadUtils.class;
        synchronized (UIThreadUtils.class) {
            if (sMainHandler == null) {
                sMainHandler = new Handler(Looper.getMainLooper());
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            sMainHandler.removeCallbacks(r, token);
            return;
        }
    }
}

