/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter.base.report;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.base.report.DebugRouterMetaInfo;
import com.lynx.debugrouter.base.report.IDebugRouterReportService;
import com.lynx.debugrouter.base.service.DebugRouterServiceCenter;
import com.lynx.debugrouter.log.LLog;
import org.json.JSONObject;

public class DebugRouterReportServiceUtil {
    private static final String TAG = "DebugRouterReportServiceUtil";

    public static void init(@NonNull DebugRouterMetaInfo info) {
        if (InnerClass.service == null) {
            LLog.i(TAG, "init: DebugRouterReportService == null");
            return;
        }
        InnerClass.service.init(info);
    }

    public static void report(@NonNull String eventName, @Nullable JSONObject category, @Nullable JSONObject metric, @Nullable JSONObject logExtend) {
        if (InnerClass.service == null) {
            LLog.i(TAG, "report: DebugRouterReportService == null");
            return;
        }
        if (category == null) {
            category = new JSONObject();
        }
        if (metric == null) {
            metric = new JSONObject();
        }
        if (logExtend == null) {
            logExtend = new JSONObject();
        }
        InnerClass.service.report(eventName, category, metric, logExtend);
    }

    private static class InnerClass {
        private static final IDebugRouterReportService service = DebugRouterServiceCenter.instance().getService(IDebugRouterReportService.class);

        private InnerClass() {
        }
    }
}

