/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter.base.service;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.base.service.IRouterServiceProvider;
import com.lynx.debugrouter.log.LLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DebugRouterServiceCenter {
    private static final String TAG = "DebugRouterServiceCenter";
    private static volatile DebugRouterServiceCenter instance = null;
    private Map<Class<? extends IRouterServiceProvider>, IRouterServiceProvider> serviceMap = new ConcurrentHashMap<Class<? extends IRouterServiceProvider>, IRouterServiceProvider>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DebugRouterServiceCenter instance() {
        if (instance != null) return instance;
        Class<DebugRouterServiceCenter> clazz = DebugRouterServiceCenter.class;
        synchronized (DebugRouterServiceCenter.class) {
            if (instance != null) return instance;
            instance = new DebugRouterServiceCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Nullable
    public <T extends IRouterServiceProvider> T getService(Class<T> clazz) {
        if (this.serviceMap.containsKey(clazz)) {
            return (T)this.serviceMap.get(clazz);
        }
        LLog.e(TAG, clazz.getSimpleName() + " is unregistered");
        return null;
    }

    public void registerService(Class<? extends IRouterServiceProvider> clazz, @NonNull IRouterServiceProvider instance) {
        this.serviceMap.put(clazz, instance);
    }

    public void unregisterService(Class<? extends IRouterServiceProvider> clazz, IRouterServiceProvider instance) {
        this.serviceMap.remove(clazz, instance);
    }

    public void unregisterAllService() {
        this.serviceMap.clear();
    }
}

