/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import android.app.Application;
import android.content.Context;
import android.widget.Toast;
import com.lynx.debugrouter.ConnectionType;
import com.lynx.debugrouter.StateListener;
import com.lynx.debugrouter.Utils;
import com.lynx.debugrouter.base.UIThreadUtils;
import com.lynx.debugrouter.log.LLog;

public class DebugRouterStateListener
implements StateListener {
    private static final String TAG = "DebugRouterStateListener";
    private long mStartTime = -1L;

    @Override
    public void onOpen(ConnectionType type) {
        LLog.i(TAG, "onOpen: " + (Object)((Object)type));
        this.mStartTime = System.nanoTime();
    }

    @Override
    public void onClose(int code, String reason) {
    }

    @Override
    public void onMessage(String text) {
    }

    @Override
    public void onError(String error) {
    }

    private void toastUser(int mRetryTimes, Throwable t, boolean isWebSocket) {
        if (!isWebSocket) {
            return;
        }
        if (mRetryTimes != 0) {
            LLog.i(TAG, "only toast in first connection when error occurs");
            return;
        }
        if (t == null) {
            LLog.w(TAG, "toastUser: t == null");
            return;
        }
        Application context = Utils.getApplicationContext();
        if (context == null) {
            return;
        }
        String message = t.getMessage();
        if (message != null && (message.contains("ERR_INTERNET_DISCONNECTED") || message.contains("java.net.ConnectException"))) {
            UIThreadUtils.runOnUiThreadImmediately(new Runnable((Context)context){
                final /* synthetic */ Context val$context;
                {
                    this.val$context = context;
                }

                @Override
                public void run() {
                    Toast.makeText((Context)this.val$context, (CharSequence)"The internet is disconnected", (int)0).show();
                }
            });
            return;
        }
        if (message != null && (message.contains("WebSocket opening handshake timed out") || message.contains("java.net.SocketTimeoutException"))) {
            UIThreadUtils.runOnUiThreadImmediately(new Runnable((Context)context){
                final /* synthetic */ Context val$context;
                {
                    this.val$context = context;
                }

                @Override
                public void run() {
                    Toast.makeText((Context)this.val$context, (CharSequence)"The network connection timed out. Please check if desktop and phone are on the same network", (int)1).show();
                }
            });
        }
    }
}

