/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import android.view.View;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.DebugRouter;
import com.lynx.debugrouter.DebugRouterSlotDelegate;
import com.lynx.debugrouter.MessageAssembler;
import com.lynx.debugrouter.log.LLog;
import java.lang.reflect.Method;
import java.util.Map;

public class DebugRouterSlot {
    private static final String TAG = "DebugRouterSlot";
    private int mSessionId;
    private DebugRouterSlotDelegate mDelegate;
    private boolean mPlugged;
    private String mType = "";

    public DebugRouterSlot(DebugRouterSlotDelegate delegate) {
        this.mDelegate = delegate;
    }

    public int plug() {
        this.pull();
        this.mSessionId = DebugRouter.getInstance().plug(this);
        this.mPlugged = true;
        return this.mSessionId;
    }

    public void pull() {
        if (this.mPlugged) {
            DebugRouter.getInstance().pull(this.mSessionId);
            this.mPlugged = false;
        }
    }

    public void send(String message) {
        DebugRouter.getInstance().send(message);
    }

    public void sendData(String type, String data) {
        DebugRouter.getInstance().sendData(type, this.mSessionId, data);
    }

    public void sendData(String type, String data, int mark) {
        DebugRouter.getInstance().sendData(type, this.mSessionId, data, mark);
    }

    public void sendAsync(String message) {
        DebugRouter.getInstance().sendAsync(message);
    }

    public void sendDataAsync(String type, String data) {
        DebugRouter.getInstance().sendDataAsync(type, this.mSessionId, data);
    }

    @Deprecated
    public void sendDataAsync(String type, String data, int mark) {
        DebugRouter.getInstance().sendDataAsync(type, this.mSessionId, data, mark);
    }

    public String getTemplateUrl() {
        if (this.mDelegate != null && this.mDelegate.getTemplateUrl() != null) {
            return this.mDelegate.getTemplateUrl();
        }
        return "___UNKNOWN___";
    }

    @Deprecated
    @Nullable
    public View getTemplateView() {
        if (this.mDelegate != null) {
            try {
                Class<?> ownerClass = this.mDelegate.getClass();
                Method method = ownerClass.getMethod("getTemplateView", new Class[0]);
                Object obj = method.invoke((Object)this.mDelegate, new Object[0]);
                View view = (View)obj;
                return view;
            }
            catch (Exception exception) {
                LLog.e(TAG, "failed to invoke getTemplateView");
            }
        }
        return null;
    }

    public void onMessage(String type, String message) {
        if (this.mDelegate != null) {
            this.mDelegate.onMessage(type, message);
        }
    }

    @Deprecated
    public void dispatchDocumentUpdated() {
        String data = MessageAssembler.assembleDispatchDocumentUpdated();
        this.sendDataAsync("CDP", data);
    }

    @Deprecated
    public void dispatchFrameNavigated(String url) {
        String data = MessageAssembler.assembleDispatchFrameNavigated(url);
        this.sendDataAsync("CDP", data);
    }

    @Deprecated
    public void clearScreenCastCache() {
    }

    @Deprecated
    public void dispatchScreencastVisibilityChanged(boolean status) {
        String data = MessageAssembler.assembleDispatchScreencastVisibilityChanged(status);
        this.sendDataAsync("CDP", data);
    }

    @Deprecated
    public void sendScreenCast(String data, Map<String, Float> metaData) {
        String msg = MessageAssembler.assembleScreenCastFrame(this.mSessionId, data, metaData);
        this.sendDataAsync("CDP", msg);
    }

    public void setType(String type) {
        this.mType = type;
    }

    public String getType() {
        return this.mType;
    }
}

