/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.lynx.debugrouter.app.MessageHandleResult;
import com.lynx.debugrouter.app.MessageHandler;
import com.lynx.debugrouter.base.CalledByNative;
import com.lynx.debugrouter.log.LLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class MessageHandlerDelegate
implements MessageHandler {
    private static final String TAG = "MessageHandlerDelegate";
    private MessageHandler handler;

    public MessageHandlerDelegate(@NonNull MessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public MessageHandleResult handle(Map<String, String> params) {
        LLog.i(TAG, "handle: " + params);
        return this.handler.handle(params);
    }

    @CalledByNative
    public String handleAppAction(String params) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JSONObject json = new JSONObject(params);
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, json.optString(key));
            }
        }
        catch (JSONException e) {
            LLog.e(TAG, "params resolve error:" + params);
            return new MessageHandleResult(-1, "params resolve error").toJsonString();
        }
        MessageHandleResult result = this.handle(map);
        if (result == null) {
            return new MessageHandleResult().toJsonString();
        }
        return result.toJsonString();
    }

    @Override
    @CalledByNative
    public String getName() {
        return this.handler.getName();
    }
}

