/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import androidx.annotation.Keep;
import com.lynx.debugrouter.DebugRouterSlot;
import com.lynx.debugrouter.base.CalledByNative;

@Keep
public class NativeSlotDelegate {
    private DebugRouterSlot slot;
    private String url;
    private String type;

    public NativeSlotDelegate(DebugRouterSlot slot) {
        this.slot = slot;
        this.url = slot.getTemplateUrl();
        this.type = slot.getType();
    }

    @CalledByNative
    public void onMessage(String type, String message) {
        if (this.slot != null) {
            this.slot.onMessage(type, message);
        }
    }

    @CalledByNative
    public String getUrl() {
        return this.url;
    }

    @CalledByNative
    public String getType() {
        return this.type;
    }
}

