/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter.log;

import android.util.Log;
import androidx.annotation.Keep;
import com.lynx.debugrouter.DebugRouter;
import com.lynx.debugrouter.base.CalledByNative;
import com.lynx.debugrouter.log.AbsLogDelegate;
import com.lynx.debugrouter.log.ILogDelegate;
import com.lynx.debugrouter.log.LogSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Keep
public class LLog {
    private static final String TAG = "DebugRouter_LLog";
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    public static final int REPORT = 8;
    private static int sHandlerId = -1;
    private static final ConcurrentHashMap<Integer, ILogDelegate> sHandlerMap = new ConcurrentHashMap();
    private static Integer currentId = 0;
    private static final int sDefaultLogLevel = 6;
    private static int sNativeMinLogLevel = 6;
    private static int[] sNativeLevelMap;

    public static void setMinimumLoggingLevel(int level) {
        LLog.ensureNativeLibraryLoaded();
        if (sNativeMinLogLevel != level) {
            sNativeMinLogLevel = level;
        }
        try {
            LLog.initNativeLogLevelMap();
            LLog.nativeSetNativeMinLogLevel(sNativeLevelMap[level]);
        }
        catch (Throwable t) {
            sNativeMinLogLevel = 6;
            LLog.nativeSetNativeMinLogLevel(sNativeLevelMap[sNativeMinLogLevel]);
        }
    }

    public static synchronized int addLoggingDelegate(AbsLogDelegate delegate) {
        LLog.ensureNativeLibraryLoaded();
        if (delegate == null) {
            return -1;
        }
        Integer id = currentId = Integer.valueOf(currentId + 1);
        if (delegate.type() == 1) {
            if (sHandlerId != -1) {
                sHandlerMap.remove(sHandlerId);
            }
            sHandlerId = id;
            LLog.resetMinLogLevel();
        }
        sHandlerMap.put(id, delegate);
        LLog.nativeSetHasLoggingDelegate(true);
        return id;
    }

    public static synchronized void addDebugLoggingDelegate() {
        LLog.addLoggingDelegate(new AbsLogDelegate(){});
    }

    private static void ensureNativeLibraryLoaded() {
        if (!DebugRouter.isNativeLibraryLoaded()) {
            DebugRouter.loadNativeLibrary();
        }
    }

    private static void resetMinLogLevel() {
        for (Map.Entry<Integer, ILogDelegate> entrys : sHandlerMap.entrySet()) {
            ILogDelegate delegate = entrys.getValue();
            if (sNativeMinLogLevel == 6) {
                sNativeMinLogLevel = delegate.getMinimumLoggingLevel();
                continue;
            }
            sNativeMinLogLevel = Math.min(sNativeMinLogLevel, delegate.getMinimumLoggingLevel());
        }
        LLog.setMinimumLoggingLevel(sNativeMinLogLevel);
    }

    public static synchronized void removeLoggingDelegate(int delegateId) {
        sHandlerMap.remove(delegateId);
    }

    public static int getMinimumLoggingLevel() {
        ILogDelegate delegate = sHandlerMap.get(sHandlerId);
        if (delegate != null) {
            return delegate.getMinimumLoggingLevel();
        }
        return 4;
    }

    public static void v(String tag, String msg) {
        LLog.internalLog(2, tag, msg);
    }

    public static void d(String tag, String msg) {
        LLog.internalLog(3, tag, msg);
    }

    public static void i(String tag, String msg) {
        LLog.internalLog(4, tag, msg);
    }

    public static void w(String tag, String msg) {
        LLog.internalLog(5, tag, msg);
    }

    public static void e(String tag, String msg) {
        LLog.internalLog(6, tag, msg);
    }

    public static void report(String tag, String msg) {
        LLog.internalLog(8, tag, msg);
    }

    public static void internalLog(int level, String tag, String msg) {
        LLog.internalLog(level, tag, msg, LogSource.JAVA);
    }

    public static void internalLog(int level, String tag, String msg, LogSource source) {
        for (ILogDelegate d : sHandlerMap.values()) {
            if (!d.isLoggable(level)) continue;
            switch (level) {
                case 2: {
                    d.v(tag, msg);
                    break;
                }
                case 3: {
                    d.d(tag, msg);
                    break;
                }
                case 4: {
                    d.i(tag, msg);
                    break;
                }
                case 5: {
                    d.w(tag, msg);
                    break;
                }
                case 6: {
                    d.e(tag, msg);
                    break;
                }
                case 8: {
                    d.k(tag, msg);
                }
            }
        }
    }

    private static void initNativeLogLevelMap() {
        if (sNativeLevelMap == null) {
            sNativeLevelMap = new int[9];
            LLog.sNativeLevelMap[2] = -1;
            LLog.sNativeLevelMap[3] = 0;
            LLog.sNativeLevelMap[4] = 0;
            LLog.sNativeLevelMap[5] = 1;
            LLog.sNativeLevelMap[6] = 2;
            LLog.sNativeLevelMap[7] = 3;
            LLog.sNativeLevelMap[8] = 5;
        }
    }

    @CalledByNative
    private static void log(int priority, String tag, String msg) {
        try {
            if (priority != 7) {
                LLog.internalLog(priority, tag, msg, LogSource.Native);
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    private static native void nativeSetNativeMinLogLevel(int var0);

    private static native void nativeSetHasLoggingDelegate(boolean var0);
}

