/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import androidx.annotation.Keep;
import com.lynx.debugrouter.ConnectionType;
import com.lynx.debugrouter.StateListener;
import com.lynx.debugrouter.base.CalledByNative;
import com.lynx.debugrouter.log.LLog;

@Keep
public class NativeStateListenerDelegate {
    private static final String TAG = "NativeStateListenerDelegate";
    private StateListener listener;

    public NativeStateListenerDelegate(StateListener listener) {
        this.listener = listener;
    }

    @CalledByNative
    public void onOpen(String type) {
        if (this.listener != null) {
            switch (type) {
                case "websocket": {
                    this.listener.onOpen(ConnectionType.WebSocket);
                    break;
                }
                case "usb": {
                    this.listener.onOpen(ConnectionType.USB);
                    break;
                }
                default: {
                    LLog.e(TAG, "unknown type: " + type);
                }
            }
        }
    }

    @CalledByNative
    public void onClose(int code, String reason) {
        if (this.listener != null) {
            this.listener.onClose(code, reason);
        }
    }

    @CalledByNative
    public void onMessage(String text) {
        if (this.listener != null) {
            this.listener.onMessage(text);
        }
    }

    @CalledByNative
    public void onError(String error) {
        if (this.listener != null) {
            this.listener.onError(error);
        }
    }
}

