/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter.app;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.log.LLog;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MessageHandleResult {
    public static final int CODE_NOT_IMPLEMENTED = -2;
    public static final int CODE_HANDLE_FAILED = -1;
    public static final int CODE_HANDLE_SUCCESSFULLY = 0;
    private static final String TAG = "Result";
    private int mCode = -2;
    private String mMessage = "not implemented";
    private final Map<String, Object> data = new HashMap<String, Object>();

    public MessageHandleResult(int code, @NonNull String message) {
        this(code, message, null);
    }

    public MessageHandleResult(@Nullable Map<String, Object> data) {
        this(0, "", data);
    }

    public MessageHandleResult() {
        this(null);
    }

    public MessageHandleResult(int code, @NonNull String message, @Nullable Map<String, Object> data) {
        this.mCode = code;
        this.mMessage = message;
        if (data != null && data.size() > 0) {
            this.data.putAll(data);
        }
    }

    public String toJsonString() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("code", this.mCode).put("message", (Object)this.mMessage);
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
        }
        catch (JSONException e) {
            LLog.e(TAG, "toJsonString error:" + e.getMessage());
        }
        return jsonObject;
    }

    public Map<String, Object> getData() {
        return this.data;
    }
}

