/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter.base.usb;

import android.util.Log;
import com.lynx.debugrouter.base.MessageTransceiver;
import com.lynx.debugrouter.base.MessageTransceiverStateListener;
import com.lynx.debugrouter.base.report.DebugRouterReportServiceUtil;
import com.lynx.debugrouter.base.service.DebugRouterServiceCenter;
import com.lynx.debugrouter.base.usb.IUSBHijackService;
import com.lynx.debugrouter.base.usb.TemplateData;
import com.lynx.debugrouter.base.usb.TemplateFileSize;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\"\u0010\u001d\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\tJ\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001a0 J\u0006\u0010!\u001a\u00020\rJ\u0016\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u0016J\u0016\u0010$\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0018J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u000e\u0010(\u001a\u00020\t2\u0006\u0010'\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020\rJ\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\u000fJ\u000e\u0010-\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001a\u0012\u0004\u0012\u00020\r0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/lynx/debugrouter/base/usb/USBTransTemplateUtil;", "", "()V", "TAG", "", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "globalRequestId", "", "ipPortRegex", "Lkotlin/text/Regex;", "mIsDebugPlatformSupport", "", "mTransceiver", "Lcom/lynx/debugrouter/base/MessageTransceiver;", "mUSBIsEnabled", "requestTimeOutTask", "", "Ljava/util/concurrent/ScheduledFuture;", "responseMap", "Ljava/util/TreeSet;", "Lcom/lynx/debugrouter/base/usb/TemplateData;", "responseSize", "Lcom/lynx/debugrouter/base/usb/TemplateFileSize;", "urlMap", "Lkotlin/Pair;", "addInterceptor", "", "getTemplateData", "reqId", "getUrlSet", "", "isUSBTransTemplateAvailable", "receiveData", "data", "receiveResponseSize", "size", "reportOpenCardUrl", "url", "requestData", "setDebugPlatformSupport", "support", "setUSBTransceiver", "transceiver", "updateUrlSet", "USBTransTemplateTransceiverListener", "DebugRouter_release"})
public final class USBTransTemplateUtil {
    @NotNull
    public static final USBTransTemplateUtil INSTANCE = new USBTransTemplateUtil();
    @NotNull
    private static final String TAG = "USBTransTemplateUtil";
    @NotNull
    private static final Regex ipPortRegex = new Regex("(?:http:\\/\\/|http%3A%2F%2F)((?:[0-9]{1,3}(?:\\.|%2E)){3}[0-9]{1,3})(?::|%3A)([0-9]{1,5})(?:\\/|%2F)");
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private static volatile boolean mUSBIsEnabled;
    @Nullable
    private static volatile MessageTransceiver mTransceiver;
    private static boolean mIsDebugPlatformSupport;
    @NotNull
    private static Map<Long, TreeSet<TemplateData>> responseMap;
    @NotNull
    private static Map<Long, TemplateFileSize> responseSize;
    @NotNull
    private static Map<Long, ScheduledFuture<?>> requestTimeOutTask;
    private static volatile long globalRequestId;
    @NotNull
    private static final Map<Pair<String, String>, Boolean> urlMap;

    private USBTransTemplateUtil() {
    }

    public final void addInterceptor() {
        Log.i((String)TAG, (String)"reflect to add Interceptor");
        try {
            IUSBHijackService usbService = DebugRouterServiceCenter.instance().getService(IUSBHijackService.class);
            if (usbService == null) {
                Log.i((String)TAG, (String)"usbService is null.");
                return;
            }
            usbService.addInterceptor();
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = "";
            }
            Log.e((String)TAG, (String)string);
        }
    }

    public final void setUSBTransceiver(@NotNull MessageTransceiver transceiver) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)transceiver, (String)"transceiver");
            Log.i((String)TAG, (String)"set USB Transceiver for USBTransTemplate");
            MessageTransceiver messageTransceiver = mTransceiver = transceiver;
            if (messageTransceiver == null) break block0;
            messageTransceiver.setStateListener(USBTransTemplateTransceiverListener.INSTANCE);
        }
    }

    public final boolean isUSBTransTemplateAvailable() {
        return mUSBIsEnabled && mIsDebugPlatformSupport;
    }

    public final void updateUrlSet(@NotNull String url) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            MatchResult matchResult = Regex.find$default((Regex)ipPortRegex, (CharSequence)url, (int)0, (int)2, null);
            if (matchResult == null) break block1;
            MatchResult it = matchResult;
            boolean bl = false;
            List groupValues = it.getGroupValues();
            if (groupValues.size() != 3) {
                Log.e((String)TAG, (String)("ipPort is illegal: " + url));
                return;
            }
            urlMap.put((Pair<String, String>)new Pair(groupValues.get(1), groupValues.get(2)), true);
        }
    }

    @NotNull
    public final Set<Pair<String, String>> getUrlSet() {
        return urlMap.keySet();
    }

    public final long requestData(@NotNull String url) {
        long reqId;
        block0: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            long l = globalRequestId;
            globalRequestId = l + 1L;
            reqId = l;
            Long l2 = reqId;
            responseMap.put(l2, new TreeSet());
            Runnable task = () -> USBTransTemplateUtil.requestData$lambda-1(reqId, url);
            ScheduledFuture<?> future = executor.schedule(task, 8L, TimeUnit.SECONDS);
            Long l3 = reqId;
            Intrinsics.checkNotNullExpressionValue(future, (String)"future");
            requestTimeOutTask.put(l3, future);
            MessageTransceiver messageTransceiver = mTransceiver;
            if (messageTransceiver == null) break block0;
            messageTransceiver.send("{\"data\":{\"data\":{\"client_id\":-1,\"message\": \"{\\\"method\\\":\\\"DownloadTemplateByUsb\\\",\\\"params\\\":{\\\"requestId\\\":" + reqId + ", \\\"url\\\":\\\"" + url + "\\\"}}\",\"session_id\": -1},\"sender\": -1,\"type\": \"CDP\"},\"event\": \"Customized\"}");
        }
        return reqId;
    }

    public final void receiveData(long reqId, @NotNull TemplateData data) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            ScheduledFuture<?> scheduledFuture = requestTimeOutTask.get(reqId);
            if (scheduledFuture == null) break block1;
            ScheduledFuture<?> it = scheduledFuture;
            boolean bl = false;
            TreeSet<TemplateData> treeSet = responseMap.get(reqId);
            if (treeSet != null) {
                treeSet.add(data);
            }
        }
    }

    public final void receiveResponseSize(long reqId, @NotNull TemplateFileSize size) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            ScheduledFuture<?> scheduledFuture = requestTimeOutTask.get(reqId);
            if (scheduledFuture == null) break block0;
            ScheduledFuture<?> it = scheduledFuture;
            boolean bl = false;
            it.cancel(true);
            requestTimeOutTask.remove(reqId);
            Long l = reqId;
            responseSize.put(l, size);
        }
    }

    @Nullable
    public final Pair<TreeSet<TemplateData>, TemplateFileSize> getTemplateData(long reqId) {
        TreeSet<TemplateData> dataSet;
        TemplateFileSize templateFileSize = responseSize.get(reqId);
        if (templateFileSize == null) {
            return null;
        }
        TemplateFileSize size = templateFileSize;
        if (size.isError()) {
            return new Pair(new TreeSet(), (Object)size);
        }
        TreeSet<TemplateData> treeSet = dataSet = responseMap.get(reqId);
        if (treeSet != null) {
            TreeSet<TemplateData> it = treeSet;
            boolean bl = false;
            if (it.size() == size.getSeqCount()) {
                return new Pair(dataSet, (Object)size);
            }
        }
        return null;
    }

    public final void setDebugPlatformSupport(boolean support) {
        mIsDebugPlatformSupport = support;
    }

    private final void reportOpenCardUrl(String url) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("url", (Object)url);
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)("reportOpenCardUrl:" + (Object)((Object)e)));
        }
        DebugRouterReportServiceUtil.report("USBOpenCardUrl", jsonObject, null, null);
    }

    private static final void requestData$lambda-1(long $reqId, String $url) {
        Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
        requestTimeOutTask.remove($reqId);
        Log.w((String)TAG, (String)("reqId:" + $reqId + ", url: " + $url + " is timeout"));
        Long l = $reqId;
        responseSize.put(l, new TemplateFileSize(-3, -3));
        l = $reqId;
        responseMap.put(l, new TreeSet());
    }

    static {
        responseMap = new ConcurrentHashMap();
        responseSize = new ConcurrentHashMap();
        requestTimeOutTask = new ConcurrentHashMap();
        urlMap = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/lynx/debugrouter/base/usb/USBTransTemplateUtil$USBTransTemplateTransceiverListener;", "Lcom/lynx/debugrouter/base/MessageTransceiverStateListener;", "()V", "onClose", "", "transceiver", "Lcom/lynx/debugrouter/base/MessageTransceiver;", "code", "", "reason", "", "onError", "t", "", "onMessage", "text", "onOpen", "DebugRouter_release"})
    public static final class USBTransTemplateTransceiverListener
    implements MessageTransceiverStateListener {
        @NotNull
        public static final USBTransTemplateTransceiverListener INSTANCE = new USBTransTemplateTransceiverListener();

        private USBTransTemplateTransceiverListener() {
        }

        @Override
        public void onOpen(@Nullable MessageTransceiver transceiver) {
            Log.i((String)USBTransTemplateUtil.TAG, (String)"onOpen");
            mUSBIsEnabled = true;
            urlMap.clear();
        }

        @Override
        public void onClose(@Nullable MessageTransceiver transceiver, int code, @Nullable String reason) {
            mUSBIsEnabled = false;
        }

        @Override
        public void onMessage(@Nullable MessageTransceiver transceiver, @Nullable String text) {
            String string = text;
            if (string != null) {
                String msg = string;
                boolean bl = false;
                if (StringsKt.indexOf$default((CharSequence)msg, (String)"OpenCard", (int)0, (boolean)false, (int)6, null) != -1) {
                    JSONObject messageObj = new JSONObject(msg);
                    Object object = messageObj.opt("data");
                    JSONObject jSONObject = object instanceof JSONObject ? (JSONObject)object : null;
                    Object object2 = jSONObject != null ? jSONObject.opt("data") : null;
                    JSONObject jSONObject2 = object2 instanceof JSONObject ? (JSONObject)object2 : null;
                    Object object3 = jSONObject2 != null ? jSONObject2.opt("url") : null;
                    String string2 = object3 instanceof String ? (String)object3 : null;
                    if (string2 != null) {
                        String it = string2;
                        boolean bl2 = false;
                        Log.i((String)USBTransTemplateUtil.TAG, (String)("OpenCard url: " + it));
                        INSTANCE.updateUrlSet(it);
                        INSTANCE.reportOpenCardUrl(it);
                    }
                    return;
                }
            }
        }

        @Override
        public void onError(@Nullable MessageTransceiver transceiver, @Nullable Throwable t) {
            mUSBIsEnabled = false;
        }
    }
}

