/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import android.app.Application;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.CallStaticVoidMethodHandler;
import com.lynx.debugrouter.ConnectionState;
import com.lynx.debugrouter.DebugRouterGlobalHandler;
import com.lynx.debugrouter.DebugRouterReport;
import com.lynx.debugrouter.DebugRouterSessionHandler;
import com.lynx.debugrouter.DebugRouterSlot;
import com.lynx.debugrouter.DebugRouterStateListener;
import com.lynx.debugrouter.GlobalHandlerDelegate;
import com.lynx.debugrouter.MessageHandlerDelegate;
import com.lynx.debugrouter.NativeSlotDelegate;
import com.lynx.debugrouter.NativeStateListenerDelegate;
import com.lynx.debugrouter.OpenUsbTransTemplateSwitchHandler;
import com.lynx.debugrouter.ReceiveTemplateByUsbHandler;
import com.lynx.debugrouter.SessionHandlerDelegate;
import com.lynx.debugrouter.StateListener;
import com.lynx.debugrouter.app.MessageHandler;
import com.lynx.debugrouter.base.report.DebugRouterMetaInfo;
import com.lynx.debugrouter.base.report.DebugRouterReportServiceUtil;
import com.lynx.debugrouter.base.usb.USBTransTemplateUtil;
import com.lynx.debugrouter.log.LLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.json.JSONObject;

public class DebugRouter {
    private static final String TAG = "DebugRouter";
    private static volatile DebugRouter sInstance;
    private static boolean mIsNativeLibraryLoaded;
    private static final WeakHashMap<View, Integer> viewMap;
    private final Map<DebugRouterSessionHandler, Integer> mSessionHandlers = new HashMap<DebugRouterSessionHandler, Integer>();
    private final Map<DebugRouterGlobalHandler, Integer> mGlobalHandlers = new HashMap<DebugRouterGlobalHandler, Integer>();

    private DebugRouter() {
        DebugRouter.loadNativeLibrary();
        LLog.addDebugLoggingDelegate();
        this.nativeCreateDebugRouter();
        this.initAppInfo();
        DebugRouterReportServiceUtil.init(new DebugRouterMetaInfo(this.getVersion(), this.getCurrentProcessName()));
        DebugRouterReportServiceUtil.report("DebugRouterInit", null, null, null);
        this.addMessageHandler(new CallStaticVoidMethodHandler());
        this.addMessageHandler(new OpenUsbTransTemplateSwitchHandler());
        this.addMessageHandler(new ReceiveTemplateByUsbHandler());
        this.addStateListener(new DebugRouterStateListener());
        USBTransTemplateUtil.INSTANCE.addInterceptor();
    }

    private native void nativeCreateDebugRouter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DebugRouter getInstance() {
        if (sInstance != null) return sInstance;
        Class<DebugRouter> clazz = DebugRouter.class;
        synchronized (DebugRouter.class) {
            if (sInstance != null) return sInstance;
            sInstance = new DebugRouter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static boolean isNativeLibraryLoaded() {
        return mIsNativeLibraryLoaded;
    }

    public static void loadNativeLibrary() {
        if (!mIsNativeLibraryLoaded) {
            try {
                System.loadLibrary("lynxdebugrouter");
                mIsNativeLibraryLoaded = true;
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("failed to load debugrouter: " + t.toString()));
            }
        }
    }

    private native String nativeGetRoomId();

    private native String nativeGetServerUrl();

    @Deprecated
    public String getRoomId() {
        return this.nativeGetRoomId();
    }

    @Deprecated
    public String getServerUrl() {
        return this.nativeGetServerUrl();
    }

    private void initAppInfo() {
        String model = Build.MODEL;
        String manufacturer = Build.MANUFACTURER;
        String deviceModel = model.startsWith(manufacturer) ? model : manufacturer + " " + model;
        String appPrcossName = this.getCurrentProcessName();
        this.nativeSetAppInfo("App", appPrcossName);
        this.nativeSetAppInfo("AppVersion", "1.0");
        this.nativeSetAppInfo("AppProcessName", appPrcossName);
        this.nativeSetAppInfo("manufacturer", manufacturer);
        this.nativeSetAppInfo("model", model);
        this.nativeSetAppInfo("deviceModel", deviceModel);
        this.nativeSetAppInfo("osVersion", Build.VERSION.RELEASE);
        this.nativeSetAppInfo("debugRouterVersion", this.getVersion());
        UUID id_string = UUID.randomUUID();
        this.nativeSetAppInfo("debugRouterId", id_string.toString());
    }

    public synchronized void setAppInfo(Map<String, String> appInfo) {
        this.setAppInfo(null, appInfo);
    }

    public synchronized void setAppInfo(Context context, Map<String, String> appInfo) {
        for (String key : appInfo.keySet()) {
            this.nativeSetAppInfo(key, appInfo.get(key));
        }
        this.nativeSetAppInfo("network", this.checkNetworkStatus(context));
    }

    private native void nativeSetAppInfo(String var1, String var2);

    public String getAppInfoByKey(String key) {
        return this.nativeGetAppInfoByKey(key);
    }

    private native String nativeGetAppInfoByKey(String var1);

    public void addGlobalHandler(DebugRouterGlobalHandler handler) {
        if (handler == null) {
            return;
        }
        GlobalHandlerDelegate currHandler = new GlobalHandlerDelegate(handler);
        int handlerId = this.nativeAddNativeGlobalHandler(currHandler);
        this.mGlobalHandlers.put(handler, handlerId);
    }

    private native int nativeAddNativeGlobalHandler(GlobalHandlerDelegate var1);

    public boolean removeGlobalHandler(DebugRouterGlobalHandler handler) {
        if (handler == null) {
            return false;
        }
        Integer removedHandlerId = this.mGlobalHandlers.remove(handler);
        if (removedHandlerId != null) {
            return this.nativeRemoveNativeGlobalHandler(removedHandlerId);
        }
        return false;
    }

    private native boolean nativeRemoveNativeGlobalHandler(int var1);

    public void addMessageHandler(MessageHandler handler) {
        if (handler == null) {
            return;
        }
        this.nativeAddNativeMessageHandler(new MessageHandlerDelegate(handler));
    }

    private native void nativeAddNativeMessageHandler(MessageHandlerDelegate var1);

    public boolean removeMessageHandler(MessageHandler handler) {
        if (handler == null) {
            return false;
        }
        return this.nativeRemoveNativeMessageHandler(handler.getName());
    }

    private native boolean nativeRemoveNativeMessageHandler(String var1);

    public void addSessionHandler(DebugRouterSessionHandler handler) {
        if (handler == null) {
            return;
        }
        SessionHandlerDelegate currHandler = new SessionHandlerDelegate(handler);
        int handlerId = this.nativeAddNativeSessionHandler(currHandler);
        this.mSessionHandlers.put(handler, handlerId);
    }

    private native int nativeAddNativeSessionHandler(SessionHandlerDelegate var1);

    public boolean removeSessionHandler(DebugRouterSessionHandler handler) {
        if (handler == null) {
            return false;
        }
        Integer removedHandlerId = this.mSessionHandlers.remove(handler);
        if (removedHandlerId != null) {
            return this.nativeRemoveNativeSessionHandler(removedHandlerId);
        }
        return false;
    }

    private native boolean nativeRemoveNativeSessionHandler(int var1);

    @Deprecated
    public void connect(String url, String room) {
        LLog.i(TAG, "connect url:" + url + ", room:" + room);
        this.nativeConnect(url, room);
    }

    private native void nativeConnect(String var1, String var2);

    private native void nativeDisconnect();

    private native void nativeConnectAsync(String var1, String var2);

    private native void nativeDisconnectAsync();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionIdByView(@NonNull View view) {
        WeakHashMap<View, Integer> weakHashMap = viewMap;
        synchronized (weakHashMap) {
            Integer sessionId = viewMap.get(view);
            return sessionId == null ? 0 : sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public View getViewBySessionId(int sessionId) {
        WeakHashMap<View, Integer> weakHashMap = viewMap;
        synchronized (weakHashMap) {
            for (Map.Entry<View, Integer> entry : viewMap.entrySet()) {
                int viewSessionId = entry.getValue();
                if (viewSessionId != sessionId) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionIdOfView(@NonNull View view, int sessionId) {
        WeakHashMap<View, Integer> weakHashMap = viewMap;
        synchronized (weakHashMap) {
            viewMap.put(view, sessionId);
        }
    }

    @Deprecated
    public void disconnect() {
        LLog.i(TAG, "disconnect");
        this.nativeDisconnect();
    }

    public void connectAsync(String url, String room) {
        LLog.i(TAG, "connectAsync url:" + url + ", room:" + room);
        this.nativeConnectAsync(url, room);
    }

    public void disconnectAsync() {
        this.nativeDisconnectAsync();
    }

    private native int nativePlug(NativeSlotDelegate var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int plug(@NonNull DebugRouterSlot slot) {
        LLog.i(TAG, "plug session " + slot.getTemplateUrl());
        int sessionId = this.nativePlug(new NativeSlotDelegate(slot));
        View view = slot.getTemplateView();
        if (view != null) {
            WeakHashMap<View, Integer> weakHashMap = viewMap;
            synchronized (weakHashMap) {
                viewMap.put(view, sessionId);
            }
        }
        return sessionId;
    }

    private native void nativePull(int var1);

    public void pull(int sessionId) {
        LLog.i(TAG, "pull session " + sessionId);
        this.nativePull(sessionId);
    }

    private native void nativeSend(String var1);

    public void send(String message) {
        if (message == null) {
            LLog.i(TAG, "send: message == null");
            return;
        }
        this.nativeSend(message);
    }

    public void sendData(String type, int session, String data) {
        this.sendData(type, session, data, -1);
    }

    public void sendData(String type, int session, String data, int mark) {
        this.sendData(type, session, data, mark, false);
    }

    public void sendData(String type, int session, JSONObject data) {
        this.sendData(type, session, data, -1);
    }

    public void sendData(String type, int session, JSONObject data, int mark) {
        this.sendData(type, session, data.toString(), mark, true);
    }

    private native void nativeSendData(String var1, int var2, String var3, int var4, boolean var5);

    private native void nativeSendDataAsync(String var1, int var2, String var3, int var4, boolean var5);

    private void sendData(String type, int session, String data, int mark, boolean isObject) {
        if (data == null) {
            LLog.i(TAG, "sendData: message == null");
            return;
        }
        this.nativeSendData(type, session, data, mark, isObject);
    }

    private native void nativeSendAsync(String var1);

    public void sendAsync(String message) {
        this.nativeSendAsync(message);
    }

    public void sendDataAsync(String type, int session, String data) {
        this.sendDataAsync(type, session, data, -1);
    }

    public void sendDataAsync(String type, int session, String data, int mark) {
        this.nativeSendDataAsync(type, session, data, mark, false);
    }

    public void sendDataAsync(String type, int session, JSONObject data) {
        this.sendDataAsync(type, session, data, -1);
    }

    public void sendDataAsync(String type, int session, JSONObject data, int mark) {
        this.nativeSendDataAsync(type, session, data.toString(), mark, true);
    }

    private native boolean nativeIsValidSchema(String var1);

    public boolean isValidSchema(@NonNull String schema) {
        return this.nativeIsValidSchema(schema);
    }

    private native boolean nativeHandleSchema(String var1);

    public boolean handleSchema(@NonNull String schema) {
        DebugRouterReport.reportHandleSchema(schema);
        return this.nativeHandleSchema(schema);
    }

    private native void nativeAddStateListener(NativeStateListenerDelegate var1);

    public void addStateListener(StateListener listener) {
        if (listener != null) {
            this.nativeAddStateListener(new NativeStateListenerDelegate(listener));
        }
    }

    public String getVersion() {
        return "0.0.1";
    }

    public static int getUSBPort() {
        return DebugRouter.getInstance().nativeGetUSBPort();
    }

    private native int nativeGetConnectionState();

    @Deprecated
    public ConnectionState getConnectionState() {
        int state = this.nativeGetConnectionState();
        switch (state) {
            case -1: {
                return ConnectionState.DISCONNECTED;
            }
            case 1: {
                return ConnectionState.CONNECTED;
            }
        }
        return ConnectionState.DISCONNECTED;
    }

    private native int nativeGetUSBPort();

    private String checkNetworkStatus(Context context) {
        if (context == null) {
            return "";
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null || cm.getActiveNetworkInfo() == null) {
            return "";
        }
        return cm.getActiveNetworkInfo().getTypeName();
    }

    private String getCurrentProcessName() {
        String processName = "android";
        try {
            Method declaredMethod = Class.forName("android.app.ActivityThread", false, Application.class.getClassLoader()).getDeclaredMethod("currentProcessName", new Class[0]);
            declaredMethod.setAccessible(true);
            Object invoke = declaredMethod.invoke(null, new Object[0]);
            if (invoke instanceof String) {
                processName = (String)invoke;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return processName;
    }

    public void setConfig(@NonNull String configKey, @NonNull Boolean value) {
        this.nativeSetConfig(configKey, value.toString());
    }

    private native void nativeSetConfig(String var1, String var2);

    private native String nativeGetConfig(String var1, String var2);

    public Boolean getConfig(@NonNull String configKey, @NonNull Boolean defaultValue) {
        String value = this.nativeGetConfig(configKey, defaultValue.toString());
        if ("true".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        LLog.w(TAG, "getConfig: value is illegal");
        return false;
    }

    static {
        viewMap = new WeakHashMap();
    }
}

