/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import com.lynx.debugrouter.log.LLog;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class MonitorRunnable
implements Runnable {
    private static final String TAG = "MonitorRunnable";
    private static final String CONNECT_RUNNABLE = "connect";
    private static final long TIME_THRESHOLD = 3000000000L;
    private static ScheduledExecutorService sTimer = Executors.newScheduledThreadPool(1);
    private static volatile MonitorRunnable sCurMonitorRunnable = null;
    private static volatile int sRunnableCount = 0;
    private Runnable mRunnable;
    private String mRunnableTag;
    private Future mMonitorTask;

    public MonitorRunnable(Runnable runnable, final String runnableTag) {
        this.mRunnable = runnable;
        this.mRunnableTag = runnableTag;
        ++sRunnableCount;
        if (CONNECT_RUNNABLE.equals(runnableTag)) {
            LLog.i(TAG, "MonitorRunnableCount: " + sRunnableCount);
        }
        this.mMonitorTask = sTimer.schedule(new Runnable(){

            @Override
            public void run() {
                LLog.e(MonitorRunnable.TAG, MonitorRunnable.this.mRunnable.hashCode() + runnableTag + " exe timeout:" + 3000000000L + " sCurMonitorRunnable:" + sCurMonitorRunnable);
            }
        }, 3000000000L, TimeUnit.NANOSECONDS);
    }

    @Override
    public void run() {
        sCurMonitorRunnable = this;
        long startTime = System.nanoTime();
        this.mRunnable.run();
        long duration = System.nanoTime() - startTime;
        --sRunnableCount;
        this.mMonitorTask.cancel(false);
        if (duration >= 1000000000L) {
            LLog.w(TAG, this.mRunnable.hashCode() + this.mRunnableTag + " exe time is too large:" + duration);
        }
        sCurMonitorRunnable = null;
    }

    public String toString() {
        return "MonitorRunnable_" + this.mRunnable.hashCode() + this.mRunnableTag;
    }
}

