/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import androidx.annotation.Keep;
import com.lynx.debugrouter.DebugRouterSessionHandler;
import com.lynx.debugrouter.base.CalledByNative;

@Keep
public class SessionHandlerDelegate
implements DebugRouterSessionHandler {
    private DebugRouterSessionHandler handler;

    public SessionHandlerDelegate(DebugRouterSessionHandler handler) {
        this.handler = handler;
    }

    @Override
    @CalledByNative
    public void onSessionCreate(int sessionId, String url) {
        if (this.handler != null) {
            this.handler.onSessionCreate(sessionId, url);
        }
    }

    @Override
    @CalledByNative
    public void onSessionDestroy(int sessionId) {
        if (this.handler != null) {
            this.handler.onSessionDestroy(sessionId);
        }
    }

    @Override
    @CalledByNative
    public void onMessage(String message, String type, int sessionId) {
        if (this.handler != null) {
            this.handler.onMessage(message, type, sessionId);
        }
    }
}

