/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.debugrouter;

import androidx.annotation.Keep;
import com.lynx.debugrouter.base.CalledByNative;
import com.lynx.debugrouter.base.report.DebugRouterReportServiceUtil;
import com.lynx.debugrouter.log.LLog;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class NativeReportDelegate {
    private static final String TAG = "NativeReportDelegate";

    private static JSONObject stringToJSONObject(String jsonName, String jsonString) {
        try {
            return new JSONObject(jsonString);
        }
        catch (JSONException e) {
            LLog.e(TAG, "Failed to parse " + jsonName + " JSON: " + e.getMessage());
            return new JSONObject();
        }
    }

    @CalledByNative
    public void report(String eventName, String category, String metric, String extra) {
        LLog.i(TAG, "report: " + eventName + ", " + category + ", " + metric + ", " + extra);
        JSONObject categoryObject = NativeReportDelegate.stringToJSONObject("category", category);
        JSONObject metricObject = NativeReportDelegate.stringToJSONObject("metric", metric);
        JSONObject extraObject = NativeReportDelegate.stringToJSONObject("extra", extra);
        DebugRouterReportServiceUtil.report(eventName, categoryObject, metricObject, extraObject);
    }
}

