/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import com.lynx.devtool.DevOptionHandler;
import com.lynx.devtool.LynxInspectorOwner;
import com.lynx.tasm.LynxView;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;

public class LynxDevMenu {
    private static final long PRESS_RANGE = 1000L;
    private static final long CLICK_RANGE = 15L;
    private final WeakReference<LynxInspectorOwner> mOwner;
    private float mStartX;
    private float mStartY;
    private float mPointX;
    private float mPointY;
    private AlertDialog mDevOptionsDialog;
    private Handler mLongPressHandler;
    private WeakReference<LynxView> mLynxView;

    public LynxDevMenu(LynxInspectorOwner owner, @Nullable LynxView lynxView) {
        this.mOwner = new WeakReference<LynxInspectorOwner>(owner);
        this.mLynxView = new WeakReference<LynxView>(lynxView);
        this.mDevOptionsDialog = null;
        this.mLongPressHandler = new Handler(Looper.getMainLooper());
    }

    public void attach(LynxView lynxView) {
        this.mLynxView = new WeakReference<LynxView>(lynxView);
    }

    public void showDevOptionsDialog() {
        if (this.mDevOptionsDialog != null) {
            return;
        }
        final LynxInspectorOwner owner = (LynxInspectorOwner)this.mOwner.get();
        if (owner == null) {
            return;
        }
        String message = "";
        if (owner.isDebugging()) {
            message = "IP: " + owner.getHttpServerIp() + "\nPort: " + owner.getHttpServerPort();
            message = message + "\nSession ID: " + owner.getSessionID();
        }
        LinkedHashMap<String, DevOptionHandler> options = new LinkedHashMap<String, DevOptionHandler>();
        if (!message.isEmpty()) {
            options.put(message, new DevOptionHandler(){

                @Override
                public void onOptionSelected() {
                }
            });
        }
        options.put("Reload", new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                owner.reload(false);
            }
        });
        final DevOptionHandler[] optionHandlers = options.values().toArray(new DevOptionHandler[0]);
        AlertDialog.Builder builder = new AlertDialog.Builder(owner.getLynxView().getContext());
        builder.setTitle((CharSequence)"Lynx Debug Menu");
        builder.setItems((CharSequence[])options.keySet().toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                optionHandlers[i].onOptionSelected();
                LynxDevMenu.this.mDevOptionsDialog = null;
            }
        });
        builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                LynxDevMenu.this.mDevOptionsDialog = null;
            }
        });
        this.mDevOptionsDialog = builder.create();
        this.mDevOptionsDialog.show();
    }

    public boolean onRootViewTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                return this.onActionDown(event);
            }
            case 2: {
                return this.onActionMove(event);
            }
            case 1: {
                return this.onActionUp(event);
            }
        }
        return this.onActionCancel(event);
    }

    private boolean isInViewArea(float x, float y) {
        LynxView lynxView = (LynxView)this.mLynxView.get();
        if (lynxView == null) {
            return false;
        }
        try {
            Rect r = new Rect();
            lynxView.getLocalVisibleRect(r);
            return x > (float)r.left && x < (float)r.right && y > (float)r.top && y < (float)r.bottom;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean onActionDown(MotionEvent event) {
        this.mStartX = event.getX();
        this.mStartY = event.getY();
        if (this.isInViewArea(this.mStartX, this.mStartY)) {
            this.mLongPressHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    try {
                        LynxDevMenu.this.showDevOptionsDialog();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }, 1000L);
        }
        return false;
    }

    private boolean onActionMove(MotionEvent event) {
        this.mPointX = event.getX();
        this.mPointY = event.getY();
        if (!this.isInViewArea(this.mPointX, this.mPointY) || Math.abs(this.mPointX - this.mStartX) > 15.0f || Math.abs(this.mPointY - this.mStartY) > 15.0f) {
            this.mLongPressHandler.removeCallbacksAndMessages(null);
        }
        return false;
    }

    private boolean onActionUp(MotionEvent event) {
        this.mLongPressHandler.removeCallbacksAndMessages(null);
        return false;
    }

    private boolean onActionCancel(MotionEvent event) {
        this.mLongPressHandler.removeCallbacksAndMessages(null);
        return false;
    }
}

