/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import androidx.annotation.NonNull;
import com.lynx.devtool.CDPResultCallbackWrapper;
import com.lynx.devtool.DevToolMessageHandlerDelegate;
import com.lynx.devtoolwrapper.CDPResultCallback;
import com.lynx.devtoolwrapper.MessageHandler;

public class LynxDevToolNGDelegate {
    private long mLynxDevToolNGPtr = this.nativeCreateLynxDevToolNG();
    private int mSessionId = 0;

    public int getSessionId() {
        return this.mSessionId;
    }

    public boolean isAttachToDebugRouter() {
        return this.mSessionId != 0;
    }

    private native long nativeCreateLynxDevToolNG();

    public void sendMessageToDebugPlatform(@NonNull String type, @NonNull String msg) {
        if (this.mLynxDevToolNGPtr != 0L) {
            this.nativeSendMessageToDebugPlatform(this.mLynxDevToolNGPtr, type, msg);
        }
    }

    private native void nativeSendMessageToDebugPlatform(long var1, String var3, String var4);

    public long onBackgroundRuntimeCreated(String groupName) {
        if (this.mLynxDevToolNGPtr != 0L) {
            return this.nativeOnBackgroundRuntimeCreated(this.mLynxDevToolNGPtr, groupName);
        }
        return 0L;
    }

    private native long nativeOnBackgroundRuntimeCreated(long var1, String var3);

    public void onTASMCreated(long shellPtr) {
        if (this.mLynxDevToolNGPtr != 0L) {
            this.nativeOnTasmCreated(this.mLynxDevToolNGPtr, shellPtr);
        }
    }

    private native void nativeOnTasmCreated(long var1, long var3);

    public void destroy() {
        if (this.mLynxDevToolNGPtr != 0L) {
            this.nativeDestroy(this.mLynxDevToolNGPtr);
            this.mLynxDevToolNGPtr = 0L;
        }
    }

    private native void nativeDestroy(long var1);

    public int attachToDebug(String url) {
        if (this.mLynxDevToolNGPtr != 0L) {
            this.mSessionId = this.nativeAttachToDebug(this.mLynxDevToolNGPtr, url);
            return this.mSessionId;
        }
        return 0;
    }

    private native int nativeAttachToDebug(long var1, String var3);

    public void detachToDebug() {
        if (this.mLynxDevToolNGPtr != 0L) {
            this.nativeDetachToDebug(this.mLynxDevToolNGPtr);
            this.mSessionId = 0;
        }
    }

    private native void nativeDetachToDebug(long var1);

    public void setDevToolPlatformAbility(long platformNativePtr) {
        if (this.mLynxDevToolNGPtr != 0L) {
            this.nativeSetDevToolPlatformAbility(this.mLynxDevToolNGPtr, platformNativePtr);
        }
    }

    private native void nativeSetDevToolPlatformAbility(long var1, long var3);

    public void subscribeMessage(String type, MessageHandler handler) {
        this.nativeSubscribeMessage(this.mLynxDevToolNGPtr, type, new DevToolMessageHandlerDelegate(handler));
    }

    private native void nativeSubscribeMessage(long var1, String var3, DevToolMessageHandlerDelegate var4);

    public void unSubscribeMessage(String type) {
        this.nativeUnSubscribeMessage(this.mLynxDevToolNGPtr, type);
    }

    private native void nativeUnSubscribeMessage(long var1, String var3);

    public void invokeCDPFromSDK(String cdpMsg, CDPResultCallback callback) {
        this.nativeInvokeCDPFromSDK(this.mLynxDevToolNGPtr, cdpMsg, new CDPResultCallbackWrapper(callback));
    }

    private native void nativeInvokeCDPFromSDK(long var1, String var3, CDPResultCallbackWrapper var4);

    public void updateScreenMetrics(int width, int height, float density) {
        this.nativeUpdateDevice(width, height, density);
    }

    private native void nativeUpdateDevice(int var1, int var2, float var3);
}

