/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool;

import android.content.Context;
import android.util.Log;
import android.view.ViewGroup;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.lynx.debugrouter.ConnectionState;
import com.lynx.debugrouter.ConnectionType;
import com.lynx.debugrouter.DebugRouter;
import com.lynx.debugrouter.DebugRouterGlobalHandler;
import com.lynx.debugrouter.StateListener;
import com.lynx.devtool.LynxDevtoolEnv;
import com.lynx.devtool.LynxInspectorOwner;
import com.lynx.devtool.testbench.SwitchLaunchRecord;
import com.lynx.devtoolwrapper.LynxDevtoolCardListener;
import com.lynx.tasm.LynxEnv;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.eventreport.ILynxEventReportObserver;
import com.lynx.tasm.eventreport.LynxEventReporter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class LynxGlobalDebugBridge
implements DebugRouterGlobalHandler,
StateListener,
ILynxEventReportObserver {
    private static final String TAG = "LynxGlobalDebugBridge";
    public static final String APP_NAME = "Unspecified";
    public static final String APP_VERSION = "0.0";
    private static final String RECEIVE_STOP_JS_AT_ENTRY = "D2RStopAtEntry";
    private static final String SEND_STOP_JS_AT_ENTRY = "R2DStopAtEntry";
    private static final String RECEIVE_STOP_LEPUS_AT_ENTRY = "D2RStopLepusAtEntry";
    private static final String SEND_STOP_LEPUS_AT_ENTRY = "R2DStopLepusAtEntry";
    private static final String CUSTOM_FOR_SET_GLOBAL_SWITCH = "SetGlobalSwitch";
    private static final String CUSTOM_FOR_GET_GLOBAL_SWITCH = "GetGlobalSwitch";
    private boolean mHasContext = false;
    private Context mContext;
    private WeakReference<ViewGroup> mRootView = null;
    private DevToolAgentDispatcher mAgentDispatcher;
    private SwitchLaunchRecord mSwitchLaunchRecord;
    private Set<LynxDevtoolCardListener> mCardListeners = new HashSet<LynxDevtoolCardListener>();

    public static LynxGlobalDebugBridge getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static boolean autoDevToolConnect(String scheme) {
        LynxEnv.inst().lazyInitIfNeeded();
        LynxEnv.inst().enableLynxDebug(true);
        LynxEnv.inst().enableDevtool(true);
        LynxEnv.inst().enablePixelCopy(true);
        LynxDevtoolEnv.inst().enableLongPressMenu(false);
        HashMap<String, String> lynxInfo = new HashMap<String, String>();
        lynxInfo.put("sdkVersion", LynxEnv.inst().getLynxVersion());
        DebugRouter.getInstance().setAppInfo(null, lynxInfo);
        LynxGlobalDebugBridge bridge = LynxGlobalDebugBridge.getInstance();
        if (bridge.shouldPrepareRemoteDebug(scheme)) {
            return bridge.prepareRemoteDebug(scheme);
        }
        Log.e((String)TAG, (String)("prepareRemoteDebug failed with  " + scheme));
        return false;
    }

    private static void autoSwitchToV8(int enableV8) {
        LynxEnv.inst().lazyInitIfNeeded();
        LynxDevtoolEnv.inst().enableV8(enableV8);
    }

    private static void autoSwitchToDebugMode(boolean enableDebugMode) {
        LynxEnv.inst().lazyInitIfNeeded();
        LynxEnv.inst().enableDebugMode(enableDebugMode);
    }

    private LynxGlobalDebugBridge() {
        this.mAgentDispatcher = new DevToolAgentDispatcher();
        DebugRouter.getInstance().addGlobalHandler((DebugRouterGlobalHandler)this);
        DebugRouter.getInstance().addStateListener((StateListener)this);
        this.mSwitchLaunchRecord = new SwitchLaunchRecord();
        LynxEventReporter.addObserver((ILynxEventReportObserver)this);
    }

    public void setContext(Context ctx) {
        if (this.mHasContext) {
            return;
        }
        this.mContext = ctx;
        this.mHasContext = true;
    }

    public boolean shouldPrepareRemoteDebug(String url) {
        return DebugRouter.getInstance().isValidSchema(url);
    }

    public boolean prepareRemoteDebug(String scheme) {
        return DebugRouter.getInstance().handleSchema(scheme);
    }

    public void setAppInfo(Context context, Map<String, String> appInfo) {
        if (appInfo == null) {
            return;
        }
        appInfo.put("sdkVersion", LynxEnv.inst().getLynxVersion());
        DebugRouter.getInstance().setAppInfo(context, appInfo);
    }

    public boolean isEnabled() {
        return DebugRouter.getInstance().getConnectionState() == ConnectionState.CONNECTED;
    }

    public void registerCardListener(LynxDevtoolCardListener listener) {
        if (listener != null) {
            this.mCardListeners.add(listener);
        }
    }

    public void openCard(String url) {
        for (LynxDevtoolCardListener listener : this.mCardListeners) {
            LLog.i((String)TAG, (String)("openCard: " + url + ", handled by " + listener.getClass().getName()));
            listener.open(url);
        }
    }

    public void onMessage(String type, int sessionId, String message) {
        if (type == null || message == null) {
            return;
        }
        if (type.equals(RECEIVE_STOP_JS_AT_ENTRY)) {
            boolean stop = message.equals("true");
            this.mAgentDispatcher.setStopAtEntry(stop);
            DebugRouter.getInstance().sendDataAsync(SEND_STOP_JS_AT_ENTRY, -1, message);
        } else if (type.equals(RECEIVE_STOP_LEPUS_AT_ENTRY)) {
            boolean stop = message.equals("true");
            this.mAgentDispatcher.setStopLepusAtEntry(stop);
            DebugRouter.getInstance().sendDataAsync(SEND_STOP_LEPUS_AT_ENTRY, -1, message);
        } else if (type.equals(CUSTOM_FOR_SET_GLOBAL_SWITCH)) {
            Object result = this.mAgentDispatcher.setGlobalSwitch(message);
            DebugRouter.getInstance().sendDataAsync(CUSTOM_FOR_SET_GLOBAL_SWITCH, -1, String.valueOf(result));
        } else if (type.equals(CUSTOM_FOR_GET_GLOBAL_SWITCH)) {
            Object result = this.mAgentDispatcher.getGlobalSwitch(message);
            DebugRouter.getInstance().sendDataAsync(CUSTOM_FOR_GET_GLOBAL_SWITCH, -1, String.valueOf(result));
        }
    }

    public void startRecord() {
        this.mSwitchLaunchRecord.startRecord();
    }

    public void onClose(int code, String reason) {
        this.enableTraceMode(false);
    }

    private void enableTraceMode(boolean enable) {
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_dom_tree", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_quickjs_debug", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_v8", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_preview_screen_shot", !enable);
        LynxDevtoolEnv.inst().setDevtoolEnvMask("enable_highlight_touch", !enable);
    }

    public void onError(String error) {
        this.enableTraceMode(false);
    }

    public void onOpen(ConnectionType type) {
        LynxDevtoolEnv.inst().setDevtoolEnv("devtool_connected", true);
    }

    public void onMessage(String text) {
    }

    public void onReportEvent(@NonNull String eventName, int instanceId, @NonNull Map<String, ?> props, @Nullable Map<String, ?> extraData) {
        this.onPerfMetricsEvent(eventName, new JSONObject(props), instanceId);
    }

    public void onPerfMetricsEvent(String eventName, @NonNull JSONObject data, int instanceId) {
        if (LynxDevtoolEnv.inst().isPerfMetricsEnabled() && this.mAgentDispatcher != null) {
            try {
                data.put("instanceId", instanceId);
                this.mAgentDispatcher.onPerfMetricsEvent(eventName, data);
            }
            catch (JSONException e) {
                LLog.e((String)TAG, (String)e.toString());
            }
        }
    }

    private static class DevToolAgentDispatcher
    extends LynxInspectorOwner {
        private DevToolAgentDispatcher() {
        }
    }

    private static class SingletonHolder {
        private static final LynxGlobalDebugBridge INSTANCE = new LynxGlobalDebugBridge();

        private SingletonHolder() {
        }
    }
}

