/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import com.lynx.devtool.network.DownloadCallback;
import com.lynx.devtool.network.LynxDevToolDownloader;
import com.lynx.tasm.base.LLog;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;

public class LepusDebugInfoHelper {
    private static final String TAG = "LepusDebugInfoHelper";
    private AtomicBoolean mIsLoading = new AtomicBoolean(false);
    private String mDebugInfoUrl;
    private String mDebugInfo;

    public void setDebugInfoUrl(String url) {
        this.mDebugInfoUrl = url;
    }

    public String getDebugInfoUrl() {
        return this.mDebugInfoUrl;
    }

    public String getDebugInfo(String url) {
        LLog.i((String)TAG, (String)("lepus debug: debug info url: " + url));
        this.setDebugInfoUrl(url);
        this.mIsLoading.set(true);
        this.downloadDebugInfo();
        try {
            while (this.mIsLoading.get()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException e) {
            LLog.e((String)TAG, (String)e.toString());
        }
        return this.mDebugInfo;
    }

    private void downloadDebugInfo() {
        new LynxDevToolDownloader(this.mDebugInfoUrl, new DownloadCallback(){

            @Override
            public void onResponse(int status, int contentLength) {
            }

            @Override
            public void onData(byte[] bytes, int length) {
                LepusDebugInfoHelper.this.mDebugInfo = new String(bytes, Charset.defaultCharset());
                LepusDebugInfoHelper.this.mIsLoading.set(false);
            }

            @Override
            public void onFailure(String reason) {
                LepusDebugInfoHelper.this.mDebugInfo = "";
                LepusDebugInfoHelper.this.mIsLoading.set(false);
                LLog.e((String)LepusDebugInfoHelper.TAG, (String)("lepus debug: download debug info failed, the reason is: " + reason));
            }
        });
    }
}

