/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import android.text.Layout;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.behavior.ui.LynxBaseUI;
import com.lynx.tasm.behavior.ui.LynxUI;
import java.lang.reflect.Field;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestbenchDumpFileHelper {
    private static final String TAG = "TestbenchDumpFileHelper";

    public static String getViewTree(View rootView) {
        return TestbenchDumpFileHelper.getViewTreeRecursive(rootView).toString();
    }

    private static JSONObject getViewTreeRecursive(View view) {
        JSONObject node = new JSONObject();
        try {
            int count;
            String name;
            Class<?> clz = view.getClass();
            switch (name = clz.getSimpleName()) {
                case "LynxImageView": {
                    try {
                        Field field = clz.getDeclaredField("mTagName");
                        field.setAccessible(true);
                        String tagName = (String)field.get(view);
                        if ("filter-image".equals(tagName)) {
                            name = "FrescoFilterImageView";
                            break;
                        }
                        name = "FrescoImageView";
                        break;
                    }
                    catch (Throwable e) {
                        String err = Log.getStackTraceString((Throwable)e);
                        LLog.e((String)TAG, (String)err);
                        name = err;
                    }
                }
            }
            node.put("name", (Object)name);
            node.put("left", view.getLeft());
            node.put("top", view.getTop());
            node.put("width", view.getWidth());
            node.put("height", view.getHeight());
            if (view instanceof ViewGroup && (count = ((ViewGroup)view).getChildCount()) > 0) {
                JSONArray childrenNodes = new JSONArray();
                for (int i = 0; i < count; ++i) {
                    childrenNodes.put((Object)TestbenchDumpFileHelper.getViewTreeRecursive(((ViewGroup)view).getChildAt(i)));
                }
                node.put("children", (Object)childrenNodes);
            }
        }
        catch (Exception e) {
            LLog.e((String)TAG, (String)e.toString());
        }
        return node;
    }

    public static String getUITree(LynxBaseUI rootUI) {
        return TestbenchDumpFileHelper.getUITreeRecursive(rootUI).toString();
    }

    private static JSONObject getUITreeRecursive(LynxBaseUI ui) {
        JSONObject node = new JSONObject();
        try {
            String name;
            switch (name = ui.getClass().getSimpleName()) {
                case "LynxImageUI": {
                    if ("filter-image".equals(ui.getTagName())) {
                        name = "UIFilterImage";
                        break;
                    }
                    name = "UIImage";
                    break;
                }
                case "LynxFlattenImageUI": {
                    name = "FlattenUIImage";
                }
            }
            node.put("name", (Object)name);
            node.put("left", ui.getLeft());
            node.put("top", ui.getTop());
            node.put("width", ui.getWidth());
            node.put("height", ui.getHeight());
            TestbenchDumpFileHelper.getSpecificInfo(ui, node);
            List children = ui.getChildren();
            if (children.size() > 0) {
                JSONArray childrenNodes = new JSONArray();
                for (LynxBaseUI child : children) {
                    childrenNodes.put((Object)TestbenchDumpFileHelper.getUITreeRecursive(child));
                }
                node.put("children", (Object)childrenNodes);
            }
        }
        catch (Exception e) {
            LLog.e((String)TAG, (String)e.toString());
        }
        return node;
    }

    private static void getSpecificInfo(LynxBaseUI ui, JSONObject node) throws Exception {
        Class<?> clz = ui.getClass();
        String name = clz.getSimpleName();
        if (name.equals("LynxImageUI") || name.equals("LynxFlattenImageUI")) {
            TestbenchDumpFileHelper.setLynxImageUIInfo(ui, node);
        } else if (name.equals("FlattenUIImage")) {
            TestbenchDumpFileHelper.setFlattenUIImageInfo(clz, ui, node);
        } else if (name.equals("UIText")) {
            TestbenchDumpFileHelper.setTextInfo(((LynxUI)ui).getView(), node);
        } else if (name.equals("FlattenUIText")) {
            TestbenchDumpFileHelper.setTextInfo(ui, node);
        }
    }

    private static void setFlattenUIImageInfo(Class imageClz, LynxBaseUI ui, JSONObject node) throws Exception {
        Field lynxImageManagerField = imageClz.getDeclaredField("mLynxImageManager");
        lynxImageManagerField.setAccessible(true);
        Object lynxImageManager = lynxImageManagerField.get(ui);
        Class<?> lynxImageManagerClz = lynxImageManager.getClass();
        Field imageSourceField = lynxImageManagerClz.getDeclaredField("mImageSource");
        imageSourceField.setAccessible(true);
        Object imageSource = imageSourceField.get(lynxImageManager);
        Class<?> imageSourceClz = imageSource.getClass();
        Field sourceField = imageSourceClz.getDeclaredField("mSource");
        sourceField.setAccessible(true);
        node.put("src", sourceField.get(imageSource));
    }

    private static void setLynxImageUIInfo(Object imageUI, JSONObject node) throws Exception {
        Class<?> imageClz = imageUI.getClass();
        Field imageDelegateField = imageClz.getDeclaredField("mImageDelegate");
        imageDelegateField.setAccessible(true);
        Object imageDelegate = imageDelegateField.get(imageUI);
        Class<?> imageDelegateClz = imageDelegate.getClass();
        Field src = imageDelegateClz.getDeclaredField("mSrc");
        src.setAccessible(true);
        node.put("src", src.get(imageDelegate));
    }

    private static void setTextInfo(Object androidView, JSONObject node) throws Exception {
        Class<?> androidTextClz = androidView.getClass();
        Field layoutField = androidTextClz.getDeclaredField("mTextLayout");
        layoutField.setAccessible(true);
        Layout layout = (Layout)layoutField.get(androidView);
        node.put("alignment", (Object)layout.getAlignment().toString());
        node.put("textSize", (double)layout.getPaint().getTextSize());
    }
}

