/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.helper;

import android.graphics.Rect;
import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.lynx.tasm.LynxView;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.behavior.LynxContext;
import com.lynx.tasm.behavior.LynxUIOwner;
import com.lynx.tasm.behavior.ui.LynxBaseUI;
import com.lynx.tasm.behavior.ui.LynxUI;
import com.lynx.tasm.behavior.ui.UIBody;
import com.lynx.tasm.behavior.ui.text.AndroidText;
import com.lynx.tasm.behavior.ui.text.FlattenUIText;
import com.lynx.tasm.behavior.ui.text.UIText;
import com.lynx.tasm.event.EventsListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class UITreeHelper {
    private static final String TAG = UITreeHelper.class.getSimpleName();
    private WeakReference<LynxUIOwner> mUIOwner;

    public void attachLynxUIOwner(LynxUIOwner uiOwner) {
        this.mUIOwner = new WeakReference<LynxUIOwner>(uiOwner);
    }

    public float[] getRectToWindow() {
        LynxUIOwner uiOwner;
        float[] res = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        LynxUIOwner lynxUIOwner = uiOwner = this.mUIOwner != null ? (LynxUIOwner)this.mUIOwner.get() : null;
        if (uiOwner == null || uiOwner.getRootSign() == -1) {
            return res;
        }
        LynxBaseUI ui = uiOwner.getNode(uiOwner.getRootSign());
        if (ui != null) {
            Rect re = ui.getRectToWindow();
            res[0] = re.left;
            res[1] = re.top;
            res[2] = re.width();
            res[3] = re.height();
        }
        return res;
    }

    public void getViewLocationOnScreen(int[] res) {
        LynxUIOwner uiOwner;
        LynxUIOwner lynxUIOwner = uiOwner = this.mUIOwner != null ? (LynxUIOwner)this.mUIOwner.get() : null;
        if (res == null || res.length < 2 || uiOwner == null || uiOwner.getContext() == null) {
            return;
        }
        LynxView view = uiOwner.getContext().getLynxView();
        if (view != null) {
            view.getLocationOnScreen(res);
            LynxContext context = view.getLynxContext();
            if (context != null) {
                float scale = context.getResources().getDisplayMetrics().density;
                res[0] = (int)((float)res[0] / scale);
                res[1] = (int)((float)res[1] / scale);
            }
        }
    }

    public String getLynxUITree() {
        LynxUIOwner uiOwner;
        LynxUIOwner lynxUIOwner = uiOwner = this.mUIOwner != null ? (LynxUIOwner)this.mUIOwner.get() : null;
        if (uiOwner == null) {
            return "";
        }
        UIBody root = uiOwner.getRootUI();
        if (root == null) {
            return "";
        }
        Map<String, Object> map = this.getLynxUITreeRecursive((LynxBaseUI)root);
        try {
            JSONObject jsonObject = UITreeHelper.getJsonFromMap(map);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)"UITree: getLynxUITree fail");
            return "";
        }
    }

    private Map<String, Object> getLynxUITreeRecursive(@NonNull LynxBaseUI ui) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", ui.getClass().getName());
        map.put("id", ui.getSign());
        map.put("frame", new JSONArray(Arrays.asList(ui.getOriginLeft(), ui.getOriginTop(), ui.getWidth(), ui.getHeight())));
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (LynxBaseUI child : ui.getChildren()) {
            list.add(this.getLynxUITreeRecursive(child));
        }
        map.put("children", new JSONArray(list));
        return map;
    }

    private static JSONObject getJsonFromMap(Map<String, Object> map) throws JSONException {
        JSONObject jsonData = new JSONObject();
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                value = UITreeHelper.getJsonFromMap((Map)value);
            }
            jsonData.put(key, value);
        }
        return jsonData;
    }

    private static HashMap<String, Object> getEditablePropertyValueOfUI(@NonNull LynxBaseUI ui) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("border", new JSONArray(Arrays.asList(ui.getBorderTopWidth(), ui.getBorderRightWidth(), ui.getBorderBottomWidth(), ui.getBorderLeftWidth())));
        map.put("margin", new JSONArray(Arrays.asList(ui.getMarginTop(), ui.getMarginRight(), ui.getMarginBottom(), ui.getMarginLeft())));
        map.put("frame", new JSONArray(Arrays.asList(ui.getOriginLeft(), ui.getOriginTop(), ui.getWidth(), ui.getHeight())));
        map.put("visible", ui.getVisibility());
        return map;
    }

    private static HashMap<String, Object> getReadPropertyValueOfUI(@NonNull LynxBaseUI ui) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LynxBaseUI.TransOffset transOffset = ui.getTransformValue(0.0f, 0.0f, 0.0f, 0.0f);
        map.put("locationToScreen", new JSONArray(Arrays.asList(Float.valueOf(transOffset.left_top[0]), Float.valueOf(transOffset.left_top[1]), Float.valueOf(transOffset.right_bottom[0]), Float.valueOf(transOffset.right_bottom[1]))));
        map.put("clickable", ui.isClickable());
        map.put("long-clickable", ui.isLongClickable());
        map.put("scrollable", ui.isScrollable());
        map.put("focusable", ui.isFocusable());
        Map events = ui.getEvents();
        if (events != null) {
            HashMap<String, String> eventMap = new HashMap<String, String>();
            for (EventsListener event : events.values()) {
                String name = event.name;
                if (event.type != null) {
                    name = event.type.equals("bindEvent") ? "bind" + name : (event.type.equals("catchEvent") ? "catch" + name : (event.type.equals("capture-bindEvent") ? "capture-bind" + name : (event.type.equals("capture-catchEvent") ? "capture-catch" + name : event.type + name)));
                }
                eventMap.put(name, event.functionName);
            }
            map.put("events", eventMap);
        }
        String text = "";
        if (ui instanceof FlattenUIText) {
            if (((FlattenUIText)ui).getText() != null) {
                text = ((FlattenUIText)ui).getText().toString();
            }
            map.put("text", text);
        } else if (ui instanceof UIText) {
            if (((AndroidText)((UIText)ui).getView()).getText() != null) {
                text = ((AndroidText)((UIText)ui).getView()).getText().toString();
            }
            map.put("text", text);
        }
        View view = null;
        view = ui.isFlatten() && ui.getDrawParent() != null ? ((LynxUI)ui.getDrawParent()).getView() : ((LynxUI)ui).getView();
        map.put("lynx-test-tag", ui.getTestID());
        if (view == null) {
            LLog.e((String)TAG, (String)"getReadPropertyValueOfUI: view is null");
            return map;
        }
        map.put("activated", view.isActivated());
        map.put("alpha", Float.valueOf(view.getAlpha()));
        map.put("has-window-focus", view.hasWindowFocus());
        if (ui.isScrollable()) {
            String scroll_left = view.canScrollHorizontally(-1) ? "left " : "";
            String scroll_right = view.canScrollHorizontally(1) ? "right " : "";
            String scroll_up = view.canScrollVertically(-1) ? "up " : "";
            String scroll_down = view.canScrollVertically(1) ? "down " : "";
            String scroll = scroll_left + scroll_right + scroll_up + scroll_down;
            if (scroll != "") {
                scroll = scroll.substring(0, scroll.length() - 1);
            }
            map.put("scroll-direction", scroll);
        }
        return map;
    }

    void getAllDeclaredFieldForCurrentClass(Class currentClass, Object obj, Map<String, Object> map) {
        Field[] fields;
        if (currentClass == null) {
            LLog.e((String)TAG, (String)"getAllDeclaredFieldForCurrentClass: currentClass is null");
            return;
        }
        for (Field field : fields = currentClass.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                String name = field.getName();
                Object value = field.get(obj);
                map.put(name, value.toString());
            }
            catch (Exception e) {
                LLog.e((String)TAG, (String)"UITree: getAllDeclaredFieldForCurrentClass fail when getUINodeInfo");
            }
        }
    }

    private HashMap<String, Object> getAllPropertyAndValues(Object obj, String type) {
        Class<?> currentClass;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj == null || type == null) {
            LLog.e((String)TAG, (String)"getAllPropertyAndValues: obj or type is null");
            return map;
        }
        Class stopClass = type.equals("view") ? View.class : LynxBaseUI.class;
        this.getAllDeclaredFieldForCurrentClass(currentClass, obj, map);
        for (currentClass = obj.getClass(); currentClass != stopClass; currentClass = currentClass.getSuperclass()) {
            this.getAllDeclaredFieldForCurrentClass(currentClass, obj, map);
        }
        return map;
    }

    public String getUINodeInfo(int id2) {
        LynxUIOwner uiOwner;
        String res = new String();
        LynxUIOwner lynxUIOwner = uiOwner = this.mUIOwner != null ? (LynxUIOwner)this.mUIOwner.get() : null;
        if (uiOwner == null) {
            return "";
        }
        LynxBaseUI ui = uiOwner.getNode(id2);
        if (ui == null) {
            return "";
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", ui.getSign());
            map.put("isFlatten", ui.isFlatten());
            map.put("editableProps", UITreeHelper.getEditablePropertyValueOfUI(ui));
            map.put("readonlyProps", UITreeHelper.getReadPropertyValueOfUI(ui));
            HashMap<String, Object> ui_map = new HashMap<String, Object>();
            ui_map.put("name", ui.getClass().getName());
            ui_map.put("readonlyProps", this.getAllPropertyAndValues(ui, "ui"));
            map.put("ui", ui_map);
            if (!ui.isFlatten()) {
                LynxUI lynxUI = (LynxUI)ui;
                HashMap<String, Object> view_map = new HashMap<String, Object>();
                view_map.put("name", lynxUI.getView().getClass().getName());
                view_map.put("readonlyProps", this.getAllPropertyAndValues(lynxUI.getView(), "view"));
                map.put("view", view_map);
            }
            JSONObject jsonObject = UITreeHelper.getJsonFromMap(map);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)"UITree: getUINodeInfo fail!");
            return "";
        }
    }

    float[] stringToArrayValue(String strValue) {
        try {
            float[] res = new float[4];
            strValue = strValue.replace(" ", "");
            String[] arr = strValue.split(",");
            res[0] = Float.parseFloat(arr[0]);
            res[1] = Float.parseFloat(arr[1]);
            res[2] = Float.parseFloat(arr[2]);
            res[3] = Float.parseFloat(arr[3]);
            return res;
        }
        catch (Exception e) {
            LLog.e((String)TAG, (String)"UITree Debug:parse frame value string fail");
            return new float[0];
        }
    }

    private int setUIFrame(LynxBaseUI baseUI, String styleContent) {
        if (baseUI == null) {
            return -1;
        }
        float[] frame_value = this.stringToArrayValue(styleContent);
        if (frame_value.length != 0) {
            baseUI.setLeft((int)frame_value[0]);
            baseUI.setTop((int)frame_value[1]);
            baseUI.setWidth((int)frame_value[2]);
            baseUI.setHeight((int)frame_value[3]);
            return 0;
        }
        return -1;
    }

    private int setUIBorder(LynxBaseUI baseUI, String styleContent) {
        if (baseUI == null) {
            return -1;
        }
        float[] border_value = this.stringToArrayValue(styleContent);
        if (border_value.length != 0) {
            baseUI.setBorderWidth(1, (int)border_value[3]);
            baseUI.setBorderWidth(2, (int)border_value[1]);
            baseUI.setBorderWidth(3, (int)border_value[0]);
            baseUI.setBorderWidth(4, (int)border_value[2]);
            baseUI.updateLayout(baseUI.getLeft(), baseUI.getTop(), baseUI.getWidth(), baseUI.getHeight(), baseUI.getPaddingLeft(), baseUI.getPaddingTop(), baseUI.getPaddingRight(), baseUI.getPaddingBottom(), baseUI.getMarginLeft(), baseUI.getMarginTop(), baseUI.getMarginRight(), baseUI.getMarginBottom(), (int)border_value[3], (int)border_value[0], (int)border_value[1], (int)border_value[2], baseUI.getBound());
            return 0;
        }
        return -1;
    }

    private int setUIMargin(LynxBaseUI baseUI, String styleContent) {
        if (baseUI == null) {
            return -1;
        }
        float[] margin_value = this.stringToArrayValue(styleContent);
        if (margin_value.length != 0) {
            int topWidth = (int)margin_value[0];
            int rightWidth = (int)margin_value[1];
            int bottomWidth = (int)margin_value[2];
            int leftWidth = (int)margin_value[3];
            baseUI.updateLayout(baseUI.getLeft() - baseUI.getMarginLeft() + leftWidth, baseUI.getTop() - baseUI.getMarginTop() + topWidth, baseUI.getWidth(), baseUI.getHeight(), baseUI.getPaddingLeft(), baseUI.getPaddingTop(), baseUI.getPaddingRight(), baseUI.getPaddingBottom(), leftWidth, topWidth, rightWidth, bottomWidth, baseUI.getBorderLeftWidth(), baseUI.getBorderTopWidth(), baseUI.getBorderRightWidth(), baseUI.getBorderBottomWidth(), baseUI.getBound());
            return 0;
        }
        return -1;
    }

    private int setUIBackgroundColor(LynxBaseUI baseUI, String styleContent) {
        try {
            styleContent = styleContent.substring(1);
            styleContent = styleContent.substring(6) + styleContent.substring(0, 6);
            int color2 = Integer.parseUnsignedInt(styleContent, 16);
            baseUI.setBackgroundColor(color2);
            return 0;
        }
        catch (Exception e) {
            LLog.e((String)TAG, (String)"UITree Debug:parse color value string fail");
            return -1;
        }
    }

    private int setUIBorderColor(LynxBaseUI baseUI, String styleContent) {
        try {
            styleContent = styleContent.substring(1);
            styleContent = styleContent.substring(6) + styleContent.substring(0, 6);
            int color2 = Integer.parseUnsignedInt(styleContent, 16);
            baseUI.setBorderColor(0, Integer.valueOf(color2));
            baseUI.setBorderColor(1, Integer.valueOf(color2));
            baseUI.setBorderColor(2, Integer.valueOf(color2));
            baseUI.setBorderColor(3, Integer.valueOf(color2));
            return 0;
        }
        catch (Exception e) {
            LLog.e((String)TAG, (String)"UITree Debug:parse color value string fail");
            return -1;
        }
    }

    private int setUIVisibility(LynxBaseUI baseUI, String styleContent) {
        if (baseUI == null || baseUI.isFlatten() || styleContent == null) {
            return -1;
        }
        LynxUI ui = (LynxUI)baseUI;
        if (styleContent.equals("true")) {
            ui.setVisibility(1);
            return 0;
        }
        if (styleContent.equals("false")) {
            ui.setVisibility(0);
            return 0;
        }
        return -1;
    }

    public int setUIStyle(int id2, String name, String content) {
        LynxBaseUI baseUI;
        LynxUIOwner uiOwner;
        LynxUIOwner lynxUIOwner = uiOwner = this.mUIOwner != null ? (LynxUIOwner)this.mUIOwner.get() : null;
        if (uiOwner != null && name != null && content != null && (baseUI = uiOwner.getNode(id2)) != null) {
            content = content.trim();
            if (name.equals("frame")) {
                return this.setUIFrame(baseUI, content);
            }
            if (name.equals("margin")) {
                return this.setUIMargin(baseUI, content);
            }
            if (name.equals("border")) {
                return this.setUIBorder(baseUI, content);
            }
            if (name.equals("visible")) {
                return this.setUIVisibility(baseUI, content);
            }
            if (name.equals("background-color")) {
                return this.setUIBackgroundColor(baseUI, content);
            }
            if (name.equals("border-color")) {
                return this.setUIBorderColor(baseUI, content);
            }
        }
        return 0;
    }

    @Keep
    public static String getLynxFastbotTweakTree(LynxView lynxView) {
        if (lynxView == null || lynxView.getLynxContext() == null || lynxView.getLynxContext().getLynxUIOwner() == null) {
            return "";
        }
        LynxUIOwner uiOwner = lynxView.getLynxContext().getLynxUIOwner();
        UIBody root = uiOwner.getRootUI();
        if (root == null) {
            return "";
        }
        Map<String, Object> map = UITreeHelper.getLynxFastbotTweakTreeRecursive((LynxBaseUI)root);
        try {
            JSONObject jsonObject = UITreeHelper.getJsonFromMap(map);
            return jsonObject.toString();
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)"UITree: getLynxUITree fail");
            return "";
        }
    }

    private static Map<String, Object> getLynxFastbotTweakTreeRecursive(@NonNull LynxBaseUI ui) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ui.getSign());
        map.put("class", ui.getClass().getName());
        HashMap<String, Object> editableProps = UITreeHelper.getEditablePropertyValueOfUI(ui);
        HashMap<String, Object> readProps = UITreeHelper.getReadPropertyValueOfUI(ui);
        map.putAll(editableProps);
        map.putAll(readProps);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (LynxBaseUI child : ui.getChildren()) {
            list.add(UITreeHelper.getLynxFastbotTweakTreeRecursive(child));
        }
        map.put("children", new JSONArray(list));
        return map;
    }
}

