/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.logbox;

import android.content.Context;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.lynx.devtool.logbox.LogBoxDialogBase;
import com.lynx.devtool.logbox.LynxLogBoxManager;
import com.lynx.devtoolwrapper.LogBoxLogLevel;
import com.lynx.tasm.base.LLog;
import com.lynx.tasm.eventreport.LynxEventReporter;
import com.lynx.tasm.utils.UIThreadUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class LogBoxDialog
extends LogBoxDialogBase {
    private static final String TAG = "LogBoxDialog";
    private static final String QUERY = "?downloadapi=true&supportyellowbox=true";
    private static final String KEY_CALLBACK_ID = "callbackId";
    private static final String KEY_DATA = "data";
    private static final String KEY_NAME = "name";
    private static final String KEY_URL = "url";
    private static final String KEY_VIEW_NUMBER = "viewNumber";
    private static final String KEY_EVENT = "event";
    private static final String KEY_CURRENT_VIEW = "currentView";
    private static final String KEY_VIEWS_COUNT = "viewsCount";
    private static final String KEY_TYPE = "type";
    private static final String KEY_TEMPLATE_URL = "templateUrl";
    private static final String TYPE_REDBOX = "redbox";
    private static final String TYPE_YELLOWBOX = "yellowbox";
    private static final String EVENT_NEW_INFO = "receiveNewLog";
    private static final String EVENT_NEW_WARNING = "receiveNewWarning";
    private static final String EVENT_NEW_ERROR = "receiveNewError";
    private static final String EVENT_VIEW_INFO = "receiveViewInfo";
    private static final String EVENT_RESET = "reset";
    private static final int UNKNOWN_ERROR = -1;
    private static final int JS_ERROR = 1;
    private static final int LEPUS_ERROR = 2;
    private static final int LEPUS_NG_ERROR = 3;
    private static final int NATIVE_ERROR = 4;
    private LogBoxLogLevel mLevel;
    private WeakReference<LynxLogBoxManager> mManager;
    private Runnable mLoadingFinishCallback;
    public Boolean isLoadingFinished = false;

    protected LogBoxDialog(Context context, LynxLogBoxManager manager, Runnable loadingFinishCallback) {
        super(context);
        this.mManager = new WeakReference<LynxLogBoxManager>(manager);
        this.mLoadingFinishCallback = loadingFinishCallback;
        this.initWebView(QUERY, new LogBoxCallback());
    }

    public void updateViewInfo(int currentIndex, int viewCount, LogBoxLogLevel level, String templateUrl) {
        JSONObject event = new JSONObject();
        JSONObject data = new JSONObject();
        String level_str = level == LogBoxLogLevel.Error ? TYPE_REDBOX : TYPE_YELLOWBOX;
        try {
            event.put(KEY_EVENT, (Object)EVENT_VIEW_INFO);
            data.put(KEY_CURRENT_VIEW, currentIndex);
            data.put(KEY_VIEWS_COUNT, viewCount);
            data.put(KEY_TYPE, (Object)level_str);
            data.put(KEY_TEMPLATE_URL, (Object)templateUrl);
            event.put(KEY_DATA, (Object)data);
            this.sendEvent(event);
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.getMessage());
        }
    }

    public void showLogMessages(LogBoxLogLevel level, List<String> logs) {
        if (logs == null) {
            return;
        }
        for (String log : logs) {
            this.showLogMessage(level, log);
        }
    }

    public void showLogMessage(LogBoxLogLevel level, String log) {
        String eventValue = "";
        if (level == LogBoxLogLevel.Info) {
            eventValue = EVENT_NEW_INFO;
        } else if (level == LogBoxLogLevel.Warn) {
            eventValue = EVENT_NEW_WARNING;
        } else if (level == LogBoxLogLevel.Error) {
            eventValue = EVENT_NEW_ERROR;
        }
        JSONObject event = new JSONObject();
        try {
            event.put(KEY_EVENT, (Object)eventValue);
            event.put(KEY_DATA, (Object)log);
            this.sendEvent(event);
        }
        catch (JSONException e) {
            LLog.e((String)TAG, (String)e.getMessage());
        }
    }

    public LogBoxLogLevel getLevel() {
        return this.mLevel;
    }

    public void showWithLevel(LogBoxLogLevel level) {
        this.mLevel = level;
        this.show();
    }

    public void onLoadingFinished() {
        this.isLoadingFinished = true;
    }

    @Override
    public boolean isLoadingFinished() {
        return this.isLoadingFinished;
    }

    public boolean isShowing() {
        return this.isLoadingFinished != false && super.isShowing();
    }

    @Override
    public void reset() {
        LynxLogBoxManager manager = (LynxLogBoxManager)this.mManager.get();
        if (manager != null) {
            manager.onLogBoxDismiss();
        }
        this.sendEvent(EVENT_RESET);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroyWebView();
    }

    private class LogBoxCallback
    extends LogBoxDialogBase.Callback {
        private static final String BRIDGE_NAME = "bridgeName";
        private static final String CASE_GET_EXCEPTION_STACK = "getExceptionStack";
        private static final String CASE_GET_CORE_JS = "getCoreJs";
        private static final String CASE_GET_TEMPLATE_JS = "getTemplateJs";
        private static final String CASE_RELOAD = "reload";
        private static final String CASE_DISMISS = "dismiss";
        private static final String CASE_DOWNLOAD = "download";
        private static final String CASE_REMOVE_CURRENT_LOGS = "deleteLynxview";
        private static final String CASE_SWITCH_LOGS = "changeView";
        private static final String CASE_TOAST = "toast";
        private static final String CASE_REPORT_EVENT = "reportEvent";
        private static final String EVENT_REPORT_FEEDBACK = "lynxsdk_redbox_feedback";
        private static final String CASE_QUERY_RESOURCE = "queryResource";

        private LogBoxCallback() {
        }

        @JavascriptInterface
        public void postMessage(String strParams) {
            try {
                JSONObject params = new JSONObject(strParams);
                switch (params.getString(BRIDGE_NAME)) {
                    case "getExceptionStack": {
                        this.loadMappingsWasm();
                        UIThreadUtils.runOnUiThread((Runnable)LogBoxDialog.this.mLoadingFinishCallback);
                        this.sendResult(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), new ArrayList<String>());
                        break;
                    }
                    case "getCoreJs": {
                        this.sendResult(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), this.getCoreJs());
                        break;
                    }
                    case "getTemplateJs": {
                        JSONObject data = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                        this.sendResult(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), this.getTemplateJs(data.getString(LogBoxDialog.KEY_NAME)));
                        break;
                    }
                    case "reload": {
                        this.reload();
                        break;
                    }
                    case "dismiss": {
                        this.dismiss();
                        break;
                    }
                    case "download": {
                        JSONObject dataWithUrl = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                        String url = dataWithUrl.getString(LogBoxDialog.KEY_URL);
                        this.download(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), url);
                        break;
                    }
                    case "deleteLynxview": {
                        this.removeLogsOfCurrentView();
                        this.requestLogsOfCurrentView();
                        break;
                    }
                    case "changeView": {
                        JSONObject changeViewData = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                        int nextViewIndex = changeViewData.getInt(LogBoxDialog.KEY_VIEW_NUMBER);
                        this.requestLogsOfViewIndex(nextViewIndex);
                        break;
                    }
                    case "toast": {
                        JSONObject toastData = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                        final String toastMsg = toastData.getString("message");
                        if (TextUtils.isEmpty((CharSequence)toastMsg)) break;
                        UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Toast.makeText((Context)LogBoxDialog.this.getContext(), (CharSequence)toastMsg, (int)0).show();
                            }
                        });
                        break;
                    }
                    case "reportEvent": {
                        JSONObject eventData = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                        this.handleReporting(eventData);
                        break;
                    }
                    case "queryResource": {
                        JSONObject resData = new JSONObject(params.getString(LogBoxDialog.KEY_DATA));
                        String name = resData.getString(LogBoxDialog.KEY_NAME);
                        this.getResource(params.getInt(LogBoxDialog.KEY_CALLBACK_ID), name);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LLog.e((String)LogBoxDialog.TAG, (String)e.getMessage());
            }
        }

        private void reload() {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxManager manager = (LynxLogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.reloadCurrentView(LogBoxDialog.this.mLevel);
                }
            });
        }

        private void dismiss() {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxManager manager = (LynxLogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.dismissDialog();
                }
            });
        }

        private void removeLogsOfCurrentView() {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxManager manager = (LynxLogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.removeLogsOfCurrentView(LogBoxDialog.this.mLevel);
                }
            });
        }

        private void requestLogsOfCurrentView() {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxManager manager = (LynxLogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.requestLogsOfCurrentView(LogBoxDialog.this.mLevel);
                }
            });
        }

        private void requestLogsOfViewIndex(final int viewIndex) {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxManager manager = (LynxLogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager == null) {
                        return;
                    }
                    manager.requestLogsOfViewIndex(viewIndex, LogBoxDialog.this.mLevel);
                }
            });
        }

        private void reportEvent(final String event, final LynxEventReporter.PropsBuilder builder) {
            UIThreadUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    int instanceId = -1;
                    LynxLogBoxManager manager = (LynxLogBoxManager)LogBoxDialog.this.mManager.get();
                    if (manager != null) {
                        instanceId = manager.getInstanceIdOfCurrentView(LogBoxDialog.this.mLevel);
                    }
                    LynxEventReporter.onEvent((String)event, (int)instanceId, (LynxEventReporter.PropsBuilder)builder);
                }
            });
        }

        private void handleReporting(@NonNull JSONObject eventData) {
            String eventName = eventData.optString("eventName");
            JSONObject eventProps = eventData.optJSONObject("eventProps");
            if (TextUtils.isEmpty((CharSequence)eventName) || eventProps == null) {
                LLog.i((String)LogBoxDialog.TAG, (String)"receive invalid event");
                return;
            }
            if (eventName.equals("feedback")) {
                this.reportFeedback(eventProps);
            }
        }

        private void reportFeedback(final @NonNull JSONObject eventProps) {
            final JSONObject errorInfo = eventProps.optJSONObject("error");
            if (errorInfo == null) {
                return;
            }
            this.reportEvent(EVENT_REPORT_FEEDBACK, new LynxEventReporter.PropsBuilder(){

                public Map<String, Object> build() {
                    int errorType = errorInfo.optInt("errorType", -1);
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("is_satisfied", eventProps.optBoolean("isSatisfied"));
                    props.put("source_map_types", eventProps.optString("sourceMapTypes"));
                    props.put("is_stack_parse_success", eventProps.optString("isParseStackSuccess"));
                    props.put("error_message", errorInfo.optString("message"));
                    props.put("original_stack", errorInfo.optString("stack"));
                    switch (errorType) {
                        case 4: {
                            props.put("code", errorInfo.optInt("code"));
                            props.put("fix_suggestion", errorInfo.optString("fixSuggestion"));
                            props.put("context", errorInfo.optString("context"));
                            props.put("native_stack", errorInfo.optString("nativeStack"));
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            props.put("debug_info_url", errorInfo.optString("debugUrl"));
                            break;
                        }
                    }
                    return props;
                }
            });
        }
    }
}

