/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.logbox;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.text.TextUtils;
import com.lynx.devtool.logbox.LogBoxDialog;
import com.lynx.devtool.logbox.LogBoxLifeCycleListenerFragment;
import com.lynx.devtool.logbox.LogBoxNotification;
import com.lynx.devtool.logbox.LynxLogBoxProxy;
import com.lynx.devtoolwrapper.LogBoxLogLevel;
import com.lynx.tasm.base.LLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LynxLogBoxManager {
    private static final String TAG = "LynxLogBoxManager";
    private static final String LIFE_CYCLE_LISTENER_FRAGMENT_TAG = "LynxLogBoxLifeCycleListener";
    private static final int MAX_BRIEF_MSG_SIZE = 50;
    private final WeakReference<Context> mContext;
    private Map<LogBoxLogLevel, LogProxyList> mLogProxyListMap;
    private LogBoxNotification mNotification;
    private LogBoxDialog mLogBox;

    public LynxLogBoxManager(Context context) {
        this.mContext = new WeakReference<Context>(context);
        this.mLogProxyListMap = new HashMap<LogBoxLogLevel, LogProxyList>();
        this.mLogProxyListMap.put(LogBoxLogLevel.Error, new LogProxyList(LogBoxLogLevel.Error));
        this.mLogProxyListMap.put(LogBoxLogLevel.Warn, new LogProxyList(LogBoxLogLevel.Warn));
        this.mNotification = new LogBoxNotification(context, this);
        this.registerLifeCycleListenerIfNeed(context);
    }

    private boolean registerLifeCycleListenerIfNeed(Context context) {
        if (!(context instanceof Activity) || ((Activity)context).isFinishing()) {
            return false;
        }
        Activity activity = (Activity)context;
        if (activity.getFragmentManager().findFragmentByTag(LIFE_CYCLE_LISTENER_FRAGMENT_TAG) != null) {
            return true;
        }
        try {
            activity.getFragmentManager().beginTransaction().add((Fragment)new LogBoxLifeCycleListenerFragment(), LIFE_CYCLE_LISTENER_FRAGMENT_TAG).commit();
        }
        catch (IllegalStateException e) {
            LLog.w((String)TAG, (String)("Failed to register Activity life cycle listener: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public void onNewLog(String msg, LogBoxLogLevel level, LynxLogBoxProxy logBoxProxy) {
        if (logBoxProxy == null) {
            return;
        }
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return;
        }
        boolean isNewPoxy = false;
        proxyList.increaseLogCount();
        if (!proxyList.contains(logBoxProxy)) {
            proxyList.add(logBoxProxy);
            isNewPoxy = true;
        }
        if (this.mLogBox != null && this.mLogBox.isShowing()) {
            if (this.mNotification != null) {
                this.mNotification.invalidate(level);
            }
            if (this.mLogBox.getLevel() != level) {
                return;
            }
            if (proxyList.isCurrentProxy(logBoxProxy)) {
                this.mLogBox.showLogMessage(level, msg);
            } else if (isNewPoxy) {
                this.mLogBox.updateViewInfo(proxyList.currentProxyIndex() + 1, proxyList.getProxiesCount(), level, this.getCurrentTemplateUrl(level));
            }
        } else if (this.mNotification != null && this.registerLifeCycleListenerIfNeed((Context)this.mContext.get())) {
            String briefMessage = LynxLogBoxManager.extractBriefMessage(msg);
            this.mNotification.updateInfo(level, briefMessage, proxyList.getLogCount());
        }
    }

    public void onNotificationClick(final LogBoxLogLevel level) {
        Context context = (Context)this.mContext.get();
        if (context == null) {
            return;
        }
        if (this.mLogBox == null) {
            this.mLogBox = new LogBoxDialog(context, this, new Runnable(){

                @Override
                public void run() {
                    LynxLogBoxManager.this.requestLogsOfCurrentView(level);
                    LynxLogBoxManager.this.requestLogsOfCurrentView(LogBoxLogLevel.Info);
                    if (LynxLogBoxManager.this.mLogBox != null) {
                        LynxLogBoxManager.this.mLogBox.onLoadingFinished();
                    }
                }
            });
        } else {
            this.requestLogsOfCurrentView(level);
            this.requestLogsOfCurrentView(LogBoxLogLevel.Info);
        }
        if (context instanceof Activity && !((Activity)context).isFinishing()) {
            this.mLogBox.showWithLevel(level);
        }
    }

    public void onNotificationClose(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList != null) {
            proxyList.clearLogs(level);
        }
    }

    public void removeLogsOfCurrentView(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return;
        }
        LynxLogBoxProxy proxy = proxyList.currentProxy();
        if (proxy != null) {
            if (this.mNotification != null) {
                this.mNotification.invalidate(level);
            }
            proxyList.removeProxy(proxy);
            proxy.clearLogsWithLevel(level);
        }
    }

    public void requestLogsOfCurrentView(LogBoxLogLevel level) {
        this.requestLogsOfViewIndex(-1, level);
    }

    public void requestLogsOfViewIndex(int viewIndex, LogBoxLogLevel level) {
        LLog.i((String)TAG, (String)("show logs of view index " + viewIndex + " with level " + level));
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return;
        }
        if (viewIndex != -1) {
            proxyList.setCurrentProxyIndex(viewIndex - 1);
        }
        if (this.mLogBox != null) {
            this.mLogBox.updateViewInfo(proxyList.currentProxyIndex() + 1, proxyList.getProxiesCount(), level, this.getCurrentTemplateUrl(level));
            this.mLogBox.setJSSource(this.getAllJsSourceOfCurrentView(level));
            LynxLogBoxProxy proxy = proxyList.currentProxy();
            if (proxy != null) {
                this.mLogBox.showLogMessages(level, proxy.getLogMessages(level));
            }
        }
    }

    public void showConsoleLog(final LynxLogBoxProxy proxy) {
        Context context = (Context)this.mContext.get();
        if (context == null || proxy == null) {
            return;
        }
        if (this.mLogBox == null) {
            this.mLogBox = new LogBoxDialog(context, this, new Runnable(){

                @Override
                public void run() {
                    if (LynxLogBoxManager.this.mLogBox == null) {
                        return;
                    }
                    LynxLogBoxManager.this.mLogBox.updateViewInfo(1, 1, LogBoxLogLevel.Info, proxy.getTemplateUrl());
                    LynxLogBoxManager.this.mLogBox.showLogMessages(LogBoxLogLevel.Info, proxy.getLogMessages(LogBoxLogLevel.Info));
                    LynxLogBoxManager.this.mLogBox.onLoadingFinished();
                }
            });
        } else {
            this.mLogBox.updateViewInfo(1, 1, LogBoxLogLevel.Info, proxy.getTemplateUrl());
            this.mLogBox.showLogMessages(LogBoxLogLevel.Info, proxy.getLogMessages(LogBoxLogLevel.Info));
        }
        if (context instanceof Activity && !((Activity)context).isFinishing()) {
            this.mLogBox.showWithLevel(LogBoxLogLevel.Info);
        }
    }

    protected static String extractBriefMessage(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        String logStr = null;
        JSONObject rawLog = null;
        try {
            JSONObject logJson = new JSONObject(message);
            Object errorMessage = logJson.opt("error");
            if (errorMessage instanceof String) {
                logStr = (String)errorMessage;
                JSONObject errorJson = new JSONObject((String)errorMessage);
                rawLog = errorJson.optJSONObject("rawError");
            } else if (errorMessage instanceof JSONObject) {
                rawLog = ((JSONObject)errorMessage).optJSONObject("rawError");
            }
        }
        catch (JSONException e) {
            LLog.i((String)TAG, (String)("JSONException occurred when extract brief message of error: " + e.getMessage()));
        }
        if (rawLog != null) {
            logStr = rawLog.optString("message", null);
        }
        if (logStr == null) {
            logStr = message;
        }
        if (logStr.length() > 50) {
            logStr = logStr.substring(0, 50);
        }
        logStr = logStr.replace('\n', ' ');
        return logStr;
    }

    public String getCurrentTemplateUrl(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return "";
        }
        LynxLogBoxProxy proxy = proxyList.currentProxy();
        return proxy == null ? "" : proxy.getTemplateUrl();
    }

    public Map<String, Object> getAllJsSourceOfCurrentView(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return null;
        }
        LynxLogBoxProxy proxy = proxyList.currentProxy();
        return proxy == null ? null : proxy.getAllJsSource();
    }

    public void reloadCurrentView(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return;
        }
        LynxLogBoxProxy proxy = proxyList.currentProxy();
        if (proxy != null) {
            proxy.reloadView();
        }
    }

    public void onLynxViewReload(LynxLogBoxProxy proxy) {
        if (proxy == null) {
            return;
        }
        for (Map.Entry<LogBoxLogLevel, LogProxyList> entry : this.mLogProxyListMap.entrySet()) {
            LogProxyList list = entry.getValue();
            if (!list.removeProxy(proxy) || this.mNotification == null) continue;
            this.mNotification.invalidate(entry.getKey());
        }
        if (this.mLogBox != null && this.mLogBox.isShowing()) {
            this.mLogBox.reset();
            this.mLogBox.dismiss();
        } else {
            this.updateNotificationIfNeed();
        }
        proxy.clearAllLogs();
    }

    public void onLogBoxDismiss() {
        this.updateNotificationIfNeed();
    }

    public void dismissDialog() {
        if (this.mLogBox != null) {
            this.mLogBox.reset();
            this.mLogBox.dismiss();
        }
    }

    private void updateNotificationIfNeed() {
        for (Map.Entry<LogBoxLogLevel, LogProxyList> entry : this.mLogProxyListMap.entrySet()) {
            LogProxyList proxyList = entry.getValue();
            if (this.mNotification == null || !this.mNotification.isDirty(entry.getKey()) || !this.registerLifeCycleListenerIfNeed((Context)this.mContext.get())) continue;
            String briefMsg = LynxLogBoxManager.extractBriefMessage(proxyList.getLastLog());
            this.mNotification.updateInfo(entry.getKey(), briefMsg, proxyList.getLogCount());
        }
    }

    public int getInstanceIdOfCurrentView(LogBoxLogLevel level) {
        LogProxyList proxyList = this.mLogProxyListMap.get(level);
        if (proxyList == null) {
            return -1;
        }
        LynxLogBoxProxy proxy = proxyList.currentProxy();
        return proxy == null ? -1 : proxy.getInstanceIdOfCurrentView();
    }

    public void destroy() {
        if (this.mLogBox != null) {
            this.mLogBox.dismiss();
            this.mLogBox = null;
        }
        if (this.mNotification != null) {
            this.mNotification.destroy();
            this.mNotification = null;
        }
    }

    private class LogProxyList {
        public static final int CURRENT_VIEW = -1;
        private final LogBoxLogLevel mLevel;
        private final List<LynxLogBoxProxy> mProxyList;
        private int mCurrentProxyIndex;
        private int mLogCount;

        public LogProxyList(LogBoxLogLevel level) {
            this.mLevel = level;
            this.mProxyList = new ArrayList<LynxLogBoxProxy>();
            this.mCurrentProxyIndex = 0;
            this.mLogCount = 0;
        }

        public LogBoxLogLevel getLevel() {
            return this.mLevel;
        }

        public boolean isCurrentProxy(LynxLogBoxProxy proxy) {
            int index;
            return proxy != null && (index = this.mProxyList.indexOf(proxy)) != -1 && index == this.mCurrentProxyIndex;
        }

        public void increaseLogCount() {
            ++this.mLogCount;
        }

        public boolean contains(LynxLogBoxProxy proxy) {
            return this.mProxyList.contains(proxy);
        }

        public boolean add(LynxLogBoxProxy proxy) {
            return this.mProxyList.add(proxy);
        }

        public int getLogCount() {
            return this.mLogCount;
        }

        public int getProxiesCount() {
            return this.mProxyList.size();
        }

        public int currentProxyIndex() {
            LLog.i((String)LynxLogBoxManager.TAG, (String)("current proxy index is " + this.mCurrentProxyIndex));
            return this.mCurrentProxyIndex;
        }

        public boolean setCurrentProxyIndex(int index) {
            if (index >= 0 && index < this.mProxyList.size()) {
                LLog.i((String)LynxLogBoxManager.TAG, (String)("set current proxy index " + index));
                this.mCurrentProxyIndex = index;
                return true;
            }
            return false;
        }

        public LynxLogBoxProxy currentProxy() {
            if (this.mCurrentProxyIndex >= this.mProxyList.size() || this.mCurrentProxyIndex < 0) {
                LLog.e((String)LynxLogBoxManager.TAG, (String)"current proxy index out of bounds");
                return null;
            }
            return this.mProxyList.get(this.mCurrentProxyIndex);
        }

        public boolean removeProxy(LynxLogBoxProxy proxy) {
            if (proxy == null || !this.mProxyList.contains(proxy)) {
                return false;
            }
            int logCount = proxy.getLogCount(this.mLevel);
            this.mLogCount -= logCount;
            this.mProxyList.remove(proxy);
            this.mCurrentProxyIndex = this.mProxyList.isEmpty() ? 0 : this.mCurrentProxyIndex % this.mProxyList.size();
            return true;
        }

        public void clearLogs(LogBoxLogLevel level) {
            for (LynxLogBoxProxy proxy : this.mProxyList) {
                proxy.clearLogsWithLevel(level);
            }
            this.mProxyList.clear();
            this.mLogCount = 0;
            this.mCurrentProxyIndex = 0;
        }

        public String getLastLog() {
            if (this.mProxyList.isEmpty()) {
                return "";
            }
            LynxLogBoxProxy proxy = this.mProxyList.get(this.mProxyList.size() - 1);
            return proxy.getLastLog(this.mLevel);
        }
    }
}

