/*
 * Decompiled with CFR 0.152.
 */
package com.lynx.devtool.logbox;

import android.app.Activity;
import android.content.Context;
import com.lynx.devtool.logbox.LynxLogBoxManager;
import com.lynx.devtool.logbox.LynxLogBoxProxy;
import com.lynx.devtoolwrapper.LogBoxLogLevel;
import com.lynx.tasm.base.LLog;
import java.util.WeakHashMap;

public class LynxLogBoxOwner {
    private static final String TAG = "LynxLogBoxOwner";
    private WeakHashMap<Context, LynxLogBoxManager> mLogBoxManagers = new WeakHashMap();

    public static LynxLogBoxOwner getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private LynxLogBoxOwner() {
    }

    public void dispatch(String msg, LogBoxLogLevel level, Context activity, LynxLogBoxProxy logBoxProxy) {
        LynxLogBoxManager manager = this.findManagerByActivity(activity);
        if (manager != null) {
            manager.onNewLog(msg, level, logBoxProxy);
        }
    }

    public void showConsoleLog(Context activity, LynxLogBoxProxy logBoxProxy) {
        LynxLogBoxManager manager = this.findManagerByActivity(activity);
        if (manager != null) {
            manager.showConsoleLog(logBoxProxy);
        }
    }

    public void onLoadTemplate(Context activity, LynxLogBoxProxy logBoxProxy) {
        LynxLogBoxManager manager = this.findManagerByActivityIfExist(activity);
        if (manager != null) {
            manager.onLynxViewReload(logBoxProxy);
        }
    }

    private LynxLogBoxManager findManagerByActivity(Context activity) {
        if (!(activity instanceof Activity)) {
            LLog.e((String)TAG, (String)"param activity is null or not a Activity");
            return null;
        }
        if (((Activity)activity).isFinishing()) {
            LLog.i((String)TAG, (String)"activity is finishing");
            return null;
        }
        LynxLogBoxManager manager = this.mLogBoxManagers.get(activity);
        if (manager == null) {
            LLog.i((String)TAG, (String)"new activity");
            manager = new LynxLogBoxManager(activity);
            this.mLogBoxManagers.put(activity, manager);
        }
        return manager;
    }

    protected LynxLogBoxManager findManagerByActivityIfExist(Context activity) {
        if (activity == null) {
            LLog.e((String)TAG, (String)"activity is null");
            return null;
        }
        return this.mLogBoxManagers.get(activity);
    }

    private static class SingletonHolder {
        private static final LynxLogBoxOwner INSTANCE = new LynxLogBoxOwner();

        private SingletonHolder() {
        }
    }
}

